package net.spacerulerwill.skygrid_reloaded.ui.widget;

import net.minecraft.class_2561;
import net.minecraft.class_357;
import net.minecraft.class_5250;

public abstract class WeightSlider extends class_357 {
    private final double minValue;
    private final double maxValue;
    private final class_2561 text;

    public WeightSlider(int x, int y, int width, int height, class_2561 text, double minValue, double maxValue, double initialValue) {
        super(x, y, width, height, class_2561.method_43473(), 0.0);
        this.field_22753 = (initialValue - minValue) / (maxValue - minValue);
        this.text = text;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.method_25346();
    }

    private class_5250 createMessage() {
        double weight = getWeight();
        String formattedValue = String.format("%.2f", weight);
        return this.text.method_27661()
                .method_10852(class_2561.method_43470(": "))
                .method_10852(class_2561.method_43470(formattedValue));
    }

    private double getWeight() {
        return this.field_22753 * (this.maxValue - this.minValue) + this.minValue;
    }

    @Override
    protected void method_25346() {
        this.method_25355(this.createMessage());
    }

    protected abstract void applyWeight(double weight);

    @Override
    protected void method_25344() {
        this.applyWeight(this.getWeight());
    }
}
