package net.spacerulerwill.skygrid_reloaded.worldgen;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3233;
import net.minecraft.class_39;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_52;
import net.minecraft.class_5281;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7444;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8174;
import net.minecraft.class_9334;
import net.spacerulerwill.skygrid_reloaded.util.MinecraftRandomAdapter;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.DiscreteProbabilityCollectionSampler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class SkyGridChunkGenerator extends class_2794 {
    public static final MapCodec<SkyGridChunkGenerator> MAP_CODEC = RecordCodecBuilder.mapCodec(instance ->
            instance.group(
                    class_5284.field_24781.fieldOf("settings").forGetter((generator) -> generator.settings),
                    SkyGridChunkGeneratorConfig.CODEC.fieldOf("skygrid_settings").forGetter(SkyGridChunkGenerator::getConfig)
            ).apply(instance, SkyGridChunkGenerator::new)
    );

    public static final int MAX_BOOK_ENCHANTS = 5;

    public static final List<class_5321<class_52>> ARCHEOLOGY_LOOT_TABLES = Arrays.asList(
            class_39.field_43354,
            class_39.field_43353,
            class_39.field_43357,
            class_39.field_43356,
            class_39.field_44648,
            class_39.field_44649
    );

    private final SkyGridChunkGeneratorConfig config;
    private final List<class_1299<?>> entities;
    private final class_6880<class_5284> settings;
    private DiscreteProbabilityCollectionSampler<class_2248> blockProbabilities;
    private DiscreteProbabilityCollectionSampler<class_1792> chestItemProbabilities;

    public SkyGridChunkGenerator(class_6880<class_5284> settings, SkyGridChunkGeneratorConfig config) {
        super(config.checkerboardBiomeSource);
        this.settings = settings;
        this.config = config;
        this.blockProbabilities = new DiscreteProbabilityCollectionSampler<>(new MinecraftRandomAdapter(), config.blocks);

        if (config.chestItems.isEmpty()) {
            this.chestItemProbabilities = null;
        } else {
            this.chestItemProbabilities = new DiscreteProbabilityCollectionSampler<>(new MinecraftRandomAdapter(), config.chestItems);
        }
        this.entities = config.spawnerEntities.stream().toList();

    }

    private static class_5819 getRandomForChunk(class_7138 noiseConfig, int x, int z) {
        return noiseConfig.method_42374().method_60628((1610612741L * (long) x + 805306457L * (long) z + 402653189L) ^ 201326611L);
    }

    private static void addRandomEnchantmentToItemStack(class_1799 itemStack, class_5819 random, class_2378<class_1887> enchantmentRegistry) {
        class_6880<class_1887> enchantmentRegistryEntry = enchantmentRegistry.method_10240(random).get();
        int level = random.method_39332(1, enchantmentRegistryEntry.comp_349().method_8183());
        itemStack.method_7978(enchantmentRegistryEntry, level);
    }

    @Override
    protected MapCodec<? extends class_2794> method_28506() {
        return MAP_CODEC;
    }

    @Override
    public void method_12108(class_3233 chunkRegion, long seed, class_7138 noiseConfig, class_4543 biomeAccess, class_5138 structureAccessor, class_2791 chunk) {
    }

    public SkyGridChunkGeneratorConfig getConfig() {
        return config;
    }

    /*
    Empty methods - irrelevant for now
     */
    @Override
    public void method_12102(class_5281 world, class_2791 chunk, class_5138 structureAccessor) {
    }

    @Override
    public void method_12110(class_3233 region, class_5138 structures, class_7138 noiseConfig, class_2791 chunk) {
    }

    @Override
    public void method_12107(class_3233 region) {
    }

    @Override
    public void method_40450(List<String> text, class_7138 noiseConfig, class_2338 pos) {
    }

    /*
    Used for getting the max block height of any given column in the terrain. Used for structure generation.
    We have no structures so is irrelevant for now - a zero value is fine.
     */
    @Override
    public int method_16397(int x, int z, class_2902.class_2903 heightmap, class_5539 world, class_7138 noiseConfig) {
        return 0;
    }

    // Max world height, how many blocks high from minimumY the chunks generate
    @Override
    public int method_12104() {
        return this.settings.comp_349().comp_474().comp_174();
    }

    // No oceans in skygrid
    @Override
    public int method_16398() {
        return 0;
    }

    // Bottom of the world is here
    @Override
    public int method_33730() {
        return this.settings.comp_349().comp_474().comp_173();
    }

    private void fillChestBlockEntityWithItems(class_2621 blockEntity, class_5819 random, class_5455 dynamicRegistryManager) {
        if (this.chestItemProbabilities != null) {
            // How many items for chest
            int numItems = Math.clamp(random.method_39332(2, 5), 0, blockEntity.method_5439());
            // Generate 26 numbers and shuffle them
            ArrayList<Integer> slots = new ArrayList<>();
            for (int i = 0; i < blockEntity.method_5439(); i++) {
                slots.add(i);
            }
            Collections.shuffle(slots);
            // Add the items
            int nextSlotIdx = 0;
            for (int i = 0; i < numItems; i++) {
                class_1792 item = this.chestItemProbabilities.sample();
                class_1799 itemStack = item.method_7854();
                if (item instanceof class_1812 || item.equals(class_1802.field_8087) || item.equals(class_1802.field_8766)) {
                    itemStack.method_57379(class_9334.field_49651, new class_1844(class_7923.field_41179.method_10240(random).get()));
                } else if (item.equals(class_1802.field_39057)) {
                    class_2378<class_7444> instrumentRegistry = dynamicRegistryManager.method_30530(class_7924.field_41275);
                    itemStack.method_57379(class_9334.field_49612, instrumentRegistry.method_10240(random).get());
                } else if (item.equals(class_1802.field_8598)) {
                    // always have 1 enchantment at least
                    class_2378<class_1887> enchantmentRegistry = dynamicRegistryManager.method_30530(class_7924.field_41265);
                    float chance = 1.0f;
                    for (int j = 0; j < MAX_BOOK_ENCHANTS; j++) {
                        if (random.method_43057() < chance) {
                            addRandomEnchantmentToItemStack(itemStack, random, enchantmentRegistry);
                        }
                        chance *= 0.66f;
                    }
                }
                int slotIdx = slots.get(nextSlotIdx);
                nextSlotIdx += 1;
                blockEntity.method_5447(slotIdx, itemStack);
            }
        }
    }

    // Doing it all here is good enough for now
    @Override
    public CompletableFuture<class_2791> method_12088(class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
        class_5455 dynamicRegistryManager = structureAccessor.method_41036();
        class_5819 random = getRandomForChunk(noiseConfig, chunk.method_12004().field_9181, chunk.method_12004().field_9180);
        UniformRandomProvider uniformRandomProvider = new MinecraftRandomAdapter(random);
        this.blockProbabilities = this.blockProbabilities.withUniformRandomProvider(uniformRandomProvider);
        if (this.chestItemProbabilities != null) {
            this.chestItemProbabilities = this.chestItemProbabilities.withUniformRandomProvider(uniformRandomProvider);
        }
        for (int x = 0; x < 16; x += 4) {
            for (int z = 0; z < 16; z += 4) {
                int worldX = chunk.method_12004().field_9181 * 16 + x;
                int worldZ = chunk.method_12004().field_9180 * 16 + z;
                for (int y = method_33730(); y < method_33730() + method_12104(); y += 4) {
                    class_2338 blockPos = new class_2338(x, y, z);
                    class_2248 block = blockProbabilities.sample();
                    class_2680 state = block.method_9564().method_47968(class_2741.field_12514, true);
                    chunk.method_12010(blockPos, state, false);
                    if (block instanceof class_2343 provider) {
                        class_2338 blockEntityPos = new class_2338(worldX, y, worldZ);
                        class_2586 blockEntity = provider.method_10123(blockEntityPos, state);
                        if (blockEntity instanceof class_2621 lootableContainerBlockEntity) {
                            fillChestBlockEntityWithItems(lootableContainerBlockEntity, random, dynamicRegistryManager);
                        } else if (blockEntity instanceof class_2636 mobSpawnerBlockEntity && !this.entities.isEmpty()) {
                            mobSpawnerBlockEntity.method_46408(this.entities.get(random.method_43048(config.spawnerEntities.size())), random);
                        } else if (blockEntity instanceof class_8174 brushableBlockEntity) {
                            int lootTableIndex = random.method_39332(0, ARCHEOLOGY_LOOT_TABLES.size() - 1);
                            brushableBlockEntity.method_49216(ARCHEOLOGY_LOOT_TABLES.get(lootTableIndex), random.method_43054());
                        }
                        chunk.method_12007(blockEntity);
                    }
                }
            }
        }

        // End portal placement
        if (chunk.method_12004().field_9181 == 0 && chunk.method_12004().field_9180 == 0) {
            chunk.method_12010(new class_2338(0, -64, 0), class_2246.field_10124.method_9564(), false);
            chunk.method_12010(new class_2338(2, -64, 0), class_2246.field_10398.method_9564().method_11657(class_2741.field_12481, class_2350.field_11039), false);  // Face towards center (1, -64, 1)
            chunk.method_12010(new class_2338(0, -64, 2), class_2246.field_10398.method_9564().method_11657(class_2741.field_12481, class_2350.field_11043), false); // Face towards center (1, -64, 1)
            chunk.method_12010(new class_2338(2, -64, 1), class_2246.field_10398.method_9564().method_11657(class_2741.field_12481, class_2350.field_11039), false); // Face towards center (1, -64, 1)
            chunk.method_12010(new class_2338(1, -64, 2), class_2246.field_10398.method_9564().method_11657(class_2741.field_12481, class_2350.field_11043), false);  // Face towards center (1, -64, 1)
        } else if (chunk.method_12004().field_9181 == -1 && chunk.method_12004().field_9180 == 0) {
            chunk.method_12010(new class_2338(-2, -64, 0), class_2246.field_10398.method_9564().method_11657(class_2741.field_12481, class_2350.field_11034), false);   // Face towards center (1, -64, 1)
            chunk.method_12010(new class_2338(-2, -64, 1), class_2246.field_10398.method_9564().method_11657(class_2741.field_12481, class_2350.field_11034), false);  // Face towards center (1, -64, 1)
            chunk.method_12010(new class_2338(-1, -64, 2), class_2246.field_10398.method_9564().method_11657(class_2741.field_12481, class_2350.field_11043), false);  // Face towards center (1, -64, 1)
        } else if (chunk.method_12004().field_9181 == 0 && chunk.method_12004().field_9180 == -1) {
            chunk.method_12010(new class_2338(0, -64, -2), class_2246.field_10398.method_9564().method_11657(class_2741.field_12481, class_2350.field_11035), false); // Face towards center (1, -64, 1)
            chunk.method_12010(new class_2338(1, -64, -2), class_2246.field_10398.method_9564().method_11657(class_2741.field_12481, class_2350.field_11035), false);  // Face towards center (1, -64, 1)
            chunk.method_12010(new class_2338(2, -64, -1), class_2246.field_10398.method_9564().method_11657(class_2741.field_12481, class_2350.field_11039), false); // Face towards center (1, -64, 1)
        } else if (chunk.method_12004().field_9181 == -1 && chunk.method_12004().field_9180 == -1) {
            chunk.method_12010(new class_2338(-2, -64, -1), class_2246.field_10398.method_9564().method_11657(class_2741.field_12481, class_2350.field_11034), false);  // Face towards center (1, -64, 1)
            chunk.method_12010(new class_2338(-1, -64, -2), class_2246.field_10398.method_9564().method_11657(class_2741.field_12481, class_2350.field_11035), false);   // Face towards center (1, -64, 1)
        }


        return CompletableFuture.completedFuture(chunk);
    }

    // Get one column of the terrain
    @Override
    public class_4966 method_26261(int x, int z, class_5539 world, class_7138 noiseConfig) {
        class_5819 random = getRandomForChunk(noiseConfig, x >> 4, z >> 4);
        blockProbabilities = blockProbabilities.withUniformRandomProvider(new MinecraftRandomAdapter(random));
        class_2680[] states = new class_2680[method_12104() / 4];
        for (int y = method_33730(); y < method_33730() + method_12104(); y += 4) {
            states[(y - method_33730()) / 4] = blockProbabilities.sample().method_9564();
        }
        return new class_4966(method_33730(), states);
    }
}
