package net.spacerulerwill.skygrid_reloaded.worldgen;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1973;
import net.minecraft.class_2248;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.spacerulerwill.skygrid_reloaded.util.CheckerboardColumnBiomeSourceSizeAccessor;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public class SkyGridChunkGeneratorConfig {
    static Codec<LinkedHashMap<class_2248, Double>> BLOCK_WEIGHT_MAP_CODEC = Codec.unboundedMap(class_7923.field_41175.method_39673(), Codec.DOUBLE)
            .xmap(LinkedHashMap::new, map -> map);
    static Codec<LinkedHashMap<class_1792, Double>> ITEM_WEIGHT_MAP_CODEC = Codec.unboundedMap(class_7923.field_41178.method_39673(), Codec.DOUBLE)
            .xmap(LinkedHashMap::new, map -> map);
    public static final Codec<SkyGridChunkGeneratorConfig> CODEC = RecordCodecBuilder.create(
            instance -> instance.group(
                    BLOCK_WEIGHT_MAP_CODEC.fieldOf("blocks").forGetter(config -> config.blocks),
                    class_7923.field_41177.method_39673().listOf().fieldOf("spawner_entities")
                            .xmap(
                                    LinkedHashSet::new,
                                    ArrayList::new
                            )
                            .forGetter(config -> config.spawnerEntities),
                    ITEM_WEIGHT_MAP_CODEC.fieldOf("chest_items").forGetter(config -> config.chestItems),
                    class_1973.field_24715.fieldOf("checkerboard")
                            .orElse(new class_1973(class_6885.method_40246(), 1))
                            .forGetter(config -> config.checkerboardBiomeSource)
            ).apply(instance, SkyGridChunkGeneratorConfig::new)
    );
    public LinkedHashMap<class_2248, Double> blocks;
    public LinkedHashSet<class_1299<?>> spawnerEntities;
    public LinkedHashMap<class_1792, Double> chestItems;
    public class_1973 checkerboardBiomeSource;

    public SkyGridChunkGeneratorConfig(LinkedHashMap<class_2248, Double> blocks,
                                       LinkedHashSet<class_1299<?>> spawnerEntities,
                                       LinkedHashMap<class_1792, Double> chestItems,
                                       class_1973 checkerboardBiomeSource) {
        this.blocks = blocks;
        this.spawnerEntities = spawnerEntities;
        this.chestItems = chestItems;
        this.checkerboardBiomeSource = checkerboardBiomeSource;
    }

    public SkyGridChunkGeneratorConfig(SkyGridChunkGeneratorConfig other) {
        this(
                new LinkedHashMap<>(other.blocks),
                new LinkedHashSet<>(other.spawnerEntities),
                new LinkedHashMap<>(other.chestItems),
                new class_1973(class_6885.method_40242(other.checkerboardBiomeSource.method_28443().stream().toList()), ((CheckerboardColumnBiomeSourceSizeAccessor) other.checkerboardBiomeSource).skygrid_reloaded$getSize())
        );
    }
}
