/*
 * Decompiled with CFR 0.152.
 */
package net.spacerulerwill.skygrid_reloaded;

import com.mojang.serialization.MapCodec;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.spacerulerwill.skygrid_reloaded.Common;
import net.spacerulerwill.skygrid_reloaded.Constants;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridChunkGenerator;
import org.jetbrains.annotations.NotNull;

@Mod(value="skygrid_reloaded")
public class SkyGridReloaded {
    public static final DeferredRegister<MapCodec<? extends ChunkGenerator>> CHUNK_GENERATORS = DeferredRegister.create((ResourceKey)Registries.CHUNK_GENERATOR, (String)"skygrid_reloaded");

    public SkyGridReloaded(FMLJavaModLoadingContext context) {
        CHUNK_GENERATORS.register("skygrid", () -> SkyGridChunkGenerator.MAP_CODEC);
        CHUNK_GENERATORS.register(context.getModEventBus());
        MinecraftForge.EVENT_BUS.register(EventHandler.class);
        Constants.LOGGER.info("SkyGrid Reloaded is loaded!");
    }

    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void reload(AddReloadListenerEvent event) {
            final HolderLookup.Provider wrapperLookup = event.getRegistries();
            event.addListener(new PreparableReloadListener(){

                @NotNull
                public CompletableFuture<Void> reload(@NotNull PreparableReloadListener.PreparationBarrier preparationBarrier, @NotNull ResourceManager resourceManager, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
                    return CompletableFuture.runAsync(() -> Common.onResourceManagerReload(wrapperLookup, resourceManager), backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).wait(arg_0));
                }
            });
        }
    }
}

