/*
 * Decompiled with CFR 0.152.
 */
package net.spacerulerwill.skygrid_reloaded.ui.screen;

import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.core.HolderSet;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.spacerulerwill.skygrid_reloaded.Common;
import net.spacerulerwill.skygrid_reloaded.ui.screen.CustomizeBlocksScreen;
import net.spacerulerwill.skygrid_reloaded.ui.screen.CustomizeLootScreen;
import net.spacerulerwill.skygrid_reloaded.ui.screen.CustomizeSpawnerScreen;
import net.spacerulerwill.skygrid_reloaded.ui.screen.SelectBiomesScreen;
import net.spacerulerwill.skygrid_reloaded.ui.screen.SkyGridPresetsScreen;
import net.spacerulerwill.skygrid_reloaded.ui.widget.ClickableWidgetList;
import net.spacerulerwill.skygrid_reloaded.ui.widget.IntSlider;
import net.spacerulerwill.skygrid_reloaded.util.CheckerboardColumnBiomeSourceSizeAccessor;
import net.spacerulerwill.skygrid_reloaded.util.CreateWorldScreenExtension;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridChunkGenerator;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridChunkGeneratorConfig;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridConfig;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridPreset;

public class CustomizeSkyGridScreen
extends Screen {
    public static final List<ResourceKey<LevelStem>> VANILLA_DIMENSIONS = List.of(LevelStem.OVERWORLD, LevelStem.NETHER, LevelStem.END);
    private static final Component TITLE_TEXT = Component.translatable((String)"createWorld.customize.skygrid.title");
    private static final Component BLOCKS_TEXT = Component.translatable((String)"createWorld.customize.skygrid.blocks");
    private static final Component BiOMES_TEXT = Component.translatable((String)"createWorld.customize.skygrid.biomes");
    private static final Component SPAWNERS_TEXT = Component.translatable((String)"createWorld.customize.skygrid.spawners");
    private static final Component LOOT_TEXT = Component.translatable((String)"createWorld.customize.skygrid.loot");
    private static final Component PRESETS_TEXT = Component.translatable((String)"createWorld.customize.skygrid.presets");
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private final CreateWorldScreen parent;
    private final IntSlider biomeScaleSlider;
    private final List<ResourceKey<LevelStem>> dimensions;
    private ClickableWidgetList body;
    private CycleButton<ResourceKey<LevelStem>> dimensionsSelector;
    private SkyGridConfig currentConfig;
    private ResourceKey<LevelStem> currentDimension;

    public CustomizeSkyGridScreen(CreateWorldScreen parent) {
        super(TITLE_TEXT);
        this.currentConfig = new SkyGridConfig(Common.DEFAULT_PRESET.config);
        this.currentDimension = LevelStem.OVERWORLD;
        this.parent = parent;
        this.biomeScaleSlider = new IntSlider(0, 0, 100, 20, (Component)Component.translatable((String)"createWorld.customize.skygrid.biome_scale"), 0, 62, ((CheckerboardColumnBiomeSourceSizeAccessor)this.getCurrentConfig().checkerboardBiomeSource).skygrid_reloaded$getSize(), newValue -> {
            SkyGridChunkGeneratorConfig currentConfig = this.getCurrentConfig();
            currentConfig.checkerboardBiomeSource = new CheckerboardColumnBiomeSource((HolderSet)HolderSet.direct(currentConfig.checkerboardBiomeSource.possibleBiomes().stream().toList()), newValue.intValue());
        });
        this.dimensions = this.getAllDimensions();
        this.ensureAllDimensionsHaveConfigs();
    }

    private SkyGridChunkGeneratorConfig getCurrentConfig() {
        return this.currentConfig.dimensions.get(this.currentDimension);
    }

    public void updateBiomeScaleSlider() {
        this.biomeScaleSlider.setValue(((CheckerboardColumnBiomeSourceSizeAccessor)this.getCurrentConfig().checkerboardBiomeSource).skygrid_reloaded$getSize());
    }

    private List<ResourceKey<LevelStem>> getAllDimensions() {
        ArrayList<ResourceKey<LevelStem>> result = new ArrayList<ResourceKey<LevelStem>>();
        WorldCreationContext worldCreationContext = this.parent.getUiState().getSettings();
        worldCreationContext.selectedDimensions().dimensions().forEach((levelStemResourceKey, levelStem) -> result.add((ResourceKey<LevelStem>)levelStemResourceKey));
        ArrayList<ResourceKey> datapackDims = new ArrayList<ResourceKey>(worldCreationContext.datapackDimensions().registryKeySet());
        datapackDims.sort(Comparator.comparing(key -> key.toString()));
        result.addAll(datapackDims);
        return result;
    }

    protected void init() {
        this.layout.addTitleHeader(TITLE_TEXT, this.font);
        List<CycleButton> firstRow = List.of(new CycleButton.Builder(value -> Component.translatable((String)value.location().toLanguageKey())).withValues(this.dimensions).create(0, 0, 158, 20, (Component)Component.translatable((String)"createWorld.customize.skygrid.dimension"), (button, dimension) -> {
            this.currentDimension = dimension;
            this.updateBiomeScaleSlider();
        }));
        List<Button> secondRow = List.of(Button.builder((Component)BLOCKS_TEXT, button -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen((Screen)new CustomizeBlocksScreen(this, this.dimensions, this.currentDimension, this.currentConfig));
            }
        }).build(), Button.builder((Component)SPAWNERS_TEXT, button -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen((Screen)new CustomizeSpawnerScreen(this, this.dimensions, this.currentDimension, this.currentConfig));
            }
        }).build());
        List<IntSlider> thirdRow = List.of(Button.builder((Component)BiOMES_TEXT, button -> {
            if (this.minecraft != null) {
                Registry biomeRegistry = this.parent.getUiState().getSettings().worldgenLoadContext().lookupOrThrow(Registries.BIOME);
                this.minecraft.setScreen((Screen)new SelectBiomesScreen(this, (Registry<Biome>)biomeRegistry, this.dimensions, this.currentDimension, this.currentConfig));
            }
        }).build(), this.biomeScaleSlider);
        List<Button> fourthRow = List.of(Button.builder((Component)LOOT_TEXT, button -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen((Screen)new CustomizeLootScreen(this, this.dimensions, this.currentDimension, this.currentConfig));
            }
        }).build(), Button.builder((Component)PRESETS_TEXT, button -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen((Screen)new SkyGridPresetsScreen(this.minecraft, this, this.parent.getUiState().getSettings().worldgenLoadContext()));
            }
        }).build());
        List<List<AbstractWidget>> rows = List.of(firstRow, secondRow, thirdRow, fourthRow);
        this.body = (ClickableWidgetList)this.layout.addToContents((LayoutElement)new ClickableWidgetList(this.minecraft, rows, this.width, this.layout.getContentHeight(), this.layout.getHeaderHeight()));
        LinearLayout footerRow = LinearLayout.horizontal().spacing(8);
        footerRow.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.done();
            this.onClose();
        }).build());
        footerRow.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).build());
        this.layout.addToFooter((LayoutElement)footerRow);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        if (this.body != null) {
            this.body.updateSize(this.width, this.layout);
        }
    }

    private void ensureAllDimensionsHaveConfigs() {
        this.dimensions.forEach(levelStemResourceKey -> {
            if (!this.currentConfig.dimensions.containsKey(levelStemResourceKey)) {
                this.currentConfig.dimensions.put((ResourceKey<LevelStem>)levelStemResourceKey, new SkyGridChunkGeneratorConfig());
            }
        });
    }

    public void updateSkyGridConfig(SkyGridConfig config) {
        this.currentConfig = config;
        this.ensureAllDimensionsHaveConfigs();
    }

    public SkyGridConfig getCurrentSkyGridConfig() {
        return this.currentConfig;
    }

    private void done() {
        this.updateDatapackDimensions();
    }

    private void updateDatapackDimensions() {
        WorldCreationContext settings = this.parent.getUiState().getSettings();
        Registry oldDatapackDimensions = settings.datapackDimensions();
        MappedRegistry newDatapackDimensions = new MappedRegistry(Registries.LEVEL_STEM, Lifecycle.stable());
        RegistryAccess.Frozen dynamicRegistryManager = settings.worldgenLoadContext();
        Registry biomeRegistry = dynamicRegistryManager.lookupOrThrow(Registries.BIOME);
        this.currentConfig.dimensions.forEach((levelStemResourceKey, config) -> {
            boolean hasNonZeroBlock = config.blocks.values().stream().anyMatch(weight -> weight > 0.0);
            if (hasNonZeroBlock) {
                LevelStem levelStem = VANILLA_DIMENSIONS.contains(levelStemResourceKey) ? (LevelStem)this.parent.getUiState().getSettings().selectedDimensions().dimensions().get(levelStemResourceKey) : (LevelStem)oldDatapackDimensions.getValue(levelStemResourceKey);
                if (config.checkerboardBiomeSource.possibleBiomes().isEmpty()) {
                    List biomes = levelStem.generator().getBiomeSource().possibleBiomes().stream().toList();
                    config.checkerboardBiomeSource = new CheckerboardColumnBiomeSource((HolderSet)HolderSet.direct(biomes), 1);
                }
                DimensionType type = (DimensionType)levelStem.type().value();
                SkyGridChunkGenerator chunkGenerator = new SkyGridChunkGenerator(type.minY(), type.height(), (SkyGridChunkGeneratorConfig)config);
                LevelStem newLevelStem = new LevelStem(levelStem.type(), (ChunkGenerator)chunkGenerator);
                newDatapackDimensions.register(levelStemResourceKey, (Object)newLevelStem, RegistrationInfo.BUILT_IN);
            } else {
                newDatapackDimensions.register(levelStemResourceKey, (Object)((CreateWorldScreenExtension)this.parent).skygrid_reloaded$getDefaultLevelStems().get(levelStemResourceKey), RegistrationInfo.BUILT_IN);
            }
        });
        settings = this.parent.getUiState().getSettings();
        WorldCreationContext worldCreationContext = new WorldCreationContext(settings.options(), (Registry)newDatapackDimensions, settings.selectedDimensions(), settings.worldgenRegistries(), settings.dataPackResources(), settings.dataConfiguration(), settings.initialWorldCreationOptions());
        this.parent.getUiState().setSettings(worldCreationContext);
    }

    public void setConfigFromPreset(SkyGridPreset preset) {
        this.currentConfig = new SkyGridConfig(preset.config);
        this.ensureAllDimensionsHaveConfigs();
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen((Screen)this.parent);
        }
    }
}

