package net.spacerulerwill.skygrid_reloaded;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.JsonOps;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridPreset;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class PresetsReloadListener implements SimpleSynchronousResourceReloadListener {
    @Override
    public class_2960 getFabricId() {
        return class_2960.method_60655(SkyGridReloaded.MOD_ID, "presets");
    }

    @Override
    public void method_14491(class_3300 manager) {
        // Load all presets
        SkyGridReloaded.LOGGER.debug("Loading presets");
        for (Map.Entry<class_2960, class_3298> entry : manager.method_14488("presets", path -> path.toString().endsWith(".json")).entrySet()) {
            class_2960 identifier = entry.getKey();
            class_3298 resource = entry.getValue();
            try (InputStream stream = resource.method_14482()) {
                SkyGridReloaded.LOGGER.debug("Loading preset {}", identifier);
                JsonElement json = JsonParser.parseString(new String(stream.readAllBytes(), StandardCharsets.UTF_8));
                SkyGridPreset preset = SkyGridPreset.CODEC.parse(JsonOps.INSTANCE, json).getOrThrow();
                SkyGridReloaded.PRESETS.add(preset);
                if (identifier.equals(class_2960.method_60655(SkyGridReloaded.MOD_ID, "presets/modern.json"))) {
                    SkyGridReloaded.DEFAULT_PRESET = preset;
                }
                SkyGridReloaded.LOGGER.info("Loaded preset {}", identifier);
            } catch (Exception e) {
                SkyGridReloaded.LOGGER.error("Error occurred while loading preset json: {}", identifier, e);
            }
        }
        SkyGridReloaded.LOGGER.info("Loaded presets");
    }
}
