package net.spacerulerwill.skygrid_reloaded.ui.screen;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5363;
import net.minecraft.class_7923;
import net.spacerulerwill.skygrid_reloaded.ui.widget.WeightSliderListWidgetEntry;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridConfig;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CustomizeBlocksScreen extends DimensionSpecificCustomizableListWidgetScreen<CustomizeBlocksScreen.BlockWeightListEntry, class_2248> {
    private static final double INITIAL_BLOCK_WEIGHT = 160;
    private static final double MIN_BLOCK_WEIGHT = 0;
    private static final double MAX_BLOCK_WEIGHT = 500;

    public CustomizeBlocksScreen(CustomizeSkyGridScreen parent, SkyGridConfig currentConfig) {
        super(parent, currentConfig, class_2561.method_43471("createWorld.customize.skygrid.blocks"), class_2561.method_43471("createWorld.customize.skygrid.blocks.placeholder"), 25);
    }

    private static class_1792 getBlockItem(class_2248 block) {
        if (block.equals(class_2246.field_10164)) {
            return class_1802.field_8187;
        } else if (block.equals(class_2246.field_10382)) {
            return class_1802.field_8705;
        } else {
            return block.method_8389();
        }
    }

    @Override
    public void onClear() {
        Map<class_2248, Double> blocks = this.getCurrentBlocks();
        blocks.clear();
    }

    @Override
    protected Optional<class_2248> getFromTextField(String text) {
        try {
            return class_7923.field_41175.method_17966(class_2960.method_60654(text));
        } catch (class_151 e) {
            return Optional.empty();
        }
    }

    @Override
    protected List<AutocompleteListWidget.Entry> getAutocompleteSuggestions(String text) {
        List<AutocompleteListWidget.Entry> results = new ArrayList<>();
        if (text.isBlank()) {
            return results;
        }
        class_7923.field_41175.forEach(block -> {
            String displayString = class_2561.method_43471(block.method_63499()).getString();
            String valueString = class_7923.field_41175.method_10221(block).toString();
            if (displayString.trim().toLowerCase().startsWith(text) || valueString.startsWith(text)) {
                results.add(new AutocompleteListWidget.Entry(getBlockItem(block), displayString, valueString, this.field_22793));
            }
        });
        return results;
    }

    @Override
    protected void onAdd(class_2248 block) {
        Map<class_2248, Double> blocks = this.getCurrentBlocks();
        if (blocks.containsKey(block)) {
            throw new IllegalStateException("Add button called while item to add is already present");
        }
        blocks.put(block, INITIAL_BLOCK_WEIGHT);
        this.listWidget.method_25321(new BlockWeightListEntry(block));
    }

    @Override
    protected boolean canAdd(class_2248 block) {
        return !getCurrentBlocks().containsKey(block);
    }

    @Override
    protected void onDelete(BlockWeightListEntry entry) {
        Map<class_2248, Double> blocks = getCurrentBlocks();
        blocks.remove(entry.block);
    }

    private Map<class_2248, Double> getCurrentBlocks() {
        Map<class_2248, Double> blocks;
        if (this.currentDimension == class_5363.field_25412) {
            blocks = this.currentConfig.overworldConfig().blocks();
        } else if (this.currentDimension == class_5363.field_25413) {
            blocks = this.currentConfig.netherConfig().blocks();
        } else if (this.currentDimension == class_5363.field_25414) {
            blocks = this.currentConfig.endConfig().blocks();
        } else {
            throw new IllegalStateException("Current dimension is not one of overworld, nether or end: " + this.currentDimension.method_29177().method_42094());
        }
        return blocks;
    }

    @Override
    protected List<BlockWeightListEntry> getEntriesFromConfig() {
        List<BlockWeightListEntry> entries = new ArrayList<>();
        Map<class_2248, Double> blocks = this.getCurrentBlocks();
        for (Map.Entry<class_2248, Double> entry : blocks.entrySet()) {
            class_2248 block = entry.getKey();
            double weight = entry.getValue();
            entries.add(new BlockWeightListEntry(block, weight));
        }
        return entries;
    }

    @Environment(EnvType.CLIENT)
    public class BlockWeightListEntry extends WeightSliderListWidgetEntry<BlockWeightListEntry> {
        private final class_2248 block;

        public BlockWeightListEntry(class_2248 block) {
            super(block.method_9518(), MIN_BLOCK_WEIGHT, MAX_BLOCK_WEIGHT, INITIAL_BLOCK_WEIGHT);
            this.block = block;
        }

        public BlockWeightListEntry(class_2248 block, double initialWeight) {
            super(block.method_9518(), MIN_BLOCK_WEIGHT, MAX_BLOCK_WEIGHT, initialWeight);
            this.block = block;
        }

        @Override
        public void applyWeight(double weight) {
            Map<class_2248, Double> blocks = CustomizeBlocksScreen.this.getCurrentBlocks();
            blocks.put(this.block, weight);
        }

        @Override
        public class_1792 getIcon() {
            return getBlockItem(this.block);
        }
    }
}
