package net.spacerulerwill.skygrid_reloaded.ui.screen;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5363;
import net.minecraft.class_7923;
import net.spacerulerwill.skygrid_reloaded.ui.widget.WeightSliderListWidgetEntry;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridConfig;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CustomizeLootScreen extends DimensionSpecificCustomizableListWidgetScreen<CustomizeLootScreen.ItemWeightListEntry, class_1792> {
    private static final double INITIAL_ITEM_WEIGHT = 1;
    private static final double MIN_ITEM_WEIGHT = 0;
    private static final double MAX_ITEM_WEIGHT = 100;

    public CustomizeLootScreen(CustomizeSkyGridScreen parent, SkyGridConfig currentConfig) {
        super(parent, currentConfig, class_2561.method_43471("createWorld.customize.skygrid.loot"), class_2561.method_43471("createWorld.customize.loot.placeholder"), 25);
    }

    @Override
    public void onClear() {
        Map<class_1792, Double> blocks = this.getChestItems();
        blocks.clear();
    }

    @Override
    protected Optional<class_1792> getFromTextField(String text) {
        try {
            return class_7923.field_41178.method_17966(class_2960.method_60654(text));
        } catch (class_151 e) {
            return Optional.empty();
        }
    }

    @Override
    protected List<AutocompleteListWidget.Entry> getAutocompleteSuggestions(String text) {
        List<AutocompleteListWidget.Entry> results = new ArrayList<>();
        if (text.isBlank()) {
            return results;
        }
        class_7923.field_41178.forEach(item -> {
            if (item == class_1802.field_8162) return;

            String displayString = class_2561.method_43471(item.method_7876()).getString();
            String valueString = class_7923.field_41178.method_10221(item).toString();
            if (displayString.trim().toLowerCase().startsWith(text) || valueString.startsWith(text)) {
                results.add(new AutocompleteListWidget.Entry(item, displayString, valueString, this.field_22793));
            }
        });
        return results;
    }

    @Override
    protected void onAdd(class_1792 item) {
        Map<class_1792, Double> chestItems = this.getChestItems();
        if (chestItems.containsKey(item)) {
            throw new IllegalStateException("Add button called while item to add is already present");
        }
        chestItems.put(item, INITIAL_ITEM_WEIGHT);
        this.listWidget.method_25321(new ItemWeightListEntry(item));
    }

    @Override
    protected boolean canAdd(class_1792 item) {
        return !getChestItems().containsKey(item);
    }

    @Override
    protected void onDelete(ItemWeightListEntry entry) {
        Map<class_1792, Double> chestItems = getChestItems();
        chestItems.remove(entry.item);
    }

    private Map<class_1792, Double> getChestItems() {
        Map<class_1792, Double> items;
        if (this.currentDimension == class_5363.field_25412) {
            items = this.currentConfig.overworldConfig().chestItems();
        } else if (this.currentDimension == class_5363.field_25413) {
            items = this.currentConfig.netherConfig().chestItems();
        } else if (this.currentDimension == class_5363.field_25414) {
            items = this.currentConfig.endConfig().chestItems();
        } else {
            throw new IllegalStateException("Current dimension is not one of overworld, nether or end: " + this.currentDimension.method_29177().method_42094());
        }
        return items;
    }

    @Override
    protected List<ItemWeightListEntry> getEntriesFromConfig() {
        List<ItemWeightListEntry> entries = new ArrayList<>();
        Map<class_1792, Double> chestItems = this.getChestItems();
        for (Map.Entry<class_1792, Double> entry : chestItems.entrySet()) {
            class_1792 item = entry.getKey();
            double weight = entry.getValue();
            entries.add(new ItemWeightListEntry(item, weight));
        }
        return entries;
    }

    @Environment(EnvType.CLIENT)
    public class ItemWeightListEntry extends WeightSliderListWidgetEntry<ItemWeightListEntry> {
        private final class_1792 item;

        public ItemWeightListEntry(class_1792 item) {
            super(item.method_63680(), MIN_ITEM_WEIGHT, MAX_ITEM_WEIGHT, INITIAL_ITEM_WEIGHT);
            this.item = item;
        }

        public ItemWeightListEntry(class_1792 item, double initialWeight) {
            super(item.method_63680(), MIN_ITEM_WEIGHT, MAX_ITEM_WEIGHT, initialWeight);
            this.item = item;
        }

        @Override
        public void applyWeight(double weight) {
            Map<class_1792, Double> items = CustomizeLootScreen.this.getChestItems();
            items.put(this.item, weight);
        }

        @Override
        public class_1792 getIcon() {
            return this.item;
        }
    }
}
