package net.spacerulerwill.skygrid_reloaded.ui.screen;

import com.google.common.collect.ImmutableMap;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_1992;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_525;
import net.minecraft.class_5317;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_6880;
import net.minecraft.class_7145;
import net.minecraft.class_7193;
import net.minecraft.class_7723;
import net.minecraft.class_7924;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import net.spacerulerwill.skygrid_reloaded.SkyGridReloaded;
import net.spacerulerwill.skygrid_reloaded.ui.widget.ClickableWidgetList;
import net.spacerulerwill.skygrid_reloaded.util.WorldPresetExtension;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridChunkGenerator;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridChunkGeneratorConfig;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridConfig;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridPreset;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomizeSkyGridScreen extends class_437 {
    private static final class_2561 TITLE_TEXT = class_2561.method_43471("createWorld.customize.skygrid.title");
    private static final class_2561 BLOCKS_TEXT = class_2561.method_43471("createWorld.customize.skygrid.blocks");
    private static final class_2561 SPAWNERS_TEXT = class_2561.method_43471("createWorld.customize.skygrid.spawners");
    private static final class_2561 LOOT_TEXT = class_2561.method_43471("createWorld.customize.skygrid.loot");
    private static final class_2561 PRESETS_TEXT = class_2561.method_43471("createWorld.customize.skygrid.presets");


    private final class_8132 layout = new class_8132(this);
    private final class_525 parent;
    private ClickableWidgetList body;
    private SkyGridConfig currentConfig = new SkyGridConfig(SkyGridReloaded.DEFAULT_PRESET.config());


    public CustomizeSkyGridScreen(class_525 parent) {
        super(TITLE_TEXT);
        this.parent = parent;
    }

    @Override
    protected void method_25426() {
        // Header for title
        this.layout.method_57726(TITLE_TEXT, this.field_22793);
        // Body
        List<class_339> firstRow = List.of(
                class_4185.method_46430(BLOCKS_TEXT, (button) -> {
                    if (this.field_22787 != null) {
                        this.field_22787.method_1507(new CustomizeBlocksScreen(this, this.currentConfig));
                    }
                }).method_46431(),
                class_4185.method_46430(SPAWNERS_TEXT, (button) -> {
                    if (this.field_22787 != null) {
                        this.field_22787.method_1507(new CustomizeSpawnerScreen(this, this.currentConfig));
                    }
                }).method_46431()
        );
        List<class_339> secondRow = List.of(
                class_4185.method_46430(LOOT_TEXT, (button) -> {
                    if (this.field_22787 != null) {
                        this.field_22787.method_1507(new CustomizeLootScreen(this, this.currentConfig));
                    }
                }).method_46431(),
                class_4185.method_46430(PRESETS_TEXT, (button) -> {
                    if (this.field_22787 != null) {
                        this.field_22787.method_1507(new SkyGridPresetsScreen(this.field_22787, this));
                    }
                }).method_46431()
        );
        List<List<class_339>> rows = List.of(firstRow, secondRow);
        this.body = this.layout.method_48999(new ClickableWidgetList(this.field_22787, rows, this.field_22789, this.layout.method_57727(), this.layout.method_48998()));
        // Footer
        class_8667 footerRow = class_8667.method_52742().method_52735(8);
        footerRow.method_52736(class_4185.method_46430(class_5244.field_24334, (button) -> {
            this.done();
            this.method_25419();
        }).method_46431());
        footerRow.method_52736(class_4185.method_46430(class_5244.field_24335, (button) -> {
            this.done();
            this.method_25419();
        }).method_46431());
        this.layout.method_48996(footerRow);
        this.layout.method_48206(this::method_37063);
        this.method_48640();
    }

    protected void method_48640() {
        this.layout.method_48222();
        if (this.body != null) {
            this.body.method_57712(this.field_22789, this.layout);
        }
    }

    public void updateSkyGridConfig(SkyGridConfig config) {
        this.currentConfig = config;
    }

    public SkyGridConfig getCurrentSkyGridConfig() {
        return this.currentConfig;
    }

    private void done() {
        this.parent.method_48657().method_48700(applyChunkCGeneratorConfigs());
    }

    public void setConfigFromPreset(SkyGridPreset preset) {
        this.currentConfig = new SkyGridConfig(preset.config());
    }

    private class_7193.class_7195 applyChunkCGeneratorConfigs() {
        Map<class_5321<class_5363>, SkyGridChunkGeneratorConfig> dimensionOptionsToChunkGeneratorConfigMap = Map.of(
                class_5363.field_25412, currentConfig.overworldConfig(),
                class_5363.field_25413, currentConfig.netherConfig(),
                class_5363.field_25414, currentConfig.endConfig()
        );

        return (dynamicRegistryManager, dimensionsRegistryHolder) -> {
            class_2378<class_1959> biomeRegistry = dynamicRegistryManager.method_30530(class_7924.field_41236);
            class_1959 biome = biomeRegistry.method_29107(class_1972.field_9473);
            class_6880<class_1959> biomeEntry = biomeRegistry.method_47983(biome);
            Map<class_5321<class_5363>, class_5363> updatedDimensions = new HashMap<>(dimensionsRegistryHolder.comp_1014());
            dimensionOptionsToChunkGeneratorConfigMap.forEach((dimensionOptionsRegistryKey, config) -> {
                boolean hasNonZeroBlock = config.blocks().values().stream().anyMatch(weight -> weight > 0);
                if (hasNonZeroBlock) {
                    class_2794 chunkGenerator = new SkyGridChunkGenerator(new class_1992(biomeEntry), config);
                    class_5363 dimensionOptions = parent.method_48657().method_48728().comp_1028().comp_1014().get(dimensionOptionsRegistryKey);

                    class_6880<class_2874> dimensionTypeRegistryEntry = dimensionOptions.comp_1012();
                    class_5363 newDimensionOptions = new class_5363(dimensionTypeRegistryEntry, chunkGenerator);
                    updatedDimensions.put(dimensionOptionsRegistryKey, newDimensionOptions);
                } else {
                    /*
                    There is no non-zero weighted block, so we must use default generation for this dimension. If it's
                    a vanilla dimension we must get it from a registry due to the fact that the default is overwritten by
                    our world preset json file. However for modded dimensions, we can leave it as they will have not
                    been overwritten by our world preset json
                     */
                    if (dimensionOptionsRegistryKey == class_5363.field_25412) {
                        class_5363 defaultOverworld = (dynamicRegistryManager.method_30530(class_7924.field_41250).method_29107(class_5317.field_25050)).method_41584().orElseThrow();
                        updatedDimensions.put(dimensionOptionsRegistryKey, defaultOverworld);
                    } else if (dimensionOptionsRegistryKey == class_5363.field_25413) {
                        class_7145 preset = (dynamicRegistryManager.method_30530(class_7924.field_41250).method_29107(class_5317.field_25050));
                        class_5363 defaultNether = ((WorldPresetExtension) preset).skygrid$GetNether().orElseThrow();
                        updatedDimensions.put(dimensionOptionsRegistryKey, defaultNether);
                    } else if (dimensionOptionsRegistryKey == class_5363.field_25414) {
                        class_7145 preset = (dynamicRegistryManager.method_30530(class_7924.field_41250).method_29107(class_5317.field_25050));
                        class_5363 defaultEnd = ((WorldPresetExtension) preset).skygrid$GetEnd().orElseThrow();
                        updatedDimensions.put(dimensionOptionsRegistryKey, defaultEnd);
                    }

                }
            });
            return new class_7723(ImmutableMap.copyOf(updatedDimensions));
        };
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }
}
