package net.spacerulerwill.skygrid_reloaded.ui.screen;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5676;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import net.spacerulerwill.skygrid_reloaded.ui.util.RenderUtils;
import net.spacerulerwill.skygrid_reloaded.ui.widget.TextField;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridConfig;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Optional;


/// A screen that will allow you to adjust dimension specific SkyGrid features via a ListWidget
@Environment(EnvType.CLIENT)
public abstract class DimensionSpecificCustomizableListWidgetScreen<T extends class_4280.class_4281<T>, V> extends class_437 {
    private final static class_2561 CLEAR_TEXT = class_2561.method_43471("createWorld.customize.skygrid.clear");
    private final static List<class_5321<class_5363>> DIMENSIONS = List.of(class_5363.field_25412, class_5363.field_25413, class_5363.field_25414);
    private final class_8132 layout = new class_8132(this);
    private final class_2561 field_22785;
    private final class_2561 textFieldPlaceholder;
    private final CustomizeSkyGridScreen parent;
    private final int entryHeight;
    protected ListWidget listWidget;
    protected SearchTextField textField;
    protected class_5321<class_5363> currentDimension;
    protected SkyGridConfig currentConfig;
    private class_4185 addButton;
    private class_4185 deleteButton;
    private class_5676<class_5321<class_5363>> dimensionsSelector;
    private class_4185 doneButton;
    private class_4185 cancelButton;

    public DimensionSpecificCustomizableListWidgetScreen(CustomizeSkyGridScreen parent, SkyGridConfig currentConfig, class_2561 title, class_2561 textFieldPlaceholder, int entryHeight) {
        super(title);
        this.field_22785 = title;
        this.textFieldPlaceholder = textFieldPlaceholder;
        this.entryHeight = entryHeight;
        this.parent = parent;
        this.currentDimension = class_5363.field_25412;
        this.currentConfig = new SkyGridConfig(currentConfig);
    }

    private void initHeader() {
        this.layout.method_57726(this.field_22785, this.field_22793);
    }

    private void initBody() {
        this.listWidget = this.layout.method_48999(new ListWidget(this.field_22787, this.field_22789, this.field_22790 - 117, 43, this.entryHeight));
    }

    private void initFooter() {
        class_8667 rows = class_8667.method_52741().method_52735(4);
        // Row 1 - Done, Clear, Cancel
        class_8667 row1 = class_8667.method_52742().method_52735(8);
        this.doneButton = row1.method_52736(class_4185.method_46430(class_5244.field_24334, (button) -> {
            this.parent.updateSkyGridConfig(this.currentConfig);
            this.method_25419();
        }).method_46432(75).method_46431());
        this.cancelButton = row1.method_52736(class_4185.method_46430(class_5244.field_24335, (button) -> {
            this.method_25419();
        }).method_46432(75).method_46431());
        row1.method_52736(class_4185.method_46430(CLEAR_TEXT, (button -> {
            this.onClear();
            this.listWidget.method_25339();
            this.listWidget.method_44382(0.0);
        })).method_46432(75).method_46431());
        // Row 2 - Dimension selector and Delete button
        class_8667 row2 = class_8667.method_52742().method_52735(8);
        this.dimensionsSelector = row2.method_52736(new class_5676.class_5677<class_5321<class_5363>>(value -> class_2561.method_43471(value.method_29177().method_42094()))
                .method_32620(DIMENSIONS)
                .method_32617(0, 0, 158, 20, class_2561.method_43471("createWorld.customize.skygrid.dimension"), ((button, dimension) -> {
                    this.currentDimension = dimension;
                    this.regenerateListEntries();
                    this.updateAddButtonActive();
                    this.updateDeleteButtonActive();
                })));
        this.deleteButton = row2.method_52736(class_4185.method_46430(class_2561.method_43471("createWorld.customize.skygrid.delete"), (button) -> {
            T entry = this.listWidget.method_25334();
            if (entry == null) {
                return;
            }
            this.listWidget.method_25330(entry);
            this.onDelete(entry);
            this.updateAddButtonActive();
            this.updateDeleteButtonActive();
        }).method_46432(75).method_46431());
        // Row 3 - Text field and Add button
        class_8667 row3 = class_8667.method_52742().method_52735(8);
        this.textField = row3.method_52736(new SearchTextField(field_22793, 158, 20, this.textFieldPlaceholder));
        this.addButton = row3.method_52736(class_4185.method_46430(class_2561.method_43471("createWorld.customize.skygrid.add"), (button) -> {
            Optional<V> v = this.getFromTextField(this.textField.method_1882());
            v.ifPresent(this::onAdd);
            this.updateAddButtonActive();
            this.updateDeleteButtonActive();
            this.textField.method_1852("");
        }).method_46432(75).method_46431());
        rows.method_52736(row3);
        rows.method_52736(row2);
        rows.method_52736(row1);
        this.layout.method_48996(rows);
        this.layout.method_48991(80);
    }

    @Override
    protected void method_25426() {
        // Header for title
        this.initHeader();
        this.initBody();
        this.initFooter();
        this.layout.method_48206(this::method_37063);
        this.regenerateListEntries();
        this.method_48640();
        this.updateAddButtonActive();
        this.updateDeleteButtonActive();
    }

    protected void method_48640() {
        this.layout.method_48222();
        if (this.listWidget != null) {
            this.listWidget.method_57712(this.field_22789, this.layout);
        }
        this.textField.refreshPositions();
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    private void regenerateListEntries() {
        this.listWidget.method_25314(this.getEntriesFromConfig());
        this.listWidget.method_44382(0.0);
    }

    private void updateAddButtonActive() {
        Optional<V> thing = getFromTextField(this.textField.method_1882());
        this.addButton.field_22763 = thing.isPresent() && this.canAdd(thing.get());
    }

    private void updateDeleteButtonActive() {
        T entry = this.listWidget.method_25334();
        this.deleteButton.field_22763 = entry != null;
    }

    private void hideWidgetsForAutocompleteBox() {
        this.method_37066(this.doneButton);
        this.method_37066(this.cancelButton);
        this.method_37066(this.dimensionsSelector);
    }

    private void showWidgetsForAutocompleteBox() {
        this.method_37063(this.doneButton);
        this.method_37063(this.cancelButton);
        this.method_37063(this.dimensionsSelector);
    }

    protected abstract void onClear();

    protected abstract Optional<V> getFromTextField(String text);

    protected abstract List<AutocompleteListWidget.Entry> getAutocompleteSuggestions(String text);

    protected abstract void onAdd(V thing);

    protected abstract boolean canAdd(V thing);

    protected abstract void onDelete(T entry);

    protected abstract List<T> getEntriesFromConfig();

    @Environment(EnvType.CLIENT)
    public static class AutocompleteListWidget extends class_4280<AutocompleteListWidget.Entry> {
        DimensionSpecificCustomizableListWidgetScreen<?, ?> parent;

        public AutocompleteListWidget(class_310 minecraftClient, DimensionSpecificCustomizableListWidgetScreen<?, ?> parent) {
            super(minecraftClient, 158, 44, 0, 24);
            this.parent = parent;
        }

        @Override
        public int method_25322() {
            return this.method_25368() - 16;
        }

        @Override
        protected int method_65507() {
            return this.method_46426() + this.method_25368() - 6;
        }

        @Override
        public void setSelected(@Nullable DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry entry) {
            super.method_25313(entry);
            if (entry != null) {
                this.parent.textField.method_1852(entry.valueText);
            }
        }

        @Override
        public void method_64847(int index) {
            super.method_64847(index);
            AutocompleteListWidget.Entry entry = this.method_25326(index);
            this.parent.textField.method_1852(entry.valueText);
        }

        @Environment(EnvType.CLIENT)
        public static class Entry extends class_4280.class_4281<Entry> {
            public final String valueText;
            @Nullable
            private final class_1792 iconItem;
            private final String displayText;
            private final class_327 textRenderer;

            public Entry(@Nullable class_1792 iconItem, String displayText, String valueText, class_327 textRenderer) {
                this.iconItem = iconItem;
                this.displayText = displayText;
                this.valueText = valueText;
                this.textRenderer = textRenderer;
            }

            @Override
            public class_2561 method_37006() {
                return class_2561.method_43473();
            }

            @Override
            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                if (this.iconItem == null) {
                    context.method_51433(this.textRenderer, this.displayText, x + 5, y + 3, 16777215, false);
                } else {
                    RenderUtils.renderItemIcon(this.iconItem, context, x, y);
                    context.method_51433(this.textRenderer, this.displayText, x + 18 + 5, y + 3, 16777215, false);
                }
            }
        }
    }

    @Environment(EnvType.CLIENT)
    protected class ListWidget extends class_4280<T> {
        public ListWidget(class_310 minecraftClient, int i, int j, int k, int l) {
            super(minecraftClient, i, j, k, l);
        }

        @Override
        public void setSelected(@Nullable T entry) {
            super.method_25313(entry);
            DimensionSpecificCustomizableListWidgetScreen.this.updateDeleteButtonActive();
        }

        @Override
        public void method_64847(int index) {
            super.method_64847(index);
            DimensionSpecificCustomizableListWidgetScreen.this.updateDeleteButtonActive();
        }
    }

    @Environment(EnvType.CLIENT)
    protected class SearchTextField extends TextField {
        @Nullable
        public AutocompleteListWidget autocompleteListWidget;

        public SearchTextField(class_327 textRenderer, int x, int y, class_2561 text) {
            super(textRenderer, x, y, text);
            this.method_1880(1024);
        }

        private void refreshPositions() {
            if (this.autocompleteListWidget != null) {
                this.autocompleteListWidget.method_46421(this.method_46426());
                this.autocompleteListWidget.method_46419(this.method_46427() + this.method_25364() + 4);
            }
        }

        protected void onTextChanged() {
            DimensionSpecificCustomizableListWidgetScreen.this.updateAddButtonActive();
            List<AutocompleteListWidget.Entry> autocompleteResults = DimensionSpecificCustomizableListWidgetScreen.this.getAutocompleteSuggestions(this.method_1882());
            if (autocompleteResults.isEmpty()) {
                if (this.autocompleteListWidget != null) {
                    DimensionSpecificCustomizableListWidgetScreen.this.method_37066(this.autocompleteListWidget);
                    DimensionSpecificCustomizableListWidgetScreen.this.showWidgetsForAutocompleteBox();
                    this.autocompleteListWidget = null;
                }
            } else {
                if (this.autocompleteListWidget == null) {
                    this.autocompleteListWidget = new AutocompleteListWidget(DimensionSpecificCustomizableListWidgetScreen.this.field_22787, DimensionSpecificCustomizableListWidgetScreen.this);
                    this.refreshPositions();
                    for (AutocompleteListWidget.Entry entry : autocompleteResults) {
                        this.autocompleteListWidget.method_25321(entry);
                    }
                    DimensionSpecificCustomizableListWidgetScreen.this.method_37063(this.autocompleteListWidget);
                    DimensionSpecificCustomizableListWidgetScreen.this.hideWidgetsForAutocompleteBox();
                } else {
                    this.autocompleteListWidget.method_25314(autocompleteResults);
                }

            }
        }
    }
}
