package net.spacerulerwill.skygrid_reloaded.ui.screen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import net.spacerulerwill.skygrid_reloaded.SkyGridReloaded;
import net.spacerulerwill.skygrid_reloaded.ui.widget.TextField;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridConfig;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridPreset;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.Nullable;

import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

@Environment(EnvType.CLIENT)
public class SkyGridPresetsScreen extends class_437 {
    private final class_8132 layout = new class_8132(this, 33, 64);
    private final CustomizeSkyGridScreen parent;
    private final class_310 client;
    private TextField textField;
    private class_4185 selectPresetButton;
    private class_4185 savePresetButton;
    private SkyGridPresetListWidget listWidget;

    protected SkyGridPresetsScreen(class_310 client, CustomizeSkyGridScreen parent) {
        super(class_2561.method_43471("createWorld.customize.skygrid.presets"));
        this.field_22787 = client;
        this.parent = parent;
    }

    protected void method_25426() {
        this.layout.method_57726(this.field_22785, this.field_22793);
        this.listWidget = this.layout.method_48999(new SkyGridPresetListWidget());
        class_8667 rows = class_8667.method_52741().method_52735(4);
        class_8667 row1 = class_8667.method_52742().method_52735(8);
        this.selectPresetButton = row1.method_52736(class_4185.method_46430(class_2561.method_43471("createWorld.skygrid.customize.presets.select"), (buttonWidget) -> {
            SkyGridPresetListWidget.SkyGridPresetEntry entry = this.listWidget.method_25334();
            this.parent.setConfigFromPreset(entry.preset);
            this.field_22787.method_1507(this.parent);
        }).method_46431());
        row1.method_52736(class_4185.method_46430(class_5244.field_24335, (button) -> {
            this.field_22787.method_1507(this.parent);
        }).method_46431());
        rows.method_52736(row1);
        class_8667 row2 = class_8667.method_52742().method_52735(8);
        this.textField = row2.method_52736(new PresetsTextField());
        this.savePresetButton = row2.method_52736(class_4185.method_46430(class_2561.method_43471("createWorld.skygrid.customize.presets.save"), (buttonWidget) -> {
            this.savePreset(this.textField.method_1882());
        }).method_46431());
        rows.method_52736(row2);
        rows.method_48206(this::method_37063);
        this.layout.method_48996(rows);
        this.layout.method_48206(this::method_37063);
        this.updateSelectPresetButtonActive();
        this.method_48640();
        this.updateSaveButtonActive();
    }

    private void updateSaveButtonActive() {
        this.savePresetButton.field_22763 = !this.textField.method_1882().isEmpty();
    }

    protected void method_48640() {
        if (this.listWidget != null) {
            this.listWidget.method_57712(this.field_22789, this.layout);
        }
        this.layout.method_48222();
    }

    public void updateSelectPresetButtonActive() {
        this.selectPresetButton.field_22763 = this.listWidget.method_25334() != null;
    }

    @Override
    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    private void savePreset(String name) {
        try {
            // Get hash of name
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(name.getBytes(StandardCharsets.UTF_8));

            String hashedName = Hex.encodeHexString(hash);
            // Get the preset
            SkyGridConfig currentConfig = this.parent.getCurrentSkyGridConfig();
            // Icon will be the most common block
            int maxWeight = 0;
            // Should be better
            List<class_1792> allItems = new ArrayList<>();
            currentConfig.overworldConfig().blocks().keySet().stream()
                    .map(class_2248::method_8389)
                    .forEach(allItems::add);
            allItems.addAll(currentConfig.overworldConfig().chestItems().keySet());
            currentConfig.netherConfig().blocks().keySet().stream()
                    .map(class_2248::method_8389)
                    .forEach(allItems::add);
            allItems.addAll(currentConfig.overworldConfig().chestItems().keySet());
            currentConfig.endConfig().blocks().keySet().stream()
                    .map(class_2248::method_8389)
                    .forEach(allItems::add);
            allItems.addAll(currentConfig.overworldConfig().chestItems().keySet());
            Random random = new Random();
            class_1792 icon = allItems.get(random.nextInt(allItems.size()));
            SkyGridPreset preset = new SkyGridPreset(icon, name, currentConfig);
            // Encode it as json
            JsonElement element = new JsonObject();
            DataResult<JsonElement> json = SkyGridPreset.CODEC.encode(preset, JsonOps.INSTANCE, element);
            String jsonString = json.getOrThrow().toString();
            // Write json to file
            String fileName = FabricLoader.getInstance().getConfigDir().toString() + "/" + SkyGridReloaded.MOD_ID + "/" + hashedName + ".json";
            try (PrintWriter writer = new PrintWriter(fileName, StandardCharsets.UTF_8)) {
                writer.write(jsonString);
            }
            // Reload necessary stuff
            SkyGridReloaded.reloadCustomPresets();
            this.listWidget.refreshEntries();
        } catch (Exception e) {
            SkyGridReloaded.LOGGER.error("Failed to save preset {}: {}", name, e);
        }
    }

    @Environment(EnvType.CLIENT)
    private class SkyGridPresetListWidget extends class_4280<SkyGridPresetListWidget.SkyGridPresetEntry> {
        public SkyGridPresetListWidget() {
            super(SkyGridPresetsScreen.this.field_22787, SkyGridPresetsScreen.this.field_22789, SkyGridPresetsScreen.this.field_22790 - 77, 33, 24);
            this.refreshEntries();
        }

        public void refreshEntries() {
            this.method_25339();
            for (SkyGridPreset preset : SkyGridReloaded.PRESETS) {
                this.method_25321(new SkyGridPresetEntry(preset));
            }
            for (SkyGridPreset preset : SkyGridReloaded.CUSTOM_PRESETS) {
                this.method_25321(new SkyGridCustomPresetEntry(preset));
            }
        }

        @Override
        public void setSelected(@Nullable SkyGridPresetsScreen.SkyGridPresetListWidget.SkyGridPresetEntry entry) {
            super.method_25313(entry);
            SkyGridPresetsScreen.this.updateSelectPresetButtonActive();
        }

        @Environment(EnvType.CLIENT)
        public class SkyGridPresetEntry extends Entry<SkyGridPresetEntry> {
            private static final class_2960 SLOT_TEXTURE = class_2960.method_60656("container/slot");
            private final SkyGridPreset preset;

            public SkyGridPresetEntry(SkyGridPreset preset) {
                this.preset = preset;
            }

            @Override
            public class_2561 getNarration() {
                return class_2561.method_43473();
            }

            @Override
            public void render(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                context.method_52707(class_1921::method_62277, SLOT_TEXTURE, x + 1, y + 1, 0, 18, 18);
                context.method_51445(preset.item().method_7854(), x + 2, y + 2);
                context.method_51439(SkyGridPresetsScreen.this.field_22793, class_2561.method_43471(preset.name()), x + 18 + 5, y + 3, 16777215, false);
            }
        }

        @Environment(EnvType.CLIENT)
        public class SkyGridCustomPresetEntry extends SkyGridPresetEntry {
            private final class_4185 deleteButton;

            public SkyGridCustomPresetEntry(SkyGridPreset preset) {
                super(preset);
                this.deleteButton = class_4185.method_46430(class_2561.method_43471("createWorld.skygrid.customize.presets.delete"), button -> {
                    try {
                        MessageDigest digest = MessageDigest.getInstance("SHA-256");
                        byte[] hash = digest.digest(preset.name().getBytes(StandardCharsets.UTF_8));
                        String hashedName = Hex.encodeHexString(hash);
                        String fileName = FabricLoader.getInstance().getConfigDir().toString() + "/" + SkyGridReloaded.MOD_ID + "/" + hashedName + ".json";
                        File file = new File(fileName);
                        Files.deleteIfExists(file.toPath());
                        SkyGridReloaded.reloadCustomPresets();
                        SkyGridPresetListWidget.this.method_25330(this);
                    } catch (Exception e) {
                        SkyGridReloaded.LOGGER.error("Failed to delete preset {}: {}", preset, e);
                    }
                }).method_46432(50).method_46431();
            }

            @Override
            public void render(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                super.render(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
                this.deleteButton.method_46421(x + entryWidth - this.deleteButton.method_25368() - 5);
                this.deleteButton.method_46419(y);
                this.deleteButton.method_25394(context, mouseX, mouseY, tickDelta);
            }

            // Allowing slider to be draggable
            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (this.deleteButton.method_25405(mouseX, mouseY)) {
                    return this.deleteButton.method_25402(mouseX, mouseY, button);
                }
                return super.mouseClicked(mouseX, mouseY, button);
            }
        }
    }


    @Environment(EnvType.CLIENT)
    protected class PresetsTextField extends TextField {
        public PresetsTextField() {
            super(SkyGridPresetsScreen.this.field_22793, 150, 20, class_2561.method_43473());
        }

        @Override
        protected void onTextChanged() {
            SkyGridPresetsScreen.this.updateSaveButtonActive();
        }
    }

}