package net.spacerulerwill.skygrid_reloaded.ui.widget;


import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import java.util.List;

// A list widget of rows of clickable widgets(buttons etc.)
@Environment(EnvType.CLIENT)
public class ClickableWidgetList extends class_4265<ClickableWidgetList.ListWidgetEntry> {
    private static final int ENTRY_WIDTH = 310;

    public ClickableWidgetList(class_310 minecraftClient, List<List<class_339>> widgets, int width, int height, int headerHeight) {
        super(minecraftClient, width, height, headerHeight, 25);
        for (List<class_339> row : widgets) {
            this.method_25321(new ListWidgetEntry(row));
        }
    }

    @Override
    public int method_25322() {
        return ENTRY_WIDTH;
    }

    @Environment(EnvType.CLIENT)
    protected static class ListWidgetEntry extends class_4265.class_4266<ListWidgetEntry> {
        private static final int PADDING = 10;

        private final List<class_339> widgets;

        ListWidgetEntry(List<class_339> widgets) {
            this.widgets = widgets;
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (this.widgets.isEmpty()) {
                return;
            }
            int currentX = x;
            int widgetWidth = (ENTRY_WIDTH - PADDING * (this.widgets.size() - 1)) / widgets.size();
            for (class_339 clickableWidget : this.widgets) {
                clickableWidget.method_48229(currentX, y);
                clickableWidget.method_25358(widgetWidth);
                clickableWidget.method_25394(context, mouseX, mouseY, tickDelta);
                currentX += widgetWidth + PADDING;
            }
        }

        public List<? extends class_6379> method_37025() {
            return this.widgets;
        }

        @Override
        public List<? extends class_364> method_25396() {
            return this.widgets;
        }
    }
}
