package net.spacerulerwill.skygrid_reloaded.worldgen;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_7923;

public record SkyGridChunkGeneratorConfig(LinkedHashMap<class_2248, Double> blocks,
                                          LinkedHashSet<class_1299<?>> spawnerEntities,
                                          LinkedHashMap<class_1792, Double> chestItems) {
    static Codec<LinkedHashMap<class_2248, Double>> BLOCK_WEIGHT_MAP_CODEC = Codec.unboundedMap(class_7923.field_41175.method_39673(), Codec.DOUBLE)
            .xmap(LinkedHashMap::new, map -> map);
    static Codec<LinkedHashMap<class_1792, Double>> ITEM_WEIGHT_MAP_CODEC = Codec.unboundedMap(class_7923.field_41178.method_39673(), Codec.DOUBLE)
            .xmap(LinkedHashMap::new, map -> map);
    public static final Codec<SkyGridChunkGeneratorConfig> CODEC = RecordCodecBuilder.create(
            instance -> instance.group(
                    // Custom codec for blocks
                    BLOCK_WEIGHT_MAP_CODEC.fieldOf("blocks").forGetter(SkyGridChunkGeneratorConfig::blocks),
                    class_7923.field_41177.method_39673().listOf().fieldOf("spawner_entities")
                            .xmap(
                                    LinkedHashSet::new,
                                    ArrayList::new
                            )
                            .forGetter(SkyGridChunkGeneratorConfig::spawnerEntities),
                    ITEM_WEIGHT_MAP_CODEC.fieldOf("chest_items").forGetter(SkyGridChunkGeneratorConfig::chestItems)

            ).apply(instance, SkyGridChunkGeneratorConfig::new)
    );

    public SkyGridChunkGeneratorConfig(SkyGridChunkGeneratorConfig other) {
        this(
                new LinkedHashMap<>(other.blocks),
                new LinkedHashSet<>(other.spawnerEntities),
                new LinkedHashMap<>(other.chestItems)
        );
    }
}

