/*
 * Decompiled with CFR 0.152.
 */
package net.spacerulerwill.skygrid_reloaded;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.spacerulerwill.skygrid_reloaded.Constants;
import net.spacerulerwill.skygrid_reloaded.platform.Services;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridPreset;

public class Common {
    public static ArrayList<SkyGridPreset> PRESETS = new ArrayList();
    public static ArrayList<SkyGridPreset> CUSTOM_PRESETS = new ArrayList();
    public static SkyGridPreset DEFAULT_PRESET;

    private static SkyGridPreset loadCustomPreset(Path filepath, class_7225.class_7874 wrapperLookup) throws IOException {
        String fileContent = Files.readString(filepath);
        JsonElement json = JsonParser.parseString((String)fileContent);
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)wrapperLookup);
        try {
            return (SkyGridPreset)SkyGridPreset.CODEC_V1.parse((DynamicOps)ops, (Object)json).getOrThrow();
        }
        catch (Exception e1) {
            try {
                return (SkyGridPreset)SkyGridPreset.CODEC_V2.parse((DynamicOps)ops, (Object)json).getOrThrow();
            }
            catch (Exception e2) {
                e2.addSuppressed(e1);
                throw new IOException("Failed to parse preset " + String.valueOf(filepath) + ": ", e2);
            }
        }
    }

    public static void reloadCustomPresets(class_7225.class_7874 wrapperLookup) {
        CUSTOM_PRESETS.clear();
        Constants.LOGGER.debug("Loading custom presets");
        Path configDir = Services.PLATFORM.getConfigPath();
        Path modConfigDir = configDir.resolve("skygrid_reloaded");
        try {
            Files.createDirectories(modConfigDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            Constants.LOGGER.error("Failed to create the mod's config directory: {}", (Object)modConfigDir, (Object)e);
            return;
        }
        File[] directoryListing = modConfigDir.toFile().listFiles();
        if (directoryListing == null) {
            return;
        }
        Arrays.sort(directoryListing, Comparator.comparing(File::getName));
        for (File child : directoryListing) {
            if (!child.isFile() || !child.getPath().endsWith(".json")) continue;
            Constants.LOGGER.debug("Loading custom preset: {}", (Object)child.toPath());
            try {
                CUSTOM_PRESETS.add(Common.loadCustomPreset(child.toPath(), wrapperLookup));
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error loading while loading preset {}: {}", (Object)child.toPath(), (Object)e);
            }
            Constants.LOGGER.info("Loaded custom preset: {}", (Object)child.toPath());
        }
        Constants.LOGGER.info("Loaded custom presets");
    }

    public static void onResourceManagerReload(class_7225.class_7874 wrapperLookup, class_3300 manager) {
        Constants.LOGGER.debug("Loading presets");
        PRESETS.clear();
        DEFAULT_PRESET = null;
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)wrapperLookup);
        for (Map.Entry entry : manager.method_14488("presets", path -> path.toString().endsWith(".json")).entrySet()) {
            class_2960 identifier = (class_2960)entry.getKey();
            class_3298 resource = (class_3298)entry.getValue();
            try {
                InputStream stream = resource.method_14482();
                try {
                    Constants.LOGGER.debug("Loading preset {}", (Object)identifier);
                    JsonElement json = JsonParser.parseString((String)new String(stream.readAllBytes(), StandardCharsets.UTF_8));
                    SkyGridPreset preset = (SkyGridPreset)SkyGridPreset.CODEC_V2.parse((DynamicOps)ops, (Object)json).getOrThrow();
                    PRESETS.add(preset);
                    if (identifier.equals((Object)class_2960.method_60655((String)"skygrid_reloaded", (String)"presets/modern.json"))) {
                        DEFAULT_PRESET = preset;
                    }
                    Constants.LOGGER.info("Loaded preset {}", (Object)identifier);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error occurred while loading preset json: {}", (Object)identifier, (Object)e);
            }
        }
        Constants.LOGGER.info("Loaded presets");
    }
}

