/*
 * Decompiled with CFR 0.152.
 */
package net.spacerulerwill.skygrid_reloaded.ui.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_7923;
import net.spacerulerwill.skygrid_reloaded.ui.screen.CustomizeSkyGridScreen;
import net.spacerulerwill.skygrid_reloaded.ui.screen.DimensionSpecificCustomizableListWidgetScreen;
import net.spacerulerwill.skygrid_reloaded.ui.widget.WeightSliderListWidgetEntry;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridConfig;

public class CustomizeBlocksScreen
extends DimensionSpecificCustomizableListWidgetScreen<BlockWeightListEntry, class_2248> {
    private static final double INITIAL_BLOCK_WEIGHT = 160.0;
    private static final double MIN_BLOCK_WEIGHT = 0.0;
    private static final double MAX_BLOCK_WEIGHT = 500.0;

    public CustomizeBlocksScreen(CustomizeSkyGridScreen parent, List<class_5321<class_5363>> dimensions, class_5321<class_5363> initialDimension, SkyGridConfig currentConfig) {
        super(parent, dimensions, initialDimension, currentConfig, (class_2561)class_2561.method_43471((String)"createWorld.customize.skygrid.blocks"), (class_2561)class_2561.method_43471((String)"createWorld.customize.skygrid.blocks.placeholder"), 25);
    }

    private static class_1792 getBlockItem(class_2248 block) {
        if (block.equals(class_2246.field_10164)) {
            return class_1802.field_8187;
        }
        if (block.equals(class_2246.field_10382)) {
            return class_1802.field_8705;
        }
        return block.method_8389();
    }

    @Override
    public void onClear() {
        Map<class_2248, Double> blocks = this.getCurrentBlocks();
        blocks.clear();
    }

    @Override
    protected Optional<class_2248> getThingFromString(String text) {
        try {
            return class_7923.field_41175.method_17966(class_2960.method_60654((String)text));
        }
        catch (class_151 e) {
            return Optional.empty();
        }
    }

    @Override
    protected List<DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry> getAutocompleteSuggestions(String text) {
        ArrayList<DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry> results = new ArrayList<DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry>();
        if (text.isBlank()) {
            return results;
        }
        class_7923.field_41175.forEach(block -> {
            String displayString = class_2561.method_43471((String)block.method_63499()).getString();
            String valueString = class_7923.field_41175.method_10221(block).toString();
            if (displayString.trim().toLowerCase().startsWith(text) || valueString.startsWith(text)) {
                results.add(new DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry(CustomizeBlocksScreen.getBlockItem(block), displayString, valueString, this.field_22793));
            }
        });
        return results;
    }

    @Override
    protected void onAdd(class_2248 block) {
        Map<class_2248, Double> blocks = this.getCurrentBlocks();
        if (blocks.containsKey(block)) {
            throw new IllegalStateException("Add button called while item to add is already present");
        }
        blocks.put(block, 160.0);
        this.listWidget.addEntry(new BlockWeightListEntry(block));
    }

    @Override
    protected boolean canAdd(class_2248 block) {
        return !this.getCurrentBlocks().containsKey(block);
    }

    @Override
    protected void onDelete(BlockWeightListEntry entry) {
        Map<class_2248, Double> blocks = this.getCurrentBlocks();
        blocks.remove(entry.block);
    }

    private Map<class_2248, Double> getCurrentBlocks() {
        return this.currentConfig.dimensions.get((Object)this.currentDimension).blocks;
    }

    @Override
    protected List<BlockWeightListEntry> getEntriesFromConfig() {
        ArrayList<BlockWeightListEntry> entries = new ArrayList<BlockWeightListEntry>();
        Map<class_2248, Double> blocks = this.getCurrentBlocks();
        for (Map.Entry<class_2248, Double> entry : blocks.entrySet()) {
            class_2248 block = entry.getKey();
            double weight = entry.getValue();
            entries.add(new BlockWeightListEntry(block, weight));
        }
        return entries;
    }

    public class BlockWeightListEntry
    extends WeightSliderListWidgetEntry<BlockWeightListEntry> {
        private final class_2248 block;

        public BlockWeightListEntry(class_2248 block) {
            super((class_2561)block.method_9518(), 0.0, 500.0, 160.0);
            this.block = block;
        }

        public BlockWeightListEntry(class_2248 block, double initialWeight) {
            super((class_2561)block.method_9518(), 0.0, 500.0, initialWeight);
            this.block = block;
        }

        @Override
        public void applyWeight(double weight) {
            Map<class_2248, Double> blocks = CustomizeBlocksScreen.this.getCurrentBlocks();
            blocks.put(this.block, weight);
        }

        @Override
        public class_1792 getIcon() {
            return CustomizeBlocksScreen.getBlockItem(this.block);
        }
    }
}

