/*
 * Decompiled with CFR 0.152.
 */
package net.spacerulerwill.skygrid_reloaded.ui.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_7923;
import net.spacerulerwill.skygrid_reloaded.ui.screen.CustomizeSkyGridScreen;
import net.spacerulerwill.skygrid_reloaded.ui.screen.DimensionSpecificCustomizableListWidgetScreen;
import net.spacerulerwill.skygrid_reloaded.ui.widget.WeightSliderListWidgetEntry;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridConfig;

public class CustomizeLootScreen
extends DimensionSpecificCustomizableListWidgetScreen<ItemWeightListEntry, class_1792> {
    private static final double INITIAL_ITEM_WEIGHT = 50.0;
    private static final double MIN_ITEM_WEIGHT = 0.0;
    private static final double MAX_ITEM_WEIGHT = 100.0;

    public CustomizeLootScreen(CustomizeSkyGridScreen parent, List<class_5321<class_5363>> dimensions, class_5321<class_5363> initialDimension, SkyGridConfig currentConfig) {
        super(parent, dimensions, initialDimension, currentConfig, (class_2561)class_2561.method_43471((String)"createWorld.customize.skygrid.loot"), (class_2561)class_2561.method_43471((String)"createWorld.customize.loot.placeholder"), 25);
    }

    @Override
    public void onClear() {
        Map<class_1792, Double> blocks = this.getChestItems();
        blocks.clear();
    }

    @Override
    protected Optional<class_1792> getThingFromString(String text) {
        try {
            return class_7923.field_41178.method_17966(class_2960.method_60654((String)text));
        }
        catch (class_151 e) {
            return Optional.empty();
        }
    }

    @Override
    protected List<DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry> getAutocompleteSuggestions(String text) {
        ArrayList<DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry> results = new ArrayList<DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry>();
        if (text.isBlank()) {
            return results;
        }
        class_7923.field_41178.forEach(item -> {
            if (item == class_1802.field_8162) {
                return;
            }
            String displayString = class_2561.method_43471((String)item.method_7876()).getString();
            String valueString = class_7923.field_41178.method_10221(item).toString();
            if (displayString.trim().toLowerCase().startsWith(text) || valueString.startsWith(text)) {
                results.add(new DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry((class_1792)item, displayString, valueString, this.field_22793));
            }
        });
        return results;
    }

    @Override
    protected void onAdd(class_1792 item) {
        Map<class_1792, Double> chestItems = this.getChestItems();
        if (chestItems.containsKey(item)) {
            throw new IllegalStateException("Add button called while item to add is already present");
        }
        chestItems.put(item, 50.0);
        this.listWidget.addEntry(new ItemWeightListEntry(item));
    }

    @Override
    protected boolean canAdd(class_1792 item) {
        return !this.getChestItems().containsKey(item);
    }

    @Override
    protected void onDelete(ItemWeightListEntry entry) {
        Map<class_1792, Double> chestItems = this.getChestItems();
        chestItems.remove(entry.item);
    }

    private Map<class_1792, Double> getChestItems() {
        return this.currentConfig.dimensions.get((Object)this.currentDimension).chestItems;
    }

    @Override
    protected List<ItemWeightListEntry> getEntriesFromConfig() {
        ArrayList<ItemWeightListEntry> entries = new ArrayList<ItemWeightListEntry>();
        Map<class_1792, Double> chestItems = this.getChestItems();
        for (Map.Entry<class_1792, Double> entry : chestItems.entrySet()) {
            class_1792 item = entry.getKey();
            double weight = entry.getValue();
            entries.add(new ItemWeightListEntry(item, weight));
        }
        return entries;
    }

    public class ItemWeightListEntry
    extends WeightSliderListWidgetEntry<ItemWeightListEntry> {
        private final class_1792 item;

        public ItemWeightListEntry(class_1792 item) {
            super(item.method_63680(), 0.0, 100.0, 50.0);
            this.item = item;
        }

        public ItemWeightListEntry(class_1792 item, double initialWeight) {
            super(item.method_63680(), 0.0, 100.0, initialWeight);
            this.item = item;
        }

        @Override
        public void applyWeight(double weight) {
            Map<class_1792, Double> items = CustomizeLootScreen.this.getChestItems();
            items.put(this.item, weight);
        }

        @Override
        public class_1792 getIcon() {
            return this.item;
        }
    }
}

