/*
 * Decompiled with CFR 0.152.
 */
package net.spacerulerwill.skygrid_reloaded.ui.screen;

import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_1973;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_525;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_5676;
import net.minecraft.class_6885;
import net.minecraft.class_7193;
import net.minecraft.class_7924;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import net.minecraft.class_9248;
import net.spacerulerwill.skygrid_reloaded.Common;
import net.spacerulerwill.skygrid_reloaded.ui.screen.CustomizeBlocksScreen;
import net.spacerulerwill.skygrid_reloaded.ui.screen.CustomizeLootScreen;
import net.spacerulerwill.skygrid_reloaded.ui.screen.CustomizeSpawnerScreen;
import net.spacerulerwill.skygrid_reloaded.ui.screen.SelectBiomesScreen;
import net.spacerulerwill.skygrid_reloaded.ui.screen.SkyGridPresetsScreen;
import net.spacerulerwill.skygrid_reloaded.ui.widget.ClickableWidgetList;
import net.spacerulerwill.skygrid_reloaded.ui.widget.IntSlider;
import net.spacerulerwill.skygrid_reloaded.util.CheckerboardColumnBiomeSourceSizeAccessor;
import net.spacerulerwill.skygrid_reloaded.util.CreateWorldScreenExtension;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridChunkGenerator;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridChunkGeneratorConfig;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridConfig;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridPreset;

public class CustomizeSkyGridScreen
extends class_437 {
    public static final List<class_5321<class_5363>> VANILLA_DIMENSIONS = List.of(class_5363.field_25412, class_5363.field_25413, class_5363.field_25414);
    private static final class_2561 TITLE_TEXT = class_2561.method_43471((String)"createWorld.customize.skygrid.title");
    private static final class_2561 BLOCKS_TEXT = class_2561.method_43471((String)"createWorld.customize.skygrid.blocks");
    private static final class_2561 BiOMES_TEXT = class_2561.method_43471((String)"createWorld.customize.skygrid.biomes");
    private static final class_2561 SPAWNERS_TEXT = class_2561.method_43471((String)"createWorld.customize.skygrid.spawners");
    private static final class_2561 LOOT_TEXT = class_2561.method_43471((String)"createWorld.customize.skygrid.loot");
    private static final class_2561 PRESETS_TEXT = class_2561.method_43471((String)"createWorld.customize.skygrid.presets");
    private final class_8132 layout = new class_8132((class_437)this);
    private final class_525 parent;
    private final IntSlider biomeScaleSlider;
    private final List<class_5321<class_5363>> dimensions;
    private ClickableWidgetList body;
    private class_5676<class_5321<class_5363>> dimensionsSelector;
    private SkyGridConfig currentConfig;
    private class_5321<class_5363> currentDimension;

    public CustomizeSkyGridScreen(class_525 parent) {
        super(TITLE_TEXT);
        this.currentConfig = new SkyGridConfig(Common.DEFAULT_PRESET.config);
        this.currentDimension = class_5363.field_25412;
        this.parent = parent;
        this.biomeScaleSlider = new IntSlider(0, 0, 100, 20, (class_2561)class_2561.method_43471((String)"createWorld.customize.skygrid.biome_scale"), 0, 62, ((CheckerboardColumnBiomeSourceSizeAccessor)this.getCurrentConfig().checkerboardBiomeSource).skygrid_reloaded$getSize(), newValue -> {
            SkyGridChunkGeneratorConfig currentConfig = this.getCurrentConfig();
            currentConfig.checkerboardBiomeSource = new class_1973((class_6885)class_6885.method_40242(currentConfig.checkerboardBiomeSource.method_28443().stream().toList()), newValue.intValue());
        });
        this.dimensions = this.getAllDimensions();
        this.ensureAllDimensionsHaveConfigs();
    }

    private SkyGridChunkGeneratorConfig getCurrentConfig() {
        return this.currentConfig.dimensions.get(this.currentDimension);
    }

    public void updateBiomeScaleSlider() {
        this.biomeScaleSlider.setValue(((CheckerboardColumnBiomeSourceSizeAccessor)this.getCurrentConfig().checkerboardBiomeSource).skygrid_reloaded$getSize());
    }

    private List<class_5321<class_5363>> getAllDimensions() {
        ArrayList<class_5321<class_5363>> result = new ArrayList<class_5321<class_5363>>();
        class_7193 worldCreationContext = this.parent.method_48657().method_48728();
        worldCreationContext.comp_1028().comp_1014().forEach((levelStemResourceKey, levelStem) -> result.add((class_5321<class_5363>)levelStemResourceKey));
        ArrayList<class_5321> datapackDims = new ArrayList<class_5321>(worldCreationContext.comp_1027().method_42021());
        datapackDims.sort(Comparator.comparing(key -> key.toString()));
        result.addAll(datapackDims);
        return result;
    }

    protected void method_25426() {
        this.layout.method_57726(TITLE_TEXT, this.field_22793);
        List<class_5676> firstRow = List.of(new class_5676.class_5677(value -> class_2561.method_43471((String)value.method_29177().method_42094())).method_32620(this.dimensions).method_32617(0, 0, 158, 20, (class_2561)class_2561.method_43471((String)"createWorld.customize.skygrid.dimension"), (button, dimension) -> {
            this.currentDimension = dimension;
            this.updateBiomeScaleSlider();
        }));
        List<class_4185> secondRow = List.of(class_4185.method_46430((class_2561)BLOCKS_TEXT, button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new CustomizeBlocksScreen(this, this.dimensions, this.currentDimension, this.currentConfig));
            }
        }).method_46431(), class_4185.method_46430((class_2561)SPAWNERS_TEXT, button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new CustomizeSpawnerScreen(this, this.dimensions, this.currentDimension, this.currentConfig));
            }
        }).method_46431());
        List<IntSlider> thirdRow = List.of(class_4185.method_46430((class_2561)BiOMES_TEXT, button -> {
            if (this.field_22787 != null) {
                class_2378 biomeRegistry = this.parent.method_48657().method_48728().method_45689().method_30530(class_7924.field_41236);
                this.field_22787.method_1507((class_437)new SelectBiomesScreen(this, (class_2378<class_1959>)biomeRegistry, this.dimensions, this.currentDimension, this.currentConfig));
            }
        }).method_46431(), this.biomeScaleSlider);
        List<class_4185> fourthRow = List.of(class_4185.method_46430((class_2561)LOOT_TEXT, button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new CustomizeLootScreen(this, this.dimensions, this.currentDimension, this.currentConfig));
            }
        }).method_46431(), class_4185.method_46430((class_2561)PRESETS_TEXT, button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new SkyGridPresetsScreen(this.field_22787, this, this.parent.method_48657().method_48728().method_45689()));
            }
        }).method_46431());
        List<List<class_339>> rows = List.of(firstRow, secondRow, thirdRow, fourthRow);
        this.body = (ClickableWidgetList)this.layout.method_48999((class_8021)new ClickableWidgetList(this.field_22787, rows, this.field_22789, this.layout.method_57727(), this.layout.method_48998()));
        class_8667 footerRow = class_8667.method_52742().method_52735(8);
        footerRow.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
            this.done();
            this.method_25419();
        }).method_46431());
        footerRow.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.method_25419()).method_46431());
        this.layout.method_48996((class_8021)footerRow);
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.method_48640();
    }

    protected void method_48640() {
        this.layout.method_48222();
        if (this.body != null) {
            this.body.method_57712(this.field_22789, this.layout);
        }
    }

    private void ensureAllDimensionsHaveConfigs() {
        this.dimensions.forEach(levelStemResourceKey -> {
            if (!this.currentConfig.dimensions.containsKey(levelStemResourceKey)) {
                this.currentConfig.dimensions.put((class_5321<class_5363>)levelStemResourceKey, new SkyGridChunkGeneratorConfig());
            }
        });
    }

    public void updateSkyGridConfig(SkyGridConfig config) {
        this.currentConfig = config;
        this.ensureAllDimensionsHaveConfigs();
    }

    public SkyGridConfig getCurrentSkyGridConfig() {
        return this.currentConfig;
    }

    private void done() {
        this.updateDatapackDimensions();
    }

    private void updateDatapackDimensions() {
        class_7193 settings = this.parent.method_48657().method_48728();
        class_2378 oldDatapackDimensions = settings.comp_1027();
        class_2370 newDatapackDimensions = new class_2370(class_7924.field_41224, Lifecycle.stable());
        class_5455.class_6890 dynamicRegistryManager = settings.method_45689();
        class_2378 biomeRegistry = dynamicRegistryManager.method_30530(class_7924.field_41236);
        this.currentConfig.dimensions.forEach((levelStemResourceKey, config) -> {
            boolean hasNonZeroBlock = config.blocks.values().stream().anyMatch(weight -> weight > 0.0);
            if (hasNonZeroBlock) {
                class_5363 levelStem = VANILLA_DIMENSIONS.contains(levelStemResourceKey) ? (class_5363)this.parent.method_48657().method_48728().comp_1028().comp_1014().get(levelStemResourceKey) : (class_5363)oldDatapackDimensions.method_29107(levelStemResourceKey);
                if (config.checkerboardBiomeSource.method_28443().isEmpty()) {
                    List biomes = levelStem.comp_1013().method_12098().method_28443().stream().toList();
                    config.checkerboardBiomeSource = new class_1973((class_6885)class_6885.method_40242(biomes), 1);
                }
                class_2874 type = (class_2874)levelStem.comp_1012().comp_349();
                SkyGridChunkGenerator chunkGenerator = new SkyGridChunkGenerator(type.comp_651(), type.comp_652(), (SkyGridChunkGeneratorConfig)config);
                class_5363 newLevelStem = new class_5363(levelStem.comp_1012(), (class_2794)chunkGenerator);
                newDatapackDimensions.method_10272(levelStemResourceKey, (Object)newLevelStem, class_9248.field_49136);
            } else {
                newDatapackDimensions.method_10272(levelStemResourceKey, (Object)((CreateWorldScreenExtension)this.parent).skygrid_reloaded$getDefaultLevelStems().get(levelStemResourceKey), class_9248.field_49136);
            }
        });
        settings = this.parent.method_48657().method_48728();
        class_7193 worldCreationContext = new class_7193(settings.comp_616(), (class_2378)newDatapackDimensions, settings.comp_1028(), settings.comp_1029(), settings.comp_619(), settings.comp_1030(), settings.comp_3218());
        this.parent.method_48657().method_48701(worldCreationContext);
    }

    public void setConfigFromPreset(SkyGridPreset preset) {
        this.currentConfig = new SkyGridConfig(preset.config);
        this.ensureAllDimensionsHaveConfigs();
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)this.parent);
        }
    }
}

