/*
 * Decompiled with CFR 0.152.
 */
package net.spacerulerwill.skygrid_reloaded.ui.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_151;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4280;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_7923;
import net.spacerulerwill.skygrid_reloaded.ui.screen.CustomizeSkyGridScreen;
import net.spacerulerwill.skygrid_reloaded.ui.screen.DimensionSpecificCustomizableListWidgetScreen;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridConfig;

public class CustomizeSpawnerScreen
extends DimensionSpecificCustomizableListWidgetScreen<EntityListWidgetEntry, class_1299<?>> {
    public CustomizeSpawnerScreen(CustomizeSkyGridScreen parent, List<class_5321<class_5363>> dimensions, class_5321<class_5363> initialDimension, SkyGridConfig currentConfig) {
        super(parent, dimensions, initialDimension, currentConfig, (class_2561)class_2561.method_43471((String)"createWorld.customize.skygrid.spawners"), (class_2561)class_2561.method_43471((String)"createWorld.customize.skygrid.spawners.placeholder"), 15);
    }

    private Set<class_1299<?>> getSpawnerEntities() {
        return this.currentConfig.dimensions.get((Object)this.currentDimension).spawnerEntities;
    }

    @Override
    protected void onClear() {
        Set<class_1299<?>> entities = this.getSpawnerEntities();
        entities.clear();
    }

    @Override
    protected Optional<class_1299<?>> getThingFromString(String text) {
        try {
            return class_7923.field_41177.method_17966(class_2960.method_60654((String)text));
        }
        catch (class_151 e) {
            return Optional.empty();
        }
    }

    @Override
    protected List<DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry> getAutocompleteSuggestions(String text) {
        ArrayList<DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry> results = new ArrayList<DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry>();
        if (text.isBlank()) {
            return results;
        }
        class_7923.field_41177.forEach(entityType -> {
            String displayString = class_2561.method_43471((String)entityType.method_5882()).getString();
            String valueString = class_7923.field_41177.method_10221(entityType).toString();
            if (displayString.trim().toLowerCase().startsWith(text) || valueString.startsWith(text)) {
                results.add(new DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry(null, displayString, valueString, this.field_22793));
            }
        });
        return results;
    }

    @Override
    protected void onAdd(class_1299<?> entity) {
        Set<class_1299<?>> entities = this.getSpawnerEntities();
        if (entities.contains(entity)) {
            throw new IllegalStateException("Add button called while item to add is already present");
        }
        entities.add(entity);
        this.listWidget.addEntry(new EntityListWidgetEntry(entity));
    }

    @Override
    protected boolean canAdd(class_1299<?> entity) {
        return !this.getSpawnerEntities().contains(entity);
    }

    @Override
    protected void onDelete(EntityListWidgetEntry entry) {
        Set<class_1299<?>> entities = this.getSpawnerEntities();
        entities.remove(entry.entityType);
    }

    @Override
    protected List<EntityListWidgetEntry> getEntriesFromConfig() {
        ArrayList<EntityListWidgetEntry> entries = new ArrayList<EntityListWidgetEntry>();
        Set<class_1299<?>> entities = this.getSpawnerEntities();
        for (class_1299<?> entity : entities) {
            entries.add(new EntityListWidgetEntry(entity));
        }
        return entries;
    }

    protected class EntityListWidgetEntry
    extends class_4280.class_4281<EntityListWidgetEntry> {
        private final class_1299<?> entityType;

        public EntityListWidgetEntry(class_1299<?> entityType) {
            this.entityType = entityType;
        }

        public class_2561 method_37006() {
            return class_2561.method_43473();
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            context.method_51439(CustomizeSpawnerScreen.this.field_22793, this.entityType.method_5897(), x + 3, y + 2, 0xFFFFFF, false);
        }
    }
}

