/*
 * Decompiled with CFR 0.152.
 */
package net.spacerulerwill.skygrid_reloaded.ui.screen;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5676;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import net.spacerulerwill.skygrid_reloaded.ui.screen.CustomizeSkyGridScreen;
import net.spacerulerwill.skygrid_reloaded.ui.util.RenderUtils;
import net.spacerulerwill.skygrid_reloaded.ui.widget.TextField;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DimensionSpecificCustomizableListWidgetScreen<T extends class_4280.class_4281<T>, V>
extends class_437 {
    private static final class_2561 CLEAR_TEXT = class_2561.method_43471((String)"createWorld.customize.skygrid.clear");
    private final class_8132 layout = new class_8132((class_437)this);
    private final class_2561 title;
    private final class_2561 textFieldPlaceholder;
    private final CustomizeSkyGridScreen parent;
    private final int entryHeight;
    protected ListWidget listWidget;
    protected SearchTextField textField;
    protected class_5321<class_5363> currentDimension;
    private final List<class_5321<class_5363>> dimensions;
    protected SkyGridConfig currentConfig;
    private class_4185 addButton;
    private class_4185 deleteButton;
    private class_5676<class_5321<class_5363>> dimensionsSelector;
    private class_4185 doneButton;
    private class_4185 cancelButton;

    public DimensionSpecificCustomizableListWidgetScreen(CustomizeSkyGridScreen parent, List<class_5321<class_5363>> dimensions, class_5321<class_5363> initialDimension, SkyGridConfig currentConfig, class_2561 title, class_2561 textFieldPlaceholder, int entryHeight) {
        super(title);
        this.title = title;
        this.textFieldPlaceholder = textFieldPlaceholder;
        this.entryHeight = entryHeight;
        this.parent = parent;
        this.currentConfig = new SkyGridConfig(currentConfig);
        this.currentDimension = initialDimension;
        this.dimensions = dimensions;
    }

    private void initHeader() {
        this.layout.method_57726(this.title, this.field_22793);
    }

    private void initBody() {
        this.listWidget = (ListWidget)this.layout.method_48999((class_8021)new ListWidget(this.field_22787, this.field_22789, this.field_22790 - 117, 43, this.entryHeight));
    }

    private void initFooter() {
        class_8667 rows = class_8667.method_52741().method_52735(4);
        class_8667 row1 = class_8667.method_52742().method_52735(8);
        this.doneButton = (class_4185)row1.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
            this.parent.updateSkyGridConfig(this.currentConfig);
            this.method_25419();
        }).method_46432(75).method_46431());
        this.cancelButton = (class_4185)row1.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.method_25419()).method_46432(75).method_46431());
        row1.method_52736((class_8021)class_4185.method_46430((class_2561)CLEAR_TEXT, button -> {
            this.onClear();
            this.listWidget.method_25339();
            this.listWidget.method_44382(0.0);
            this.updateAddButtonActive();
        }).method_46432(75).method_46431());
        class_8667 row2 = class_8667.method_52742().method_52735(8);
        this.dimensionsSelector = (class_5676)row2.method_52736((class_8021)new class_5676.class_5677(value -> class_2561.method_43471((String)value.method_29177().method_42094())).method_32620(this.dimensions).method_32619(this.currentDimension).method_32617(0, 0, 158, 20, (class_2561)class_2561.method_43471((String)"createWorld.customize.skygrid.dimension"), (button, dimension) -> {
            this.currentDimension = dimension;
            this.regenerateListEntries();
            this.updateAddButtonActive();
            this.updateDeleteButtonActive();
        }));
        this.deleteButton = (class_4185)row2.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"createWorld.customize.skygrid.delete"), button -> {
            class_4280.class_4281 entry = (class_4280.class_4281)this.listWidget.method_25334();
            if (entry == null) {
                return;
            }
            this.listWidget.removeEntry(entry);
            this.onDelete(entry);
            this.updateAddButtonActive();
            this.updateDeleteButtonActive();
        }).method_46432(75).method_46431());
        class_8667 row3 = class_8667.method_52742().method_52735(8);
        this.textField = (SearchTextField)row3.method_52736((class_8021)new SearchTextField(this.field_22793, 158, 20, this.textFieldPlaceholder));
        this.addButton = (class_4185)row3.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"createWorld.customize.skygrid.add"), button -> {
            Optional<V> v = this.getSelectedThing();
            v.ifPresent(this::onAdd);
            this.updateAddButtonActive();
            this.updateDeleteButtonActive();
            this.listWidget.method_44382(this.listWidget.method_44390());
        }).method_46432(75).method_46431());
        rows.method_52736((class_8021)row3);
        rows.method_52736((class_8021)row2);
        rows.method_52736((class_8021)row1);
        this.layout.method_48996((class_8021)rows);
        this.layout.method_48991(80);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        AtomicBoolean mouseOverAnyWidget = new AtomicBoolean(false);
        this.layout.method_48206(widget -> {
            if (widget.method_25405(mouseX, mouseY)) {
                mouseOverAnyWidget.set(true);
            }
        });
        if (!(mouseOverAnyWidget.get() || this.textField.method_25405(mouseX, mouseY) || this.textField.autocompleteListWidget != null && this.textField.autocompleteListWidget.method_25405(mouseX, mouseY))) {
            if (this.textField.autocompleteListWidget != null) {
                this.method_37066((class_364)this.textField.autocompleteListWidget);
                this.showWidgetsForAutocompleteBox();
                this.textField.autocompleteListWidget = null;
            }
            this.textField.method_25365(false);
        } else if (this.textField.method_25405(mouseX, mouseY) && this.textField.autocompleteListWidget == null) {
            this.textField.doAutocompleteStuff();
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected void method_25426() {
        this.initHeader();
        this.initBody();
        this.initFooter();
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.regenerateListEntries();
        this.method_48640();
        this.updateAddButtonActive();
        this.updateDeleteButtonActive();
    }

    protected void method_48640() {
        this.layout.method_48222();
        if (this.listWidget != null) {
            this.listWidget.method_57712(this.field_22789, this.layout);
        }
        this.textField.refreshPositions();
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)this.parent);
        }
    }

    private void regenerateListEntries() {
        this.listWidget.method_25314(this.getEntriesFromConfig());
        this.listWidget.method_44382(0.0);
    }

    private void updateAddButtonActive() {
        Optional<V> thing = this.getSelectedThing();
        this.addButton.field_22763 = thing.isPresent() && this.canAdd(thing.get());
    }

    private void updateDeleteButtonActive() {
        class_4280.class_4281 entry = (class_4280.class_4281)this.listWidget.method_25334();
        this.deleteButton.field_22763 = entry != null;
    }

    private void hideWidgetsForAutocompleteBox() {
        this.method_37066((class_364)this.doneButton);
        this.method_37066((class_364)this.cancelButton);
        this.method_37066((class_364)this.dimensionsSelector);
    }

    private void showWidgetsForAutocompleteBox() {
        this.method_37063((class_364)this.doneButton);
        this.method_37063((class_364)this.cancelButton);
        this.method_37063((class_364)this.dimensionsSelector);
    }

    protected abstract void onClear();

    protected abstract Optional<V> getThingFromString(String var1);

    protected abstract List<AutocompleteListWidget.Entry> getAutocompleteSuggestions(String var1);

    protected abstract void onAdd(V var1);

    protected abstract boolean canAdd(V var1);

    protected abstract void onDelete(T var1);

    protected abstract List<T> getEntriesFromConfig();

    private Optional<V> getSelectedThing() {
        AutocompleteListWidget.Entry entry;
        Optional thing1 = this.getThingFromString(this.textField.method_1882());
        Optional<Object> thing2 = Optional.empty();
        if (this.textField.autocompleteListWidget != null && (entry = (AutocompleteListWidget.Entry)this.textField.autocompleteListWidget.method_25334()) != null) {
            thing2 = this.getThingFromString(entry.valueText);
        }
        return thing2.or(() -> thing1);
    }

    protected class ListWidget
    extends class_4280<T> {
        public ListWidget(class_310 minecraftClient, int i, int j, int k, int l) {
            super(minecraftClient, i, j, k, l);
        }

        public void setSelected(@Nullable T entry) {
            super.method_25313(entry);
            DimensionSpecificCustomizableListWidgetScreen.this.updateDeleteButtonActive();
        }

        public void method_25339() {
            super.method_25339();
        }

        public boolean removeEntry(@NotNull T entry) {
            return super.method_25330(entry);
        }

        public int addEntry(@NotNull T entry) {
            return super.method_25321(entry);
        }

        public void method_64847(int index) {
            super.method_64847(index);
            DimensionSpecificCustomizableListWidgetScreen.this.updateDeleteButtonActive();
        }
    }

    protected class SearchTextField
    extends TextField {
        @Nullable
        public AutocompleteListWidget autocompleteListWidget;

        public SearchTextField(class_327 textRenderer, int x, int y, class_2561 text) {
            super(textRenderer, x, y, text);
            this.method_1880(1024);
        }

        private void refreshPositions() {
            if (this.autocompleteListWidget != null) {
                this.autocompleteListWidget.method_46421(this.method_46426());
                this.autocompleteListWidget.method_46419(this.method_46427() + this.method_25364() + 4);
            }
        }

        private void doAutocompleteStuff() {
            DimensionSpecificCustomizableListWidgetScreen.this.updateAddButtonActive();
            List<AutocompleteListWidget.Entry> autocompleteResults = DimensionSpecificCustomizableListWidgetScreen.this.getAutocompleteSuggestions(this.method_1882());
            if (autocompleteResults.isEmpty()) {
                if (this.autocompleteListWidget != null) {
                    DimensionSpecificCustomizableListWidgetScreen.this.method_37066((class_364)this.autocompleteListWidget);
                    DimensionSpecificCustomizableListWidgetScreen.this.showWidgetsForAutocompleteBox();
                    this.autocompleteListWidget = null;
                }
            } else if (this.autocompleteListWidget == null) {
                this.autocompleteListWidget = new AutocompleteListWidget(DimensionSpecificCustomizableListWidgetScreen.this.field_22787, DimensionSpecificCustomizableListWidgetScreen.this);
                this.refreshPositions();
                for (AutocompleteListWidget.Entry entry : autocompleteResults) {
                    this.autocompleteListWidget.addEntry(entry);
                }
                DimensionSpecificCustomizableListWidgetScreen.this.method_37063((class_364)this.autocompleteListWidget);
                DimensionSpecificCustomizableListWidgetScreen.this.hideWidgetsForAutocompleteBox();
            } else {
                this.autocompleteListWidget.method_25314(autocompleteResults);
            }
        }

        @Override
        protected void onTextChanged() {
            this.doAutocompleteStuff();
        }
    }

    public static class AutocompleteListWidget
    extends class_4280<Entry> {
        DimensionSpecificCustomizableListWidgetScreen<?, ?> parent;

        public AutocompleteListWidget(class_310 minecraftClient, DimensionSpecificCustomizableListWidgetScreen<?, ?> parent) {
            super(minecraftClient, 158, 44, 0, 24);
            this.parent = parent;
        }

        public int addEntry(Entry entry) {
            return super.method_25321((class_350.class_351)entry);
        }

        public int method_25322() {
            return this.method_25368() - 16;
        }

        protected int method_65507() {
            return this.method_46426() + this.method_25368() - 6;
        }

        public boolean method_25405(double mouseX, double mouseY) {
            for (int i = 0; i < this.method_25340(); ++i) {
                Entry entry = (Entry)this.method_25326(i);
                if (!entry.method_25405(mouseX, mouseY)) continue;
                return true;
            }
            return super.method_25405(mouseX, mouseY);
        }

        public void setSelected(@Nullable Entry entry) {
            super.method_25313((class_350.class_351)entry);
            this.parent.updateAddButtonActive();
        }

        public void method_64847(int index) {
            super.method_64847(index);
            this.parent.updateAddButtonActive();
        }

        public static class Entry
        extends class_4280.class_4281<Entry> {
            public final String valueText;
            @Nullable
            private final class_1792 iconItem;
            private final String displayText;
            private final class_327 textRenderer;

            public Entry(@Nullable class_1792 iconItem, String displayText, String valueText, class_327 textRenderer) {
                this.iconItem = iconItem;
                this.displayText = displayText;
                this.valueText = valueText;
                this.textRenderer = textRenderer;
            }

            public class_2561 method_37006() {
                return class_2561.method_43473();
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                if (this.iconItem == null) {
                    context.method_51433(this.textRenderer, this.displayText, x + 5, y + 5, 0xFFFFFF, false);
                } else {
                    RenderUtils.renderItemIcon(this.iconItem, context, x, y);
                    context.method_51433(this.textRenderer, this.displayText, x + 18 + 5, y + 5, 0xFFFFFF, false);
                }
            }
        }
    }
}

