/*
 * Decompiled with CFR 0.152.
 */
package net.spacerulerwill.skygrid_reloaded.ui.screen;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_151;
import net.minecraft.class_1959;
import net.minecraft.class_1973;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4280;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.spacerulerwill.skygrid_reloaded.ui.screen.CustomizeSkyGridScreen;
import net.spacerulerwill.skygrid_reloaded.ui.screen.DimensionSpecificCustomizableListWidgetScreen;
import net.spacerulerwill.skygrid_reloaded.util.CheckerboardColumnBiomeSourceSizeAccessor;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridChunkGeneratorConfig;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridConfig;

public class SelectBiomesScreen
extends DimensionSpecificCustomizableListWidgetScreen<BiomeListWidgetEntry, class_6880<class_1959>> {
    private final class_2378<class_1959> biomeRegistry;

    public SelectBiomesScreen(CustomizeSkyGridScreen parent, class_2378<class_1959> biomeRegistry, List<class_5321<class_5363>> dimensions, class_5321<class_5363> initialDimension, SkyGridConfig currentConfig) {
        super(parent, dimensions, initialDimension, currentConfig, (class_2561)class_2561.method_43471((String)"createWorld.customize.skygrid.biomes"), (class_2561)class_2561.method_43471((String)"createWorld.customize.skygrid.spawners.placeholder"), 15);
        this.biomeRegistry = biomeRegistry;
    }

    private SkyGridChunkGeneratorConfig getConfig() {
        return this.currentConfig.dimensions.get(this.currentDimension);
    }

    @Override
    protected void onClear() {
        SkyGridChunkGeneratorConfig currentConfig = this.getConfig();
        class_1973 currentBiomeSouurce = currentConfig.checkerboardBiomeSource;
        this.getConfig().checkerboardBiomeSource = new class_1973((class_6885)class_6885.method_40246((class_6880[])new class_6880[0]), ((CheckerboardColumnBiomeSourceSizeAccessor)currentBiomeSouurce).skygrid_reloaded$getSize());
    }

    @Override
    protected Optional<class_6880<class_1959>> getThingFromString(String text) {
        try {
            return this.biomeRegistry.method_17966(class_2960.method_60654((String)text)).map(arg_0 -> this.biomeRegistry.method_47983(arg_0));
        }
        catch (class_151 e) {
            return Optional.empty();
        }
    }

    @Override
    protected List<DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry> getAutocompleteSuggestions(String text) {
        ArrayList<DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry> results = new ArrayList<DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry>();
        if (text.isBlank()) {
            return results;
        }
        this.biomeRegistry.forEach(biome -> {
            String key = ((class_5321)this.biomeRegistry.method_29113(biome).get()).method_29177().method_42093("biome");
            String displayString = class_2561.method_43471((String)key).getString();
            String valueString = this.biomeRegistry.method_47983(biome).method_55840();
            if (displayString.trim().toLowerCase().startsWith(text) || valueString.startsWith(text)) {
                results.add(new DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry(null, displayString, valueString, this.field_22793));
            }
        });
        return results;
    }

    @Override
    protected void onAdd(class_6880<class_1959> thing) {
        SkyGridChunkGeneratorConfig config = this.getConfig();
        if (config.checkerboardBiomeSource.method_28443().contains(thing)) {
            throw new IllegalStateException("Add button called while item to add is already present");
        }
        class_1973 currentBiomeSource = config.checkerboardBiomeSource;
        LinkedHashSet<class_6880<class_1959>> biomes = new LinkedHashSet<class_6880<class_1959>>(currentBiomeSource.method_28443());
        biomes.add(thing);
        config.checkerboardBiomeSource = new class_1973((class_6885)class_6885.method_40242(biomes.stream().toList()), ((CheckerboardColumnBiomeSourceSizeAccessor)currentBiomeSource).skygrid_reloaded$getSize());
        this.listWidget.addEntry(new BiomeListWidgetEntry(thing));
    }

    @Override
    protected boolean canAdd(class_6880<class_1959> thing) {
        return !this.getConfig().checkerboardBiomeSource.method_28443().contains(thing);
    }

    @Override
    protected void onDelete(BiomeListWidgetEntry entry) {
        SkyGridChunkGeneratorConfig currentConfig = this.getConfig();
        class_1973 currentBiomeSource = currentConfig.checkerboardBiomeSource;
        LinkedHashSet biomes = new LinkedHashSet(currentBiomeSource.method_28443());
        biomes.remove(entry.biome);
        this.getConfig().checkerboardBiomeSource = new class_1973((class_6885)class_6885.method_40242(biomes.stream().toList()), ((CheckerboardColumnBiomeSourceSizeAccessor)currentBiomeSource).skygrid_reloaded$getSize());
    }

    @Override
    protected List<BiomeListWidgetEntry> getEntriesFromConfig() {
        ArrayList<BiomeListWidgetEntry> entries = new ArrayList<BiomeListWidgetEntry>();
        Set biomes = this.getConfig().checkerboardBiomeSource.method_28443();
        for (class_6880 biome : biomes) {
            entries.add(new BiomeListWidgetEntry((class_6880<class_1959>)biome));
        }
        return entries;
    }

    protected class BiomeListWidgetEntry
    extends class_4280.class_4281<BiomeListWidgetEntry> {
        private final class_6880<class_1959> biome;

        public BiomeListWidgetEntry(class_6880<class_1959> biome) {
            this.biome = biome;
        }

        public class_2561 method_37006() {
            return class_2561.method_43473();
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            String key = ((class_5321)this.biome.method_40230().get()).method_29177().method_42093("biome");
            context.method_51439(SelectBiomesScreen.this.field_22793, (class_2561)class_2561.method_43471((String)key), x + 3, y + 2, 0xFFFFFF, false);
        }
    }
}

