/*
 * Decompiled with CFR 0.152.
 */
package net.spacerulerwill.skygrid_reloaded.ui.screen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import net.spacerulerwill.skygrid_reloaded.Common;
import net.spacerulerwill.skygrid_reloaded.Constants;
import net.spacerulerwill.skygrid_reloaded.platform.Services;
import net.spacerulerwill.skygrid_reloaded.ui.screen.CustomizeSkyGridScreen;
import net.spacerulerwill.skygrid_reloaded.ui.widget.TextField;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridChunkGeneratorConfig;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridConfig;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridPreset;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.Nullable;

public class SkyGridPresetsScreen
extends class_437 {
    private final class_8132 layout = new class_8132((class_437)this, 33, 64);
    private final CustomizeSkyGridScreen parent;
    private final class_5455.class_6890 dynamicRegistryManager;
    private TextField textField;
    private class_4185 selectPresetButton;
    private class_4185 savePresetButton;
    private SkyGridPresetListWidget listWidget;

    protected SkyGridPresetsScreen(class_310 client, CustomizeSkyGridScreen parent, class_5455.class_6890 dynamicRegistryManager) {
        super((class_2561)class_2561.method_43471((String)"createWorld.customize.skygrid.presets"));
        this.parent = parent;
        this.dynamicRegistryManager = dynamicRegistryManager;
        Common.reloadCustomPresets((class_7225.class_7874)this.dynamicRegistryManager);
    }

    protected void method_25426() {
        this.layout.method_57726(this.field_22785, this.field_22793);
        this.listWidget = (SkyGridPresetListWidget)this.layout.method_48999((class_8021)new SkyGridPresetListWidget());
        class_8667 rows = class_8667.method_52741().method_52735(4);
        class_8667 row1 = class_8667.method_52742().method_52735(8);
        this.selectPresetButton = (class_4185)row1.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"createWorld.skygrid.customize.presets.select"), buttonWidget -> {
            SkyGridPresetListWidget.SkyGridPresetEntry entry = (SkyGridPresetListWidget.SkyGridPresetEntry)this.listWidget.method_25334();
            this.parent.setConfigFromPreset(entry.preset);
            this.parent.updateBiomeScaleSlider();
            this.field_22787.method_1507((class_437)this.parent);
        }).method_46431());
        row1.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.field_22787.method_1507((class_437)this.parent)).method_46431());
        rows.method_52736((class_8021)row1);
        class_8667 row2 = class_8667.method_52742().method_52735(8);
        this.textField = (TextField)row2.method_52736((class_8021)new PresetsTextField());
        this.savePresetButton = (class_4185)row2.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"createWorld.skygrid.customize.presets.save"), buttonWidget -> this.savePreset(this.textField.method_1882())).method_46431());
        rows.method_52736((class_8021)row2);
        rows.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.layout.method_48996((class_8021)rows);
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.updateSelectPresetButtonActive();
        this.method_48640();
        this.updateSaveButtonActive();
    }

    private void updateSaveButtonActive() {
        this.savePresetButton.field_22763 = !this.textField.method_1882().isEmpty();
    }

    protected void method_48640() {
        if (this.listWidget != null) {
            this.listWidget.method_57712(this.field_22789, this.layout);
        }
        this.layout.method_48222();
    }

    public void updateSelectPresetButtonActive() {
        this.selectPresetButton.field_22763 = this.listWidget.method_25334() != null;
    }

    public void method_25419() {
        this.field_22787.method_1507((class_437)this.parent);
    }

    private void savePreset(String name) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(name.getBytes(StandardCharsets.UTF_8));
            String hashedName = Hex.encodeHexString((byte[])hash);
            SkyGridConfig currentConfig = this.parent.getCurrentSkyGridConfig();
            boolean maxWeight = false;
            ArrayList<class_1792> allItems = new ArrayList<class_1792>();
            SkyGridChunkGeneratorConfig overworldConfig = currentConfig.dimensions.get(class_5363.field_25412);
            overworldConfig.blocks.keySet().stream().map(class_2248::method_8389).forEach(allItems::add);
            allItems.addAll(overworldConfig.chestItems.keySet());
            SkyGridChunkGeneratorConfig netherConfig = currentConfig.dimensions.get(class_5363.field_25413);
            netherConfig.blocks.keySet().stream().map(class_2248::method_8389).forEach(allItems::add);
            allItems.addAll(netherConfig.chestItems.keySet());
            SkyGridChunkGeneratorConfig endConfig = currentConfig.dimensions.get(class_5363.field_25414);
            endConfig.blocks.keySet().stream().map(class_2248::method_8389).forEach(allItems::add);
            allItems.addAll(endConfig.chestItems.keySet());
            Random random = new Random();
            class_1792 icon = (class_1792)allItems.get(random.nextInt(allItems.size()));
            SkyGridPreset preset = new SkyGridPreset(icon, name, currentConfig);
            JsonObject element = new JsonObject();
            class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)this.dynamicRegistryManager);
            DataResult json = SkyGridPreset.CODEC_V2.encode((Object)preset, (DynamicOps)ops, (Object)element);
            String jsonString = ((JsonElement)json.getOrThrow()).toString();
            String fileName = Services.PLATFORM.getConfigPath().toString() + "/skygrid_reloaded/" + hashedName + ".json";
            try (PrintWriter writer = new PrintWriter(fileName, StandardCharsets.UTF_8);){
                writer.write(jsonString);
            }
            Common.reloadCustomPresets((class_7225.class_7874)this.dynamicRegistryManager);
            this.listWidget.refreshEntries();
        }
        catch (Exception e) {
            Constants.LOGGER.error("Failed to save preset {}: {}", (Object)name, (Object)e);
        }
    }

    private class SkyGridPresetListWidget
    extends class_4280<SkyGridPresetEntry> {
        public SkyGridPresetListWidget() {
            super(SkyGridPresetsScreen.this.field_22787, SkyGridPresetsScreen.this.field_22789, SkyGridPresetsScreen.this.field_22790 - 77, 33, 24);
            this.refreshEntries();
        }

        public void refreshEntries() {
            this.method_25339();
            for (SkyGridPreset preset : Common.PRESETS) {
                this.method_25321((class_350.class_351)new SkyGridPresetEntry(preset));
            }
            for (SkyGridPreset preset : Common.CUSTOM_PRESETS) {
                this.method_25321((class_350.class_351)new SkyGridCustomPresetEntry(preset));
            }
        }

        public void setSelected(@Nullable SkyGridPresetEntry entry) {
            super.method_25313((class_350.class_351)entry);
            SkyGridPresetsScreen.this.updateSelectPresetButtonActive();
        }

        public class SkyGridPresetEntry
        extends class_4280.class_4281<SkyGridPresetEntry> {
            private static final class_2960 SLOT_TEXTURE = class_2960.method_60656((String)"container/slot");
            private final SkyGridPreset preset;

            public SkyGridPresetEntry(SkyGridPreset preset) {
                this.preset = preset;
            }

            public class_2561 method_37006() {
                return class_2561.method_43473();
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                context.method_52707(class_1921::method_62277, SLOT_TEXTURE, x + 1, y + 1, 0, 18, 18);
                context.method_51445(this.preset.item.method_7854(), x + 2, y + 2);
                context.method_51439(SkyGridPresetsScreen.this.field_22793, (class_2561)class_2561.method_43471((String)this.preset.name), x + 18 + 5, y + 3, 0xFFFFFF, false);
            }
        }

        public class SkyGridCustomPresetEntry
        extends SkyGridPresetEntry {
            private final class_4185 deleteButton;

            public SkyGridCustomPresetEntry(SkyGridPreset preset) {
                super(preset);
                this.deleteButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"createWorld.skygrid.customize.presets.delete"), button -> {
                    try {
                        MessageDigest digest = MessageDigest.getInstance("SHA-256");
                        byte[] hash = digest.digest(preset.name.getBytes(StandardCharsets.UTF_8));
                        String hashedName = Hex.encodeHexString((byte[])hash);
                        String fileName = Services.PLATFORM.getConfigPath().toString() + "/skygrid_reloaded/" + hashedName + ".json";
                        File file = new File(fileName);
                        Files.deleteIfExists(file.toPath());
                        Common.reloadCustomPresets((class_7225.class_7874)SkyGridPresetsScreen.this.dynamicRegistryManager);
                        SkyGridPresetListWidget.this.method_25330((class_350.class_351)this);
                    }
                    catch (Exception e) {
                        Constants.LOGGER.error("Failed to delete preset {}: {}", (Object)preset, (Object)e);
                    }
                }).method_46432(50).method_46431();
            }

            @Override
            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                super.method_25343(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
                this.deleteButton.method_46421(x + entryWidth - this.deleteButton.method_25368() - 5);
                this.deleteButton.method_46419(y);
                this.deleteButton.method_25394(context, mouseX, mouseY, tickDelta);
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (this.deleteButton.method_25405(mouseX, mouseY)) {
                    return this.deleteButton.method_25402(mouseX, mouseY, button);
                }
                return super.method_25402(mouseX, mouseY, button);
            }
        }
    }

    protected class PresetsTextField
    extends TextField {
        public PresetsTextField() {
            super(SkyGridPresetsScreen.this.field_22793, 150, 20, (class_2561)class_2561.method_43473());
        }

        @Override
        protected void onTextChanged() {
            SkyGridPresetsScreen.this.updateSaveButtonActive();
        }
    }
}

