/*
 * Decompiled with CFR 0.152.
 */
package net.spacerulerwill.skygrid_reloaded.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_10710;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2621;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3233;
import net.minecraft.class_39;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_52;
import net.minecraft.class_5281;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8174;
import net.minecraft.class_9334;
import net.spacerulerwill.skygrid_reloaded.util.MinecraftRandomAdapter;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridChunkGeneratorConfig;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.DiscreteProbabilityCollectionSampler;

public class SkyGridChunkGenerator
extends class_2794 {
    public static final MapCodec<SkyGridChunkGenerator> MAP_CODEC_V2 = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5284.field_24781.fieldOf("settings").forGetter(generator -> {
        throw new UnsupportedOperationException("This generator does not store settings directly.");
    }), (App)SkyGridChunkGeneratorConfig.CODEC.fieldOf("skygrid_settings").forGetter(SkyGridChunkGenerator::getConfig)).apply((Applicative)instance, (settings, config) -> {
        int minY = ((class_5284)settings.comp_349()).comp_474().comp_173();
        int height = ((class_5284)settings.comp_349()).comp_474().comp_174();
        return new SkyGridChunkGenerator(minY, height, (SkyGridChunkGeneratorConfig)config);
    }));
    public static final MapCodec<SkyGridChunkGenerator> MAP_CODEC_V3 = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("min_y").forGetter(generator -> generator.minY), (App)class_5699.field_33441.fieldOf("height").forGetter(generator -> generator.height), (App)SkyGridChunkGeneratorConfig.CODEC.fieldOf("skygrid_settings").forGetter(SkyGridChunkGenerator::getConfig)).apply((Applicative)instance, SkyGridChunkGenerator::new));
    public static final MapCodec<SkyGridChunkGenerator> MAP_CODEC = new MapCodec<SkyGridChunkGenerator>(){

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.concat(MAP_CODEC_V3.keys(ops), MAP_CODEC_V2.keys(ops)).distinct();
        }

        public <T> DataResult<SkyGridChunkGenerator> decode(DynamicOps<T> ops, MapLike<T> input) {
            DataResult result = MAP_CODEC_V3.decode(ops, input);
            if (result.error().isPresent()) {
                result = MAP_CODEC_V2.decode(ops, input);
            }
            return result;
        }

        public <T> RecordBuilder<T> encode(SkyGridChunkGenerator input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return MAP_CODEC_V3.encode((Object)input, ops, prefix);
        }
    };
    public static final int MAX_BOOK_ENCHANTS = 5;
    public static final List<class_5321<class_52>> ARCHEOLOGY_LOOT_TABLES = Arrays.asList(class_39.field_43354, class_39.field_43353, class_39.field_43357, class_39.field_43356, class_39.field_44648, class_39.field_44649);
    private final SkyGridChunkGeneratorConfig config;
    private final List<class_1299<?>> entities;
    private final int minY;
    private final int height;
    private DiscreteProbabilityCollectionSampler<class_2248> blockProbabilities;
    private DiscreteProbabilityCollectionSampler<class_1792> chestItemProbabilities;

    public SkyGridChunkGenerator(int minY, int height, SkyGridChunkGeneratorConfig config) {
        super((class_1966)config.checkerboardBiomeSource);
        this.minY = minY;
        this.height = height;
        this.config = config;
        this.blockProbabilities = new DiscreteProbabilityCollectionSampler((UniformRandomProvider)new MinecraftRandomAdapter(), config.blocks);
        this.chestItemProbabilities = config.chestItems.isEmpty() ? null : new DiscreteProbabilityCollectionSampler((UniformRandomProvider)new MinecraftRandomAdapter(), config.chestItems);
        this.entities = config.spawnerEntities.stream().toList();
    }

    private static class_5819 getRandomForChunk(class_7138 noiseConfig, int x, int z) {
        return noiseConfig.method_42374().method_60628(0x60000005L * (long)x + 805306457L * (long)z + 402653189L ^ 0xC000013L);
    }

    private static void addRandomEnchantmentToItemStack(class_1799 itemStack, class_5819 random, class_2378<class_1887> enchantmentRegistry) {
        class_6880 enchantmentRegistryEntry = (class_6880)enchantmentRegistry.method_10240(random).get();
        int level = random.method_39332(1, ((class_1887)enchantmentRegistryEntry.comp_349()).method_8183());
        itemStack.method_7978(enchantmentRegistryEntry, level);
    }

    protected MapCodec<? extends class_2794> method_28506() {
        return MAP_CODEC;
    }

    public void method_12108(class_3233 chunkRegion, long seed, class_7138 noiseConfig, class_4543 biomeAccess, class_5138 structureAccessor, class_2791 chunk) {
    }

    public SkyGridChunkGeneratorConfig getConfig() {
        return this.config;
    }

    public void method_12102(class_5281 world, class_2791 chunk, class_5138 structureAccessor) {
    }

    public void method_12110(class_3233 region, class_5138 structures, class_7138 noiseConfig, class_2791 chunk) {
    }

    public void method_12107(class_3233 region) {
    }

    public void method_40450(List<String> text, class_7138 noiseConfig, class_2338 pos) {
    }

    public int method_16397(int x, int z, class_2902.class_2903 heightmap, class_5539 world, class_7138 noiseConfig) {
        return 0;
    }

    public int method_12104() {
        return this.height;
    }

    public int method_16398() {
        return 0;
    }

    public int method_33730() {
        return this.minY;
    }

    private void fillChestBlockEntityWithItems(class_2621 blockEntity, class_5819 random, class_5455 dynamicRegistryManager) {
        if (this.chestItemProbabilities != null) {
            int numItems = Math.clamp((long)random.method_39332(2, 5), 0, blockEntity.method_5439());
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int i = 0; i < blockEntity.method_5439(); ++i) {
                slots.add(i);
            }
            Collections.shuffle(slots);
            int nextSlotIdx = 0;
            for (int i = 0; i < numItems; ++i) {
                class_1792 item = (class_1792)this.chestItemProbabilities.sample();
                class_1799 itemStack = item.method_7854();
                if (item instanceof class_1812 || item.equals(class_1802.field_8087) || item.equals(class_1802.field_8766)) {
                    itemStack.method_57379(class_9334.field_49651, (Object)new class_1844((class_6880)class_7923.field_41179.method_10240(random).get()));
                } else if (item.equals(class_1802.field_39057)) {
                    class_2378 instrumentRegistry = dynamicRegistryManager.method_30530(class_7924.field_41275);
                    class_6880.class_6883 instrument = (class_6880.class_6883)instrumentRegistry.method_10240(random).get();
                    itemStack.method_57379(class_9334.field_49612, (Object)new class_10710((class_6880)instrument));
                } else if (item.equals(class_1802.field_8598)) {
                    class_2378 enchantmentRegistry = dynamicRegistryManager.method_30530(class_7924.field_41265);
                    float chance = 1.0f;
                    for (int j = 0; j < 5; ++j) {
                        if (random.method_43057() < chance) {
                            SkyGridChunkGenerator.addRandomEnchantmentToItemStack(itemStack, random, (class_2378<class_1887>)enchantmentRegistry);
                        }
                        chance *= 0.66f;
                    }
                }
                int slotIdx = (Integer)slots.get(nextSlotIdx);
                ++nextSlotIdx;
                blockEntity.method_5447(slotIdx, itemStack);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public CompletableFuture<class_2791> method_12088(class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
        dynamicRegistryManager = structureAccessor.method_41036();
        random = SkyGridChunkGenerator.getRandomForChunk(noiseConfig, chunk.method_12004().field_9181, chunk.method_12004().field_9180);
        uniformRandomProvider = new MinecraftRandomAdapter(random);
        this.blockProbabilities = this.blockProbabilities.withUniformRandomProvider((UniformRandomProvider)uniformRandomProvider);
        if (this.chestItemProbabilities != null) {
            this.chestItemProbabilities = this.chestItemProbabilities.withUniformRandomProvider((UniformRandomProvider)uniformRandomProvider);
        }
        for (x = 0; x < 16; x += 4) {
            for (z = 0; z < 16; z += 4) {
                worldX = chunk.method_12004().field_9181 * 16 + x;
                worldZ = chunk.method_12004().field_9180 * 16 + z;
                for (y = this.method_33730(); y < this.method_33730() + this.method_12104(); y += 4) {
                    block15: {
                        block14: {
                            blockPos = new class_2338(x, y, z);
                            block = (class_2248)this.blockProbabilities.sample();
                            state = (class_2680)block.method_9564().method_47968((class_2769)class_2741.field_12514, (Comparable)Boolean.valueOf(true));
                            chunk.method_66480(blockPos, state);
                            if (!(block instanceof class_2343)) continue;
                            provider = (class_2343)block;
                            blockEntityPos = new class_2338(worldX, y, worldZ);
                            blockEntity = provider.method_10123(blockEntityPos, state);
                            if (!(blockEntity instanceof class_2621)) break block14;
                            lootableContainerBlockEntity = (class_2621)blockEntity;
                            this.fillChestBlockEntityWithItems(lootableContainerBlockEntity, random, dynamicRegistryManager);
                            break block15;
                        }
                        if (!(blockEntity instanceof class_2636)) ** GOTO lbl-1000
                        mobSpawnerBlockEntity = (class_2636)blockEntity;
                        if (!this.entities.isEmpty()) {
                            mobSpawnerBlockEntity.method_46408(this.entities.get(random.method_43048(this.config.spawnerEntities.size())), random);
                        } else if (blockEntity instanceof class_8174) {
                            brushableBlockEntity = (class_8174)blockEntity;
                            lootTableIndex = random.method_39332(0, SkyGridChunkGenerator.ARCHEOLOGY_LOOT_TABLES.size() - 1);
                            brushableBlockEntity.method_49216(SkyGridChunkGenerator.ARCHEOLOGY_LOOT_TABLES.get(lootTableIndex), (long)random.method_43054());
                        }
                    }
                    chunk.method_12007(blockEntity);
                }
            }
        }
        if (chunk.method_12004().field_9181 == 0 && chunk.method_12004().field_9180 == 0) {
            chunk.method_66480(new class_2338(0, -64, 0), class_2246.field_10124.method_9564());
            chunk.method_66480(new class_2338(2, -64, 0), (class_2680)class_2246.field_10398.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11039));
            chunk.method_66480(new class_2338(0, -64, 2), (class_2680)class_2246.field_10398.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043));
            chunk.method_66480(new class_2338(2, -64, 1), (class_2680)class_2246.field_10398.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11039));
            chunk.method_66480(new class_2338(1, -64, 2), (class_2680)class_2246.field_10398.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043));
        } else if (chunk.method_12004().field_9181 == -1 && chunk.method_12004().field_9180 == 0) {
            chunk.method_66480(new class_2338(-2, -64, 0), (class_2680)class_2246.field_10398.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11034));
            chunk.method_66480(new class_2338(-2, -64, 1), (class_2680)class_2246.field_10398.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11034));
            chunk.method_66480(new class_2338(-1, -64, 2), (class_2680)class_2246.field_10398.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043));
        } else if (chunk.method_12004().field_9181 == 0 && chunk.method_12004().field_9180 == -1) {
            chunk.method_66480(new class_2338(0, -64, -2), (class_2680)class_2246.field_10398.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11035));
            chunk.method_66480(new class_2338(1, -64, -2), (class_2680)class_2246.field_10398.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11035));
            chunk.method_66480(new class_2338(2, -64, -1), (class_2680)class_2246.field_10398.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11039));
        } else if (chunk.method_12004().field_9181 == -1 && chunk.method_12004().field_9180 == -1) {
            chunk.method_66480(new class_2338(-2, -64, -1), (class_2680)class_2246.field_10398.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11034));
            chunk.method_66480(new class_2338(-1, -64, -2), (class_2680)class_2246.field_10398.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11035));
        }
        return CompletableFuture.completedFuture(chunk);
    }

    public class_4966 method_26261(int x, int z, class_5539 world, class_7138 noiseConfig) {
        class_5819 random = SkyGridChunkGenerator.getRandomForChunk(noiseConfig, x >> 4, z >> 4);
        this.blockProbabilities = this.blockProbabilities.withUniformRandomProvider((UniformRandomProvider)new MinecraftRandomAdapter(random));
        class_2680[] states = new class_2680[this.method_12104() / 4];
        for (int y = this.method_33730(); y < this.method_33730() + this.method_12104(); y += 4) {
            states[(y - this.method_33730()) / 4] = ((class_2248)this.blockProbabilities.sample()).method_9564();
        }
        return new class_4966(this.method_33730(), states);
    }
}

