/*
 * Decompiled with CFR 0.152.
 */
package net.spacerulerwill.skygrid_reloaded.ui.screen;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.spacerulerwill.skygrid_reloaded.Common;
import net.spacerulerwill.skygrid_reloaded.ui.screen.CustomizeBlocksScreen;
import net.spacerulerwill.skygrid_reloaded.ui.screen.CustomizeLootScreen;
import net.spacerulerwill.skygrid_reloaded.ui.screen.CustomizeSpawnerScreen;
import net.spacerulerwill.skygrid_reloaded.ui.screen.SelectBiomesScreen;
import net.spacerulerwill.skygrid_reloaded.ui.screen.SkyGridPresetsScreen;
import net.spacerulerwill.skygrid_reloaded.ui.widget.ClickableWidgetList;
import net.spacerulerwill.skygrid_reloaded.ui.widget.IntSlider;
import net.spacerulerwill.skygrid_reloaded.util.CheckerboardColumnBiomeSourceSizeAccessor;
import net.spacerulerwill.skygrid_reloaded.util.WorldPresetExtension;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridChunkGenerator;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridChunkGeneratorConfig;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridConfig;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridPreset;

public class CustomizeSkyGridScreen
extends Screen {
    public static final List<ResourceKey<LevelStem>> DIMENSIONS = List.of(LevelStem.OVERWORLD, LevelStem.NETHER, LevelStem.END);
    private static final Component TITLE_TEXT = Component.translatable((String)"createWorld.customize.skygrid.title");
    private static final Component BLOCKS_TEXT = Component.translatable((String)"createWorld.customize.skygrid.blocks");
    private static final Component BiOMES_TEXT = Component.translatable((String)"createWorld.customize.skygrid.biomes");
    private static final Component SPAWNERS_TEXT = Component.translatable((String)"createWorld.customize.skygrid.spawners");
    private static final Component LOOT_TEXT = Component.translatable((String)"createWorld.customize.skygrid.loot");
    private static final Component PRESETS_TEXT = Component.translatable((String)"createWorld.customize.skygrid.presets");
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private final CreateWorldScreen parent;
    private final IntSlider biomeScaleSlider;
    private ClickableWidgetList body;
    private CycleButton<ResourceKey<LevelStem>> dimensionsSelector;
    private SkyGridConfig currentConfig = new SkyGridConfig(Common.DEFAULT_PRESET.config());
    private ResourceKey<LevelStem> currentDimension = LevelStem.OVERWORLD;

    public CustomizeSkyGridScreen(CreateWorldScreen parent) {
        super(TITLE_TEXT);
        this.parent = parent;
        this.biomeScaleSlider = new IntSlider(0, 0, 100, 20, (Component)Component.translatable((String)"createWorld.customize.skygrid.biome_scale"), 0, 62, ((CheckerboardColumnBiomeSourceSizeAccessor)this.getCurrentConfig().checkerboardBiomeSource).skygrid_reloaded$getSize(), newValue -> {
            SkyGridChunkGeneratorConfig currentConfig = this.getCurrentConfig();
            currentConfig.checkerboardBiomeSource = new CheckerboardColumnBiomeSource((HolderSet)HolderSet.direct(currentConfig.checkerboardBiomeSource.possibleBiomes().stream().toList()), newValue.intValue());
        });
    }

    private SkyGridChunkGeneratorConfig getCurrentConfig() {
        SkyGridChunkGeneratorConfig config;
        if (this.currentDimension == LevelStem.OVERWORLD) {
            config = this.currentConfig.overworldConfig();
        } else if (this.currentDimension == LevelStem.NETHER) {
            config = this.currentConfig.netherConfig();
        } else if (this.currentDimension == LevelStem.END) {
            config = this.currentConfig.endConfig();
        } else {
            throw new IllegalStateException("Current dimension is not one of overworld, nether or end: " + this.currentDimension.location().toLanguageKey());
        }
        return config;
    }

    public void updateBiomeScaleSlider() {
        this.biomeScaleSlider.setValue(((CheckerboardColumnBiomeSourceSizeAccessor)this.getCurrentConfig().checkerboardBiomeSource).skygrid_reloaded$getSize());
    }

    protected void init() {
        this.layout.addTitleHeader(TITLE_TEXT, this.font);
        List<CycleButton> firstRow = List.of(new CycleButton.Builder(value -> Component.translatable((String)value.location().toLanguageKey())).withValues(DIMENSIONS).create(0, 0, 158, 20, (Component)Component.translatable((String)"createWorld.customize.skygrid.dimension"), (button, dimension) -> {
            this.currentDimension = dimension;
            this.updateBiomeScaleSlider();
        }));
        List<Button> secondRow = List.of(Button.builder((Component)BLOCKS_TEXT, button -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen((Screen)new CustomizeBlocksScreen(this, this.currentDimension, this.currentConfig));
            }
        }).build(), Button.builder((Component)SPAWNERS_TEXT, button -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen((Screen)new CustomizeSpawnerScreen(this, this.currentDimension, this.currentConfig));
            }
        }).build());
        List<IntSlider> thirdRow = List.of(Button.builder((Component)BiOMES_TEXT, button -> {
            if (this.minecraft != null) {
                Registry biomeRegistry = this.parent.getUiState().getSettings().worldgenLoadContext().lookupOrThrow(Registries.BIOME);
                this.minecraft.setScreen((Screen)new SelectBiomesScreen(this, (Registry<Biome>)biomeRegistry, this.currentDimension, this.currentConfig));
            }
        }).build(), this.biomeScaleSlider);
        List<Button> fourthRow = List.of(Button.builder((Component)LOOT_TEXT, button -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen((Screen)new CustomizeLootScreen(this, this.currentDimension, this.currentConfig));
            }
        }).build(), Button.builder((Component)PRESETS_TEXT, button -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen((Screen)new SkyGridPresetsScreen(this, this.parent.getUiState().getSettings().worldgenLoadContext()));
            }
        }).build());
        List<List<AbstractWidget>> rows = List.of(firstRow, secondRow, thirdRow, fourthRow);
        this.body = (ClickableWidgetList)this.layout.addToContents((LayoutElement)new ClickableWidgetList(this.minecraft, rows, this.width, this.layout.getContentHeight(), this.layout.getHeaderHeight()));
        LinearLayout footerRow = LinearLayout.horizontal().spacing(8);
        footerRow.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.done();
            this.onClose();
        }).build());
        footerRow.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).build());
        this.layout.addToFooter((LayoutElement)footerRow);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        if (this.body != null) {
            this.body.updateSize(this.width, this.layout);
        }
    }

    public void updateSkyGridConfig(SkyGridConfig config) {
        this.currentConfig = config;
    }

    public SkyGridConfig getCurrentSkyGridConfig() {
        return this.currentConfig;
    }

    private void done() {
        this.parent.getUiState().updateDimensions(this.applyChunkCGeneratorConfigs());
    }

    public void setConfigFromPreset(SkyGridPreset preset) {
        this.currentConfig = new SkyGridConfig(preset.config());
    }

    private WorldCreationContext.DimensionsUpdater applyChunkCGeneratorConfigs() {
        Map<ResourceKey, SkyGridChunkGeneratorConfig> dimensionOptionsToChunkGeneratorConfigMap = Map.of(LevelStem.OVERWORLD, this.currentConfig.overworldConfig(), LevelStem.NETHER, this.currentConfig.netherConfig(), LevelStem.END, this.currentConfig.endConfig());
        return (dynamicRegistryManager, dimensionsRegistryHolder) -> {
            Registry chunkGeneratorSettingsRegistry = dynamicRegistryManager.lookupOrThrow(Registries.NOISE_SETTINGS);
            HashMap updatedDimensions = new HashMap(dimensionsRegistryHolder.dimensions());
            dimensionOptionsToChunkGeneratorConfigMap.forEach((dimensionOptionsRegistryKey, config) -> {
                boolean hasNonZeroBlock = config.blocks.values().stream().anyMatch(weight -> weight > 0.0);
                if (hasNonZeroBlock) {
                    ResourceKey chunkGeneratorSettingsRegistryKey = null;
                    if (dimensionOptionsRegistryKey == LevelStem.OVERWORLD) {
                        chunkGeneratorSettingsRegistryKey = NoiseGeneratorSettings.OVERWORLD;
                    } else if (dimensionOptionsRegistryKey == LevelStem.NETHER) {
                        chunkGeneratorSettingsRegistryKey = NoiseGeneratorSettings.NETHER;
                    } else if (dimensionOptionsRegistryKey == LevelStem.END) {
                        chunkGeneratorSettingsRegistryKey = NoiseGeneratorSettings.END;
                    }
                    if (config.checkerboardBiomeSource.possibleBiomes().isEmpty()) {
                        Registry biomeRegistry = dynamicRegistryManager.lookupOrThrow(Registries.BIOME);
                        ResourceKey biomeKey = null;
                        if (dimensionOptionsRegistryKey == LevelStem.OVERWORLD) {
                            biomeKey = Biomes.PLAINS;
                        } else if (dimensionOptionsRegistryKey == LevelStem.NETHER) {
                            biomeKey = Biomes.NETHER_WASTES;
                        } else if (dimensionOptionsRegistryKey == LevelStem.END) {
                            biomeKey = Biomes.THE_END;
                        }
                        Holder biomeRegistryEntry = biomeRegistry.wrapAsHolder((Object)((Biome)biomeRegistry.getValue(biomeKey)));
                        config.checkerboardBiomeSource = new CheckerboardColumnBiomeSource((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomeRegistryEntry}), 1);
                    }
                    Holder chunkGeneratorSettingsRegistryEntry = chunkGeneratorSettingsRegistry.wrapAsHolder((Object)((NoiseGeneratorSettings)chunkGeneratorSettingsRegistry.getValue(chunkGeneratorSettingsRegistryKey)));
                    SkyGridChunkGenerator chunkGenerator = new SkyGridChunkGenerator((Holder<NoiseGeneratorSettings>)chunkGeneratorSettingsRegistryEntry, (SkyGridChunkGeneratorConfig)config);
                    LevelStem dimensionOptions = (LevelStem)this.parent.getUiState().getSettings().selectedDimensions().dimensions().get(dimensionOptionsRegistryKey);
                    Holder dimensionTypeRegistryEntry = dimensionOptions.type();
                    LevelStem newDimensionOptions = new LevelStem(dimensionTypeRegistryEntry, (ChunkGenerator)chunkGenerator);
                    updatedDimensions.put(dimensionOptionsRegistryKey, newDimensionOptions);
                } else if (dimensionOptionsRegistryKey == LevelStem.OVERWORLD) {
                    LevelStem defaultOverworld = (LevelStem)((WorldPreset)dynamicRegistryManager.lookupOrThrow(Registries.WORLD_PRESET).getValue(WorldPresets.NORMAL)).overworld().orElseThrow();
                    updatedDimensions.put(dimensionOptionsRegistryKey, defaultOverworld);
                } else if (dimensionOptionsRegistryKey == LevelStem.NETHER) {
                    WorldPreset preset = (WorldPreset)dynamicRegistryManager.lookupOrThrow(Registries.WORLD_PRESET).getValue(WorldPresets.NORMAL);
                    LevelStem defaultNether = ((WorldPresetExtension)preset).skygrid_reloaded$GetNether().orElseThrow();
                    updatedDimensions.put(dimensionOptionsRegistryKey, defaultNether);
                } else if (dimensionOptionsRegistryKey == LevelStem.END) {
                    WorldPreset preset = (WorldPreset)dynamicRegistryManager.lookupOrThrow(Registries.WORLD_PRESET).getValue(WorldPresets.NORMAL);
                    LevelStem defaultEnd = ((WorldPresetExtension)preset).skygrid_reloaded$GetEnd().orElseThrow();
                    updatedDimensions.put(dimensionOptionsRegistryKey, defaultEnd);
                }
            });
            return new WorldDimensions((Map)ImmutableMap.copyOf(updatedDimensions));
        };
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen((Screen)this.parent);
        }
    }
}

