/*
 * Decompiled with CFR 0.152.
 */
package net.spacerulerwill.skygrid_reloaded.ui.screen;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.dimension.LevelStem;
import net.spacerulerwill.skygrid_reloaded.ui.screen.CustomizeSkyGridScreen;
import net.spacerulerwill.skygrid_reloaded.ui.screen.DimensionSpecificCustomizableListWidgetScreen;
import net.spacerulerwill.skygrid_reloaded.util.CheckerboardColumnBiomeSourceSizeAccessor;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridChunkGeneratorConfig;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridConfig;

public class SelectBiomesScreen
extends DimensionSpecificCustomizableListWidgetScreen<BiomeListWidgetEntry, Holder<Biome>> {
    private final Registry<Biome> biomeRegistry;

    public SelectBiomesScreen(CustomizeSkyGridScreen parent, Registry<Biome> biomeRegistry, ResourceKey<LevelStem> initialDimension, SkyGridConfig currentConfig) {
        super(parent, initialDimension, currentConfig, (Component)Component.translatable((String)"createWorld.customize.skygrid.biomes"), (Component)Component.translatable((String)"createWorld.customize.skygrid.spawners.placeholder"), 15);
        this.biomeRegistry = biomeRegistry;
    }

    private SkyGridChunkGeneratorConfig getConfig() {
        SkyGridChunkGeneratorConfig config;
        if (this.currentDimension == LevelStem.OVERWORLD) {
            config = this.currentConfig.overworldConfig();
        } else if (this.currentDimension == LevelStem.NETHER) {
            config = this.currentConfig.netherConfig();
        } else if (this.currentDimension == LevelStem.END) {
            config = this.currentConfig.endConfig();
        } else {
            throw new IllegalStateException("Current dimension is not one of overworld, nether or end: " + this.currentDimension.location().toLanguageKey());
        }
        return config;
    }

    @Override
    protected void onClear() {
        SkyGridChunkGeneratorConfig currentConfig = this.getConfig();
        CheckerboardColumnBiomeSource currentBiomeSouurce = currentConfig.checkerboardBiomeSource;
        this.getConfig().checkerboardBiomeSource = new CheckerboardColumnBiomeSource((HolderSet)HolderSet.direct((Holder[])new Holder[0]), ((CheckerboardColumnBiomeSourceSizeAccessor)currentBiomeSouurce).skygrid_reloaded$getSize());
    }

    @Override
    protected Optional<Holder<Biome>> getThingFromString(String text) {
        try {
            return this.biomeRegistry.getOptional(ResourceLocation.parse((String)text)).map(arg_0 -> this.biomeRegistry.wrapAsHolder(arg_0));
        }
        catch (ResourceLocationException e) {
            return Optional.empty();
        }
    }

    @Override
    protected List<DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry> getAutocompleteSuggestions(String text) {
        ArrayList<DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry> results = new ArrayList<DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry>();
        if (text.isBlank()) {
            return results;
        }
        this.biomeRegistry.forEach(biome -> {
            String key = ((ResourceKey)this.biomeRegistry.getResourceKey(biome).get()).location().toLanguageKey("biome");
            String displayString = Component.translatable((String)key).getString();
            String valueString = this.biomeRegistry.wrapAsHolder(biome).getRegisteredName();
            if (displayString.trim().toLowerCase().startsWith(text) || valueString.startsWith(text)) {
                results.add(new DimensionSpecificCustomizableListWidgetScreen.AutocompleteListWidget.Entry(null, displayString, valueString, this.font));
            }
        });
        return results;
    }

    @Override
    protected void onAdd(Holder<Biome> thing) {
        SkyGridChunkGeneratorConfig config = this.getConfig();
        if (config.checkerboardBiomeSource.possibleBiomes().contains(thing)) {
            throw new IllegalStateException("Add button called while item to add is already present");
        }
        CheckerboardColumnBiomeSource currentBiomeSource = config.checkerboardBiomeSource;
        LinkedHashSet<Holder<Biome>> biomes = new LinkedHashSet<Holder<Biome>>(currentBiomeSource.possibleBiomes());
        biomes.add(thing);
        config.checkerboardBiomeSource = new CheckerboardColumnBiomeSource((HolderSet)HolderSet.direct(biomes.stream().toList()), ((CheckerboardColumnBiomeSourceSizeAccessor)currentBiomeSource).skygrid_reloaded$getSize());
        this.listWidget.addEntry(new BiomeListWidgetEntry(thing));
    }

    @Override
    protected boolean canAdd(Holder<Biome> thing) {
        return !this.getConfig().checkerboardBiomeSource.possibleBiomes().contains(thing);
    }

    @Override
    protected void onDelete(BiomeListWidgetEntry entry) {
        SkyGridChunkGeneratorConfig currentConfig = this.getConfig();
        CheckerboardColumnBiomeSource currentBiomeSource = currentConfig.checkerboardBiomeSource;
        LinkedHashSet biomes = new LinkedHashSet(currentBiomeSource.possibleBiomes());
        biomes.remove(entry.biome);
        this.getConfig().checkerboardBiomeSource = new CheckerboardColumnBiomeSource((HolderSet)HolderSet.direct(biomes.stream().toList()), ((CheckerboardColumnBiomeSourceSizeAccessor)currentBiomeSource).skygrid_reloaded$getSize());
    }

    @Override
    protected List<BiomeListWidgetEntry> getEntriesFromConfig() {
        ArrayList<BiomeListWidgetEntry> entries = new ArrayList<BiomeListWidgetEntry>();
        Set biomes = this.getConfig().checkerboardBiomeSource.possibleBiomes();
        for (Holder biome : biomes) {
            entries.add(new BiomeListWidgetEntry((Holder<Biome>)biome));
        }
        return entries;
    }

    protected class BiomeListWidgetEntry
    extends ObjectSelectionList.Entry<BiomeListWidgetEntry> {
        private final Holder<Biome> biome;

        public BiomeListWidgetEntry(Holder<Biome> biome) {
            this.biome = biome;
        }

        public Component getNarration() {
            return Component.empty();
        }

        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            String key = ((ResourceKey)this.biome.unwrapKey().get()).location().toLanguageKey("biome");
            context.drawString(SelectBiomesScreen.this.font, (Component)Component.translatable((String)key), x + 3, y + 2, 0xFFFFFF, false);
        }
    }
}

