/*
 * Decompiled with CFR 0.152.
 */
package net.spacerulerwill.skygrid_reloaded.ui.widget;

import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class IntSlider
extends AbstractSliderButton {
    private final int minValue;
    private final int maxValue;
    private final Component text;
    private final Consumer<Integer> onValueChanged;

    public IntSlider(int x, int y, int width, int height, Component text, int minValue, int maxValue, int initialValue, Consumer<Integer> onValueChanged) {
        super(x, y, width, height, (Component)Component.empty(), 0.0);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.text = text;
        this.onValueChanged = onValueChanged;
        this.value = (double)(initialValue - minValue) / (double)(maxValue - minValue);
        this.updateMessage();
    }

    public void setValue(int value) {
        if (value < this.minValue || value > this.maxValue) {
            throw new IllegalArgumentException("Value " + value + " is out of range [" + this.minValue + ", " + this.maxValue + "]");
        }
        this.value = (double)(value - this.minValue) / (double)(this.maxValue - this.minValue);
        this.onValueChanged.accept(value);
        this.updateMessage();
    }

    protected void updateMessage() {
        this.setMessage((Component)this.createMessage());
    }

    private MutableComponent createMessage() {
        int currentValue = this.getIntValue();
        return this.text.copy().append((Component)Component.literal((String)": ")).append((Component)Component.literal((String)String.valueOf(currentValue)));
    }

    private int getIntValue() {
        return (int)Math.round(this.value * (double)(this.maxValue - this.minValue) + (double)this.minValue);
    }

    protected void applyValue() {
        int newValue = this.getIntValue();
        this.onValueChanged.accept(newValue);
        this.updateMessage();
    }
}

