/*
 * Decompiled with CFR 0.152.
 */
package net.spacerulerwill.skygrid_reloaded.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.spacerulerwill.skygrid_reloaded.util.MinecraftRandomAdapter;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridChunkGeneratorConfig;
import org.apache.commons.rng.sampling.DiscreteProbabilityCollectionSampler;

public class SkyGridChunkGenerator
extends ChunkGenerator {
    public static final MapCodec<SkyGridChunkGenerator> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NoiseGeneratorSettings.CODEC.fieldOf("settings").forGetter(generator -> generator.settings), (App)SkyGridChunkGeneratorConfig.CODEC.fieldOf("skygrid_settings").forGetter(SkyGridChunkGenerator::getConfig)).apply((Applicative)instance, SkyGridChunkGenerator::new));
    public static final int MAX_BOOK_ENCHANTS = 5;
    public static final List<ResourceKey<LootTable>> ARCHEOLOGY_LOOT_TABLES = Arrays.asList(BuiltInLootTables.DESERT_PYRAMID_ARCHAEOLOGY, BuiltInLootTables.DESERT_WELL_ARCHAEOLOGY, BuiltInLootTables.OCEAN_RUIN_COLD_ARCHAEOLOGY, BuiltInLootTables.OCEAN_RUIN_WARM_ARCHAEOLOGY, BuiltInLootTables.TRAIL_RUINS_ARCHAEOLOGY_COMMON, BuiltInLootTables.TRAIL_RUINS_ARCHAEOLOGY_RARE);
    private final SkyGridChunkGeneratorConfig config;
    private final List<EntityType<?>> entities;
    private final Holder<NoiseGeneratorSettings> settings;
    private DiscreteProbabilityCollectionSampler<Block> blockProbabilities;
    private DiscreteProbabilityCollectionSampler<Item> chestItemProbabilities;

    public SkyGridChunkGenerator(Holder<NoiseGeneratorSettings> settings, SkyGridChunkGeneratorConfig config) {
        super((BiomeSource)config.checkerboardBiomeSource);
        this.settings = settings;
        this.config = config;
        this.blockProbabilities = new DiscreteProbabilityCollectionSampler<Block>(new MinecraftRandomAdapter(), config.blocks);
        this.chestItemProbabilities = config.chestItems.isEmpty() ? null : new DiscreteProbabilityCollectionSampler<Item>(new MinecraftRandomAdapter(), config.chestItems);
        this.entities = config.spawnerEntities.stream().toList();
    }

    private static RandomSource getRandomForChunk(RandomState noiseConfig, int x, int z) {
        return noiseConfig.oreRandom().fromSeed(0x60000005L * (long)x + 805306457L * (long)z + 402653189L ^ 0xC000013L);
    }

    private static void addRandomEnchantmentToItemStack(ItemStack itemStack, RandomSource random, Registry<Enchantment> enchantmentRegistry) {
        Holder enchantmentRegistryEntry = (Holder)enchantmentRegistry.getRandom(random).get();
        int level = random.nextIntBetweenInclusive(1, ((Enchantment)enchantmentRegistryEntry.value()).getMaxLevel());
        itemStack.enchant(enchantmentRegistryEntry, level);
    }

    protected MapCodec<? extends ChunkGenerator> codec() {
        return MAP_CODEC;
    }

    public void applyCarvers(WorldGenRegion chunkRegion, long seed, RandomState noiseConfig, BiomeManager biomeAccess, StructureManager structureAccessor, ChunkAccess chunk) {
    }

    public SkyGridChunkGeneratorConfig getConfig() {
        return this.config;
    }

    public void applyBiomeDecoration(WorldGenLevel world, ChunkAccess chunk, StructureManager structureAccessor) {
    }

    public void buildSurface(WorldGenRegion region, StructureManager structures, RandomState noiseConfig, ChunkAccess chunk) {
    }

    public void spawnOriginalMobs(WorldGenRegion region) {
    }

    public void addDebugScreenInfo(List<String> text, RandomState noiseConfig, BlockPos pos) {
    }

    public int getBaseHeight(int x, int z, Heightmap.Types heightmap, LevelHeightAccessor world, RandomState noiseConfig) {
        return 0;
    }

    public int getGenDepth() {
        return ((NoiseGeneratorSettings)this.settings.value()).noiseSettings().height();
    }

    public int getSeaLevel() {
        return 0;
    }

    public int getMinY() {
        return ((NoiseGeneratorSettings)this.settings.value()).noiseSettings().minY();
    }

    private void fillChestBlockEntityWithItems(RandomizableContainerBlockEntity blockEntity, RandomSource random, RegistryAccess dynamicRegistryManager) {
        if (this.chestItemProbabilities != null) {
            int numItems = Math.clamp((long)random.nextIntBetweenInclusive(2, 5), 0, blockEntity.getContainerSize());
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int i = 0; i < blockEntity.getContainerSize(); ++i) {
                slots.add(i);
            }
            Collections.shuffle(slots);
            int nextSlotIdx = 0;
            for (int i = 0; i < numItems; ++i) {
                Item item = this.chestItemProbabilities.sample();
                ItemStack itemStack = item.getDefaultInstance();
                if (item instanceof PotionItem || item.equals(Items.TIPPED_ARROW) || item.equals(Items.SUSPICIOUS_STEW)) {
                    itemStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents((Holder)BuiltInRegistries.POTION.getRandom(random).get()));
                } else if (item.equals(Items.GOAT_HORN)) {
                    Registry instrumentRegistry = dynamicRegistryManager.lookupOrThrow(Registries.INSTRUMENT);
                    itemStack.set(DataComponents.INSTRUMENT, (Object)((Holder.Reference)instrumentRegistry.getRandom(random).get()));
                } else if (item.equals(Items.ENCHANTED_BOOK)) {
                    Registry enchantmentRegistry = dynamicRegistryManager.lookupOrThrow(Registries.ENCHANTMENT);
                    float chance = 1.0f;
                    for (int j = 0; j < 5; ++j) {
                        if (random.nextFloat() < chance) {
                            SkyGridChunkGenerator.addRandomEnchantmentToItemStack(itemStack, random, (Registry<Enchantment>)enchantmentRegistry);
                        }
                        chance *= 0.66f;
                    }
                }
                int slotIdx = (Integer)slots.get(nextSlotIdx);
                ++nextSlotIdx;
                blockEntity.setItem(slotIdx, itemStack);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public CompletableFuture<ChunkAccess> fillFromNoise(Blender blender, RandomState noiseConfig, StructureManager structureAccessor, ChunkAccess chunk) {
        dynamicRegistryManager = structureAccessor.registryAccess();
        random = SkyGridChunkGenerator.getRandomForChunk(noiseConfig, chunk.getPos().x, chunk.getPos().z);
        uniformRandomProvider = new MinecraftRandomAdapter(random);
        this.blockProbabilities = this.blockProbabilities.withUniformRandomProvider(uniformRandomProvider);
        if (this.chestItemProbabilities != null) {
            this.chestItemProbabilities = this.chestItemProbabilities.withUniformRandomProvider(uniformRandomProvider);
        }
        for (x = 0; x < 16; x += 4) {
            for (z = 0; z < 16; z += 4) {
                worldX = chunk.getPos().x * 16 + x;
                worldZ = chunk.getPos().z * 16 + z;
                for (y = this.getMinY(); y < this.getMinY() + this.getGenDepth(); y += 4) {
                    block15: {
                        block14: {
                            blockPos = new BlockPos(x, y, z);
                            block = this.blockProbabilities.sample();
                            state = (BlockState)block.defaultBlockState().trySetValue((Property)BlockStateProperties.PERSISTENT, (Comparable)Boolean.valueOf(true));
                            chunk.setBlockState(blockPos, state, false);
                            if (!(block instanceof EntityBlock)) continue;
                            provider = (EntityBlock)block;
                            blockEntityPos = new BlockPos(worldX, y, worldZ);
                            blockEntity = provider.newBlockEntity(blockEntityPos, state);
                            if (!(blockEntity instanceof RandomizableContainerBlockEntity)) break block14;
                            lootableContainerBlockEntity = (RandomizableContainerBlockEntity)blockEntity;
                            this.fillChestBlockEntityWithItems(lootableContainerBlockEntity, random, dynamicRegistryManager);
                            break block15;
                        }
                        if (!(blockEntity instanceof SpawnerBlockEntity)) ** GOTO lbl-1000
                        mobSpawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
                        if (!this.entities.isEmpty()) {
                            mobSpawnerBlockEntity.setEntityId(this.entities.get(random.nextInt(this.config.spawnerEntities.size())), random);
                        } else if (blockEntity instanceof BrushableBlockEntity) {
                            brushableBlockEntity = (BrushableBlockEntity)blockEntity;
                            lootTableIndex = random.nextIntBetweenInclusive(0, SkyGridChunkGenerator.ARCHEOLOGY_LOOT_TABLES.size() - 1);
                            brushableBlockEntity.setLootTable(SkyGridChunkGenerator.ARCHEOLOGY_LOOT_TABLES.get(lootTableIndex), (long)random.nextInt());
                        }
                    }
                    chunk.setBlockEntity(blockEntity);
                }
            }
        }
        if (chunk.getPos().x == 0 && chunk.getPos().z == 0) {
            chunk.setBlockState(new BlockPos(0, -64, 0), Blocks.AIR.defaultBlockState(), false);
            chunk.setBlockState(new BlockPos(2, -64, 0), (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST), false);
            chunk.setBlockState(new BlockPos(0, -64, 2), (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH), false);
            chunk.setBlockState(new BlockPos(2, -64, 1), (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST), false);
            chunk.setBlockState(new BlockPos(1, -64, 2), (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH), false);
        } else if (chunk.getPos().x == -1 && chunk.getPos().z == 0) {
            chunk.setBlockState(new BlockPos(-2, -64, 0), (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST), false);
            chunk.setBlockState(new BlockPos(-2, -64, 1), (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST), false);
            chunk.setBlockState(new BlockPos(-1, -64, 2), (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH), false);
        } else if (chunk.getPos().x == 0 && chunk.getPos().z == -1) {
            chunk.setBlockState(new BlockPos(0, -64, -2), (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH), false);
            chunk.setBlockState(new BlockPos(1, -64, -2), (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH), false);
            chunk.setBlockState(new BlockPos(2, -64, -1), (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST), false);
        } else if (chunk.getPos().x == -1 && chunk.getPos().z == -1) {
            chunk.setBlockState(new BlockPos(-2, -64, -1), (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST), false);
            chunk.setBlockState(new BlockPos(-1, -64, -2), (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH), false);
        }
        return CompletableFuture.completedFuture(chunk);
    }

    public NoiseColumn getBaseColumn(int x, int z, LevelHeightAccessor world, RandomState noiseConfig) {
        RandomSource random = SkyGridChunkGenerator.getRandomForChunk(noiseConfig, x >> 4, z >> 4);
        this.blockProbabilities = this.blockProbabilities.withUniformRandomProvider(new MinecraftRandomAdapter(random));
        BlockState[] states = new BlockState[this.getGenDepth() / 4];
        for (int y = this.getMinY(); y < this.getMinY() + this.getGenDepth(); y += 4) {
            states[(y - this.getMinY()) / 4] = this.blockProbabilities.sample().defaultBlockState();
        }
        return new NoiseColumn(this.getMinY(), states);
    }
}

