/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity;

import com.infinite_craft.libs.autovalue.shaded.com.google.common.base.Verify;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableList;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableSet;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.EvaluationContext;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.EvaluationException;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.ExpressionNode;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.Node;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class Macro {
    private final int definitionLineNumber;
    private final String name;
    private final ImmutableList<String> parameterNames;
    private final Node macroBody;

    Macro(int definitionLineNumber, String name, List<String> parameterNames, Node macroBody) {
        this.definitionLineNumber = definitionLineNumber;
        this.name = name;
        this.parameterNames = ImmutableList.copyOf(parameterNames);
        this.macroBody = macroBody;
    }

    int parameterCount() {
        return this.parameterNames.size();
    }

    void render(EvaluationContext context, List<ExpressionNode> thunks, Node bodyContent, StringBuilder output) {
        try {
            Verify.verify(thunks.size() == this.parameterNames.size(), "Argument mismatch for %s", (Object)this.name);
            LinkedHashMap<String, ExpressionNode> parameterThunks = new LinkedHashMap<String, ExpressionNode>();
            for (int i = 0; i < this.parameterNames.size(); ++i) {
                parameterThunks.put((String)this.parameterNames.get(i), thunks.get(i));
            }
            MacroEvaluationContext newContext = new MacroEvaluationContext(parameterThunks, context, bodyContent);
            this.macroBody.render(newContext, output);
        }
        catch (EvaluationException e) {
            EvaluationException newException = new EvaluationException("In macro #" + this.name + " defined on line " + this.definitionLineNumber + ": " + e.getMessage());
            newException.setStackTrace(e.getStackTrace());
            throw newException;
        }
    }

    static class MacroEvaluationContext
    implements EvaluationContext {
        private final Map<String, ExpressionNode> parameterThunks;
        private final EvaluationContext originalEvaluationContext;
        private final Node bodyContent;

        MacroEvaluationContext(Map<String, ExpressionNode> parameterThunks, EvaluationContext originalEvaluationContext, Node bodyContent) {
            this.parameterThunks = parameterThunks;
            this.originalEvaluationContext = originalEvaluationContext;
            this.bodyContent = bodyContent;
        }

        @Override
        public Object getVar(String var) {
            if (this.bodyContent != null && var.equals("bodyContent")) {
                return this.bodyContent;
            }
            ExpressionNode thunk = this.parameterThunks.get(var);
            if (thunk == null) {
                return this.originalEvaluationContext.getVar(var);
            }
            return thunk.evaluate(this.originalEvaluationContext);
        }

        @Override
        public boolean varIsDefined(String var) {
            return this.parameterThunks.containsKey(var) || this.bodyContent != null && var.equals("bodyContent") || this.originalEvaluationContext.varIsDefined(var);
        }

        @Override
        public Runnable setVar(String var, Object value) {
            ExpressionNode thunk = this.parameterThunks.get(var);
            if (thunk == null) {
                return this.originalEvaluationContext.setVar(var, value);
            }
            this.parameterThunks.remove(var);
            Runnable originalUndo = this.originalEvaluationContext.setVar(var, value);
            return () -> {
                originalUndo.run();
                this.parameterThunks.put(var, thunk);
            };
        }

        @Override
        public ImmutableSet<Method> publicMethodsWithName(Class<?> startClass, String name) {
            return this.originalEvaluationContext.publicMethodsWithName(startClass, name);
        }

        @Override
        public Map<String, Macro> getMacros() {
            return this.originalEvaluationContext.getMacros();
        }
    }
}

