/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity;

import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.HashBasedTable;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableSet;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.Table;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.reflect.Reflection;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.Node;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

class MethodFinder {
    private final Table<Class<?>, String, ImmutableSet<Method>> methodCache = HashBasedTable.create();
    private static final String THIS_PACKAGE;
    private static final Method CLASS_GET_MODULE_METHOD;
    private static final Method MODULE_IS_EXPORTED_METHOD;

    MethodFinder() {
    }

    synchronized ImmutableSet<Method> publicMethodsWithName(Class<?> startClass, String name) {
        ImmutableSet<Method> cachedMethods = this.methodCache.get(startClass, name);
        if (cachedMethods == null) {
            cachedMethods = this.uncachedPublicMethodsWithName(startClass, name);
            this.methodCache.put(startClass, name, cachedMethods);
        }
        return cachedMethods;
    }

    private ImmutableSet<Method> uncachedPublicMethodsWithName(Class<?> startClass, String name) {
        Set methods = Arrays.stream(startClass.getMethods()).filter(m4 -> m4.getName().equals(name)).collect(Collectors.toSet());
        if (!MethodFinder.classIsPublic(startClass)) {
            methods = methods.stream().map(m4 -> MethodFinder.visibleMethod(m4, startClass)).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return ImmutableSet.copyOf(methods);
    }

    static Method visibleMethod(Method method, Class<?> in) {
        Method methodInClass;
        if (in == null) {
            return null;
        }
        try {
            methodInClass = in.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (MethodFinder.classIsPublic(in) || in.getName().startsWith(THIS_PACKAGE)) {
            return methodInClass;
        }
        Method methodInSuperclass = MethodFinder.visibleMethod(method, in.getSuperclass());
        if (methodInSuperclass != null) {
            return methodInSuperclass;
        }
        for (Class<?> superinterface : in.getInterfaces()) {
            Method methodInSuperinterface = MethodFinder.visibleMethod(method, superinterface);
            if (methodInSuperinterface == null) continue;
            return methodInSuperinterface;
        }
        return null;
    }

    private static boolean classIsPublic(Class<?> c) {
        return Modifier.isPublic(c.getModifiers()) && MethodFinder.classIsExported(c);
    }

    private static boolean classIsExported(Class<?> c) {
        if (CLASS_GET_MODULE_METHOD == null) {
            return true;
        }
        try {
            String pkg = Reflection.getPackageName(c);
            Object module = CLASS_GET_MODULE_METHOD.invoke(c, new Object[0]);
            return (Boolean)MODULE_IS_EXPORTED_METHOD.invoke(module, pkg);
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        Method moduleIsExportedMethod;
        Method classGetModuleMethod;
        THIS_PACKAGE = Reflection.getPackageName(Node.class) + ".";
        try {
            classGetModuleMethod = Class.class.getMethod("getModule", new Class[0]);
            Class<?> moduleClass = classGetModuleMethod.getReturnType();
            moduleIsExportedMethod = moduleClass.getMethod("isExported", String.class);
        }
        catch (Exception e) {
            classGetModuleMethod = null;
            moduleIsExportedMethod = null;
        }
        CLASS_GET_MODULE_METHOD = classGetModuleMethod;
        MODULE_IS_EXPORTED_METHOD = moduleIsExportedMethod;
    }
}

