/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity;

import com.infinite_craft.libs.autovalue.shaded.com.google.common.base.CharMatcher;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.base.Joiner;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.base.Verify;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ContiguousSet;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ForwardingSortedSet;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableCollection;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableList;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableListMultimap;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableMap;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableSet;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableSortedSet;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.Iterables;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.primitives.Chars;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.primitives.Ints;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.ConstantExpressionNode;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.DirectiveNode;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.EvaluationContext;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.ExpressionNode;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.Macro;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.Node;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.ParseException;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.ParseNode;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.ReferenceNode;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.SetSpacing;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.StopNode;
import com.infinite_craft.libs.autovalue.shaded.com.google.escapevelocity.Template;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.function.Supplier;

class Parser {
    private static final int EOF = -1;
    private static final ImmutableSet<Class<? extends StopNode>> EOF_CLASS = ImmutableSet.of(StopNode.EofNode.class);
    private static final ImmutableSet<Class<? extends StopNode>> END_CLASS = ImmutableSet.of(StopNode.EndNode.class);
    private static final ImmutableSet<Class<? extends StopNode>> ELSE_ELSEIF_END_CLASSES = ImmutableSet.of(StopNode.ElseNode.class, StopNode.ElseIfNode.class, StopNode.EndNode.class);
    private final LineNumberReader reader;
    private final String resourceName;
    private final Template.ResourceOpener resourceOpener;
    private final Map<String, Template> parseCache;
    private final Map<String, Macro> macros = new TreeMap<String, Macro>();
    private int c;
    private int pushback = -1;
    private static final ImmutableSet<String> UNSUPPORTED_VELOCITY_DIRECTIVES = ImmutableSet.of("stop");
    private static final ImmutableListMultimap<Integer, Operator> CODE_POINT_TO_OPERATORS;
    private static final CharMatcher ASCII_LETTER;
    private static final CharMatcher ASCII_DIGIT;
    private static final CharMatcher ID_CHAR;

    Parser(Reader reader, String resourceName, Template.ResourceOpener resourceOpener, Map<String, Template> parseCache) throws IOException {
        this.reader = new LineNumberReader(reader);
        this.reader.setLineNumber(1);
        this.next();
        this.resourceName = resourceName;
        this.resourceOpener = resourceOpener;
        this.parseCache = parseCache;
    }

    Template parse() throws IOException {
        ParseResult parseResult = this.parseToStop(EOF_CLASS, () -> "outside any construct");
        Node root = Node.cons(this.resourceName, this.lineNumber(), parseResult.nodes);
        return new Template(root, ImmutableMap.copyOf(this.macros));
    }

    private int lineNumber() {
        return this.reader.getLineNumber();
    }

    private void next() throws IOException {
        if (this.c != -1) {
            if (this.pushback < 0) {
                this.c = this.reader.read();
            } else {
                this.c = this.pushback;
                this.pushback = -1;
            }
        }
    }

    private void pushback(int c1) {
        this.pushback = this.c;
        this.c = c1;
    }

    private void skipSpace() throws IOException {
        while (Character.isWhitespace(this.c)) {
            this.next();
        }
    }

    private void nextNonSpace() throws IOException {
        this.next();
        this.skipSpace();
    }

    private void expect(char expected) throws IOException {
        this.skipSpace();
        if (this.c != expected) {
            throw this.parseException("Expected " + expected);
        }
        this.next();
    }

    private ParseResult parseToStop(ImmutableSet<Class<? extends StopNode>> stopClasses, Supplier<String> contextDescription) throws IOException {
        Node node;
        ArrayList<Node> nodes = new ArrayList<Node>();
        while (!((node = this.parseNode()) instanceof StopNode)) {
            if (node instanceof DirectiveNode.SetNode && SetSpacing.shouldRemoveLastNodeBeforeSet(nodes)) {
                nodes.set(nodes.size() - 1, node);
                continue;
            }
            nodes.add(node);
        }
        StopNode stop = (StopNode)node;
        if (!stopClasses.contains(stop.getClass())) {
            throw this.parseException("Found " + stop.name() + " " + contextDescription.get());
        }
        return new ParseResult(ImmutableList.copyOf(nodes), stop);
    }

    private ParseResult skipNewlineAndParseToStop(ImmutableSet<Class<? extends StopNode>> stopClasses, Supplier<String> contextDescription) throws IOException {
        if (this.c == 10) {
            this.next();
        }
        return this.parseToStop(stopClasses, contextDescription);
    }

    private Node parseNode() throws IOException {
        if (this.c == 35) {
            this.next();
            switch (this.c) {
                case 35: {
                    return this.parseLineComment();
                }
                case 42: {
                    return this.parseBlockComment();
                }
                case 91: {
                    return this.parseHashSquare();
                }
                case 123: {
                    return this.parseDirective();
                }
                case 64: {
                    return this.parseMacroCallWithBody();
                }
            }
            if (Parser.isAsciiLetter(this.c)) {
                return this.parseDirective();
            }
            return this.parsePlainText(35);
        }
        if (this.c == -1) {
            return new StopNode.EofNode(this.resourceName, this.lineNumber());
        }
        return this.parseNonDirective();
    }

    private Node parseHashSquare() throws IOException {
        assert (this.c == 91);
        this.next();
        if (this.c != 91) {
            return this.parsePlainText(new StringBuilder("#["));
        }
        int startLine = this.lineNumber();
        this.next();
        StringBuilder sb = new StringBuilder();
        while (true) {
            int len;
            if (this.c == -1) {
                throw new ParseException("Unterminated #[[ - did not see matching ]]#", this.resourceName, startLine);
            }
            if (this.c == 35 && (len = sb.length()) > 1 && sb.charAt(len - 1) == ']' && sb.charAt(len - 2) == ']') break;
            sb.append((char)this.c);
            this.next();
        }
        this.next();
        String quoted = sb.substring(0, sb.length() - 2);
        return new ConstantExpressionNode(this.resourceName, this.lineNumber(), quoted);
    }

    private Node parseNonDirective() throws IOException {
        if (this.c == 36) {
            return this.parseDollar();
        }
        int firstChar = this.c;
        this.next();
        return this.parsePlainText(firstChar);
    }

    private Node parseDollar() throws IOException {
        boolean silent;
        assert (this.c == 36);
        this.next();
        boolean bl = silent = this.c == 33;
        if (silent) {
            this.next();
        }
        if (Parser.isAsciiLetter(this.c) || this.c == 123) {
            return this.parseReference(silent);
        }
        if (silent) {
            return this.parsePlainText("$!");
        }
        return this.parsePlainText(36);
    }

    private Node parseDirective() throws IOException {
        Node node;
        String directive;
        if (this.c == 123) {
            this.next();
            directive = this.parseId("Directive inside #{...}");
            this.expect('}');
        } else {
            directive = this.parseId("Directive");
        }
        switch (directive) {
            case "end": {
                node = new StopNode.EndNode(this.resourceName, this.lineNumber());
                break;
            }
            case "if": {
                return this.parseIfOrElseIf("#if");
            }
            case "elseif": {
                node = new StopNode.ElseIfNode(this.resourceName, this.lineNumber());
                break;
            }
            case "else": {
                node = new StopNode.ElseNode(this.resourceName, this.lineNumber());
                break;
            }
            case "foreach": {
                return this.parseForEach();
            }
            case "break": {
                return this.parseBreak();
            }
            case "set": {
                node = this.parseSet();
                break;
            }
            case "define": {
                node = this.parseDefine();
                break;
            }
            case "parse": {
                node = this.parseParse();
                break;
            }
            case "macro": {
                return this.parseMacroDefinition();
            }
            case "evaluate": {
                return this.parseEvaluate();
            }
            default: {
                node = this.parseMacroCall("#", directive);
            }
        }
        if (this.c == 10) {
            this.next();
        }
        return node;
    }

    private Node parseIfOrElseIf(String directive) throws IOException {
        Node falsePart;
        int startLine = this.lineNumber();
        this.expect('(');
        ExpressionNode condition = this.parseExpression();
        this.expect(')');
        ParseResult parsedTruePart = this.skipNewlineAndParseToStop(ELSE_ELSEIF_END_CLASSES, () -> "parsing " + directive + " starting on line " + startLine);
        Node truePart = Node.cons(this.resourceName, startLine, parsedTruePart.nodes);
        if (parsedTruePart.stop instanceof StopNode.EndNode) {
            falsePart = Node.emptyNode(this.resourceName, this.lineNumber());
        } else if (parsedTruePart.stop instanceof StopNode.ElseIfNode) {
            falsePart = this.parseIfOrElseIf("#elseif");
        } else {
            int elseLine = this.lineNumber();
            ParseResult parsedFalsePart = this.parseToStop(END_CLASS, () -> "parsing #else starting on line " + elseLine);
            falsePart = Node.cons(this.resourceName, elseLine, parsedFalsePart.nodes);
        }
        return new DirectiveNode.IfNode(this.resourceName, startLine, condition, truePart, falsePart);
    }

    private Node parseForEach() throws IOException {
        int startLine = this.lineNumber();
        this.expect('(');
        this.skipSpace();
        if (this.c != 36) {
            throw this.parseException("Expected variable beginning with '$' for #foreach");
        }
        Node varNode = this.parseDollar();
        if (!(varNode instanceof ReferenceNode.PlainReferenceNode)) {
            throw this.parseException("Expected simple variable for #foreach");
        }
        String var = ((ReferenceNode.PlainReferenceNode)varNode).id;
        this.skipSpace();
        boolean bad = false;
        if (this.c != 105) {
            bad = true;
        } else {
            this.next();
            if (this.c != 110) {
                bad = true;
            }
        }
        if (bad) {
            throw this.parseException("Expected 'in' for #foreach");
        }
        this.next();
        ExpressionNode collection = this.parseExpression();
        this.expect(')');
        ParseResult parsedBody = this.skipNewlineAndParseToStop(END_CLASS, () -> "parsing #foreach starting on line " + startLine);
        Node body = Node.cons(this.resourceName, startLine, parsedBody.nodes);
        return new DirectiveNode.ForEachNode(this.resourceName, startLine, var, collection, body);
    }

    private Node parseBreak() throws IOException {
        this.skipSpace();
        ExpressionNode scope = null;
        if (this.c == 40) {
            this.next();
            scope = this.parsePrimary();
            this.expect(')');
        }
        return new DirectiveNode.BreakNode(this.resourceName, this.lineNumber(), scope);
    }

    private Node parseSet() throws IOException {
        this.expect('(');
        this.expect('$');
        String var = this.parseId("#set variable");
        this.expect('=');
        ExpressionNode expression = this.parseExpression();
        this.expect(')');
        return new DirectiveNode.SetNode(var, expression);
    }

    private Node parseDefine() throws IOException {
        int startLine = this.lineNumber();
        this.expect('(');
        this.expect('$');
        String var = this.parseId("#define variable");
        this.expect(')');
        ParseResult parseResult = this.skipNewlineAndParseToStop(END_CLASS, () -> "parsing #define starting on line " + startLine);
        return new DirectiveNode.DefineNode(var, Node.cons(this.resourceName, startLine, parseResult.nodes));
    }

    private Node parseParse() throws IOException {
        int startLine = this.lineNumber();
        this.expect('(');
        ExpressionNode nestedResourceNameExpression = this.parsePrimary();
        this.skipSpace();
        this.expect(')');
        return new ParseNode(this.resourceName, startLine, nestedResourceNameExpression, this.resourceOpener, this.parseCache);
    }

    private Node parseMacroDefinition() throws IOException {
        int startLine = this.lineNumber();
        this.expect('(');
        this.skipSpace();
        String name = this.parseId("Macro name");
        ImmutableList.Builder parameterNames = ImmutableList.builder();
        while (true) {
            this.skipSpace();
            if (this.c == 41) break;
            if (this.c == 44) {
                this.next();
                this.skipSpace();
            }
            if (this.c != 36) {
                throw this.parseException("Macro parameters should look like $name");
            }
            this.next();
            parameterNames.add(this.parseId("Macro parameter name"));
        }
        this.next();
        ParseResult parsedBody = this.skipNewlineAndParseToStop(END_CLASS, () -> "parsing #macro starting on line " + startLine);
        if (!this.macros.containsKey(name)) {
            ImmutableList<Node> bodyNodes = ImmutableList.copyOf(SetSpacing.removeInitialSpaceBeforeSet(parsedBody.nodes));
            Node body = Node.cons(this.resourceName, startLine, bodyNodes);
            Macro macro = new Macro(startLine, name, (List<String>)((Object)parameterNames.build()), body);
            this.macros.put(name, macro);
        }
        return Node.emptyNode(this.resourceName, this.lineNumber());
    }

    private Node parseMacroCall(String prefix, String directive) throws IOException {
        Node bodyContent;
        int startLine = this.lineNumber();
        StringBuilder sb = new StringBuilder(prefix).append(directive);
        while (Character.isWhitespace(this.c)) {
            sb.appendCodePoint(this.c);
            this.next();
        }
        if (this.c != 40) {
            if (UNSUPPORTED_VELOCITY_DIRECTIVES.contains(directive)) {
                throw this.parseException("EscapeVelocity does not currently support #" + directive);
            }
            if (directive.startsWith("end")) {
                throw this.parseException("Unrecognized directive #" + directive);
            }
            return this.parsePlainText(sb);
        }
        this.next();
        ImmutableList.Builder parameterNodes = ImmutableList.builder();
        while (true) {
            this.skipSpace();
            if (this.c == 41) break;
            parameterNodes.add(this.parsePrimary());
            if (this.c != 44) continue;
            this.next();
        }
        this.next();
        if (prefix.equals("#")) {
            bodyContent = null;
        } else {
            ParseResult parseResult = this.skipNewlineAndParseToStop(END_CLASS, () -> "#@" + directive + " starting on line " + startLine);
            bodyContent = Node.cons(this.resourceName, startLine, parseResult.nodes);
        }
        return new DirectiveNode.MacroCallNode(this.resourceName, this.lineNumber(), directive, (ImmutableList<ExpressionNode>)parameterNodes.build(), bodyContent);
    }

    private Node parseMacroCallWithBody() throws IOException {
        assert (this.c == 64);
        this.next();
        if (!Parser.isAsciiLetter(this.c)) {
            return this.parsePlainText("#@");
        }
        String id = this.parseId("#@");
        return this.parseMacroCall("#@", id);
    }

    private Node parseLineComment() throws IOException {
        int lineNumber = this.lineNumber();
        while (this.c != 10 && this.c != -1) {
            this.next();
        }
        this.next();
        return new CommentNode(this.resourceName, lineNumber);
    }

    private Node parseBlockComment() throws IOException {
        assert (this.c == 42);
        int startLine = this.lineNumber();
        int lastC = 0;
        this.next();
        while ((lastC != 42 || this.c != 35) && this.c != -1) {
            lastC = this.c;
            this.next();
        }
        this.next();
        return new CommentNode(this.resourceName, startLine);
    }

    private Node parsePlainText(int firstChar) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.appendCodePoint(firstChar);
        return this.parsePlainText(sb);
    }

    private Node parsePlainText(String initialChars) throws IOException {
        return this.parsePlainText(new StringBuilder(initialChars));
    }

    private Node parsePlainText(StringBuilder sb) throws IOException {
        block3: while (true) {
            switch (this.c) {
                case -1: 
                case 35: 
                case 36: {
                    break block3;
                }
                default: {
                    sb.appendCodePoint(this.c);
                    this.next();
                    continue block3;
                }
            }
            break;
        }
        return new ConstantExpressionNode(this.resourceName, this.lineNumber(), sb.toString());
    }

    private Node parseReference(boolean silent) throws IOException {
        if (this.c == 123) {
            this.next();
            if (!Parser.isAsciiLetter(this.c)) {
                if (silent) {
                    return this.parsePlainText("$!{");
                }
                return this.parsePlainText("${");
            }
            ReferenceNode node = this.parseReferenceNoBrace(silent);
            this.expect('}');
            return node;
        }
        return this.parseReferenceNoBrace(silent);
    }

    private ReferenceNode parseRequiredReference() throws IOException {
        if (this.c == 33) {
            this.next();
        }
        if (this.c == 123) {
            this.next();
            ReferenceNode node = this.parseReferenceNoBrace(false);
            this.expect('}');
            return node;
        }
        return this.parseReferenceNoBrace(false);
    }

    private ReferenceNode parseReferenceNoBrace(boolean silent) throws IOException {
        String id = this.parseId("Reference");
        ReferenceNode.PlainReferenceNode lhs = new ReferenceNode.PlainReferenceNode(this.resourceName, this.lineNumber(), id, silent);
        return this.parseReferenceSuffix(lhs, silent);
    }

    private ReferenceNode parseReferenceSuffix(ReferenceNode lhs, boolean silent) throws IOException {
        switch (this.c) {
            case 46: {
                return this.parseReferenceMember(lhs, silent);
            }
            case 91: {
                return this.parseReferenceIndex(lhs, silent);
            }
        }
        return lhs;
    }

    private ReferenceNode parseReferenceMember(ReferenceNode lhs, boolean silent) throws IOException {
        assert (this.c == 46);
        this.next();
        if (!Parser.isAsciiLetter(this.c)) {
            this.pushback(46);
            return lhs;
        }
        String id = this.parseId("Member");
        ReferenceNode reference = this.c == 40 ? this.parseReferenceMethodParams(lhs, id, silent) : new ReferenceNode.MemberReferenceNode(lhs, id, silent);
        return this.parseReferenceSuffix(reference, silent);
    }

    private ReferenceNode parseReferenceMethodParams(ReferenceNode lhs, String id, boolean silent) throws IOException {
        assert (this.c == 40);
        this.nextNonSpace();
        ImmutableList.Builder args = ImmutableList.builder();
        if (this.c != 41) {
            args.add(this.parsePrimary(true));
            while (this.c == 44) {
                this.nextNonSpace();
                args.add(this.parsePrimary(true));
            }
            if (this.c != 41) {
                throw this.parseException("Expected )");
            }
        }
        assert (this.c == 41);
        this.next();
        return new ReferenceNode.MethodReferenceNode(lhs, id, (List<ExpressionNode>)((Object)args.build()), silent);
    }

    private ReferenceNode parseReferenceIndex(ReferenceNode lhs, boolean silent) throws IOException {
        assert (this.c == 91);
        this.next();
        ExpressionNode index = this.parsePrimary();
        if (this.c != 93) {
            throw this.parseException("Expected ]");
        }
        this.next();
        ReferenceNode.IndexReferenceNode reference = new ReferenceNode.IndexReferenceNode(lhs, index, silent);
        return this.parseReferenceSuffix(reference, silent);
    }

    private ExpressionNode parseExpression() throws IOException {
        ExpressionNode lhs = this.parseUnaryExpression();
        return new OperatorParser().parse(lhs, 1);
    }

    private ExpressionNode parseUnaryExpression() throws IOException {
        this.skipSpace();
        if (this.c == 40) {
            this.nextNonSpace();
            ExpressionNode node = this.parseExpression();
            this.expect(')');
            this.skipSpace();
            return node;
        }
        if (this.c == 33) {
            this.next();
            ExpressionNode.NotExpressionNode node = new ExpressionNode.NotExpressionNode(this.parseUnaryExpression());
            this.skipSpace();
            return node;
        }
        return this.parsePrimary();
    }

    private ExpressionNode parsePrimary() throws IOException {
        return this.parsePrimary(false);
    }

    private ExpressionNode parsePrimary(boolean nullAllowed) throws IOException {
        ExpressionNode node;
        this.skipSpace();
        if (this.c == 36) {
            this.next();
            node = this.parseRequiredReference();
        } else if (this.c == 34) {
            node = this.parseStringLiteral('\"', true);
        } else if (this.c == 39) {
            node = this.parseStringLiteral('\'', false);
        } else if (this.c == 45) {
            this.next();
            node = this.parseIntLiteral("-");
        } else if (this.c == 91) {
            node = this.parseListLiteral();
        } else if (Parser.isAsciiDigit(this.c)) {
            node = this.parseIntLiteral("");
        } else if (Parser.isAsciiLetter(this.c)) {
            node = this.parseNotOrBooleanOrNullLiteral(nullAllowed);
        } else {
            throw this.parseException("Expected a reference or a literal");
        }
        this.skipSpace();
        return node;
    }

    private ExpressionNode parseListLiteral() throws IOException {
        assert (this.c == 91);
        this.nextNonSpace();
        if (this.c == 93) {
            this.next();
            return new ListLiteralNode(this.resourceName, this.lineNumber(), ImmutableList.of());
        }
        ExpressionNode first = this.parsePrimary(false);
        if (this.c == 46) {
            return this.parseRangeLiteral(first);
        }
        return this.parseRemainderOfListLiteral(first);
    }

    private ExpressionNode parseRangeLiteral(ExpressionNode first) throws IOException {
        assert (this.c == 46);
        this.next();
        if (this.c != 46) {
            throw this.parseException("Expected two dots (..) not just one");
        }
        this.nextNonSpace();
        ExpressionNode last = this.parsePrimary(false);
        if (this.c != 93) {
            throw this.parseException("Expected ] at end of range literal");
        }
        this.nextNonSpace();
        return new RangeLiteralNode(this.resourceName, this.lineNumber(), first, last);
    }

    private ExpressionNode parseRemainderOfListLiteral(ExpressionNode first) throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(first);
        while (this.c == 44) {
            this.next();
            builder.add(this.parsePrimary(false));
        }
        if (this.c != 93) {
            throw this.parseException("Expected ] at end of list literal");
        }
        this.next();
        return new ListLiteralNode(this.resourceName, this.lineNumber(), (ImmutableList<ExpressionNode>)builder.build());
    }

    private ExpressionNode parseStringLiteral(char quote, boolean expand) throws IOException {
        ImmutableList<Node> nodes;
        assert (this.c == quote);
        this.next();
        StringBuilder sb = new StringBuilder();
        while (this.c != quote) {
            switch (this.c) {
                case -1: {
                    throw this.parseException("Unterminated string constant");
                }
                case 92: {
                    throw this.parseException("Escapes in string constants are not currently supported");
                }
            }
            sb.appendCodePoint(this.c);
            this.next();
        }
        this.next();
        String s2 = sb.toString();
        if (expand) {
            String where = "string " + ParseException.where(this.resourceName, this.lineNumber());
            Parser stringParser = new Parser(new StringReader(s2), where, this.resourceOpener, this.parseCache);
            ParseResult parseResult = stringParser.parseToStop(EOF_CLASS, () -> "outside any construct");
            nodes = parseResult.nodes;
        } else {
            nodes = ImmutableList.of(new ConstantExpressionNode(this.resourceName, this.lineNumber(), s2));
        }
        return new StringLiteralNode(this.resourceName, this.lineNumber(), quote, nodes);
    }

    private Node parseEvaluate() throws IOException {
        int startLine = this.lineNumber();
        this.expect('(');
        ExpressionNode expression = this.parsePrimary();
        this.expect(')');
        if (this.c == 10) {
            this.next();
        }
        return new EvaluateNode(this.resourceName, startLine, expression);
    }

    private ExpressionNode parseIntLiteral(String prefix) throws IOException {
        StringBuilder sb = new StringBuilder(prefix);
        while (Parser.isAsciiDigit(this.c)) {
            sb.appendCodePoint(this.c);
            this.next();
        }
        Integer value = Ints.tryParse(sb.toString());
        if (value == null) {
            throw this.parseException("Invalid integer: " + sb);
        }
        return new ConstantExpressionNode(this.resourceName, this.lineNumber(), value);
    }

    private ExpressionNode parseNotOrBooleanOrNullLiteral(boolean nullAllowed) throws IOException {
        Boolean value;
        String id;
        switch (id = this.parseId("Identifier without $")) {
            case "true": {
                value = true;
                break;
            }
            case "false": {
                value = false;
                break;
            }
            case "not": {
                return new ExpressionNode.NotExpressionNode(this.parseUnaryExpression());
            }
            case "null": {
                if (nullAllowed) {
                    value = null;
                    break;
                }
            }
            default: {
                String suffix = nullAllowed ? " or null" : "";
                throw this.parseException("Identifier must be preceded by $ or be true or false" + suffix + ": " + id);
            }
        }
        return new ConstantExpressionNode(this.resourceName, this.lineNumber(), value);
    }

    private static boolean isAsciiLetter(int c) {
        return (char)c == c && ASCII_LETTER.matches((char)c);
    }

    private static boolean isAsciiDigit(int c) {
        return (char)c == c && ASCII_DIGIT.matches((char)c);
    }

    private static boolean isIdChar(int c) {
        return (char)c == c && ID_CHAR.matches((char)c);
    }

    private String parseId(String what) throws IOException {
        if (!Parser.isAsciiLetter(this.c)) {
            throw this.parseException(what + " should start with an ASCII letter");
        }
        StringBuilder id = new StringBuilder();
        while (Parser.isIdChar(this.c)) {
            id.appendCodePoint(this.c);
            this.next();
        }
        return id.toString();
    }

    private ParseException parseException(String message) throws IOException {
        int line = this.lineNumber();
        StringBuilder context = new StringBuilder();
        if (this.c == -1) {
            context.append("EOF");
        } else {
            for (int count = 0; this.c != -1 && count < 20; ++count) {
                context.appendCodePoint(this.c);
                this.next();
            }
            if (this.c != -1) {
                context.append("...");
            }
        }
        return new ParseException(message, this.resourceName, line, context.toString());
    }

    static {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (Operator operator : Operator.values()) {
            if (operator == Operator.STOP) continue;
            builder.put((Object)operator.symbol.charAt(0), (Object)operator);
        }
        CODE_POINT_TO_OPERATORS = builder.build();
        ASCII_LETTER = CharMatcher.inRange('A', 'Z').or(CharMatcher.inRange('a', 'z')).precomputed();
        ASCII_DIGIT = CharMatcher.inRange('0', '9').precomputed();
        ID_CHAR = ASCII_LETTER.or(ASCII_DIGIT).or(CharMatcher.anyOf("-_")).precomputed();
    }

    private class EvaluateNode
    extends Node {
        private final ExpressionNode expression;

        EvaluateNode(String resourceName, int lineNumber, ExpressionNode expression) {
            super(resourceName, lineNumber);
            this.expression = expression;
        }

        @Override
        void render(EvaluationContext context, StringBuilder sb) {
            Template template;
            Object valueObject = this.expression.evaluate(context);
            if (valueObject == null) {
                return;
            }
            if (!(valueObject instanceof String)) {
                throw this.evaluationException("Argument to #evaluate must be a string: " + valueObject);
            }
            String value = (String)valueObject;
            String where = "#evaluate " + ParseException.where(this.resourceName, Parser.this.lineNumber());
            try {
                Parser parser = new Parser(new StringReader(value), where, Parser.this.resourceOpener, Parser.this.parseCache);
                template = parser.parse();
            }
            catch (IOException e) {
                throw this.evaluationException(e);
            }
            template.render(context, sb);
        }
    }

    private static class StringLiteralNode
    extends ExpressionNode {
        private final char quote;
        private final ImmutableList<Node> nodes;

        StringLiteralNode(String resourceName, int lineNumber, char quote, ImmutableList<Node> nodes) {
            super(resourceName, lineNumber);
            this.quote = quote;
            this.nodes = nodes;
        }

        @Override
        public String toString() {
            return this.quote + Joiner.on("").join(this.nodes) + this.quote;
        }

        @Override
        Object evaluate(EvaluationContext context, boolean undefinedIsFalse) {
            StringBuilder sb = new StringBuilder();
            for (Node node : this.nodes) {
                node.render(context, sb);
            }
            return sb.toString();
        }
    }

    private static class ListLiteralNode
    extends ExpressionNode {
        private final ImmutableList<ExpressionNode> elements;

        ListLiteralNode(String resourceName, int lineNumber, ImmutableList<ExpressionNode> elements) {
            super(resourceName, lineNumber);
            this.elements = elements;
        }

        @Override
        public String toString() {
            return "[" + Joiner.on(", ").join(this.elements) + "]";
        }

        @Override
        Object evaluate(EvaluationContext context, boolean undefinedIsFalse) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (ExpressionNode element : this.elements) {
                list.add(element.evaluate(context));
            }
            return Collections.unmodifiableList(list);
        }
    }

    private static class RangeLiteralNode
    extends ExpressionNode {
        private final ExpressionNode first;
        private final ExpressionNode last;

        RangeLiteralNode(String resourceName, int lineNumber, ExpressionNode first, ExpressionNode last) {
            super(resourceName, lineNumber);
            this.first = first;
            this.last = last;
        }

        @Override
        public String toString() {
            return "[" + this.first + ".." + this.last + "]";
        }

        @Override
        Object evaluate(EvaluationContext context, boolean undefinedIsFalse) {
            int to;
            int from = this.first.intValue(context);
            final NavigableSet<Integer> set = from <= (to = this.last.intValue(context).intValue()) ? ContiguousSet.closed(from, to) : ContiguousSet.closed(to, from).descendingSet();
            return new ForwardingSortedSet<Integer>(){

                @Override
                protected ImmutableSortedSet<Integer> delegate() {
                    return set;
                }

                @Override
                public String toString() {
                    return set.asList().toString();
                }
            };
        }
    }

    private class OperatorParser {
        private Operator currentOperator;

        OperatorParser() throws IOException {
            this.nextOperator();
        }

        ExpressionNode parse(ExpressionNode lhs, int minPrecedence) throws IOException {
            while (this.currentOperator.precedence >= minPrecedence) {
                Operator operator = this.currentOperator;
                ExpressionNode rhs = Parser.this.parseUnaryExpression();
                this.nextOperator();
                while (this.currentOperator.precedence > operator.precedence) {
                    rhs = this.parse(rhs, this.currentOperator.precedence);
                }
                lhs = new ExpressionNode.BinaryExpressionNode(lhs, operator, rhs);
            }
            return lhs;
        }

        private void nextOperator() throws IOException {
            Parser.this.skipSpace();
            switch (Parser.this.c) {
                case 97: {
                    this.wordOperator("and", Operator.AND);
                    return;
                }
                case 111: {
                    this.wordOperator("or", Operator.OR);
                    return;
                }
            }
            ImmutableCollection possibleOperators = CODE_POINT_TO_OPERATORS.get((Object)Parser.this.c);
            if (possibleOperators.isEmpty()) {
                this.currentOperator = Operator.STOP;
                return;
            }
            char firstChar = Chars.checkedCast(Parser.this.c);
            Parser.this.next();
            Operator operator = null;
            for (Operator possibleOperator : possibleOperators) {
                if (possibleOperator.symbol.length() == 1) {
                    Verify.verify(operator == null);
                    operator = possibleOperator;
                    continue;
                }
                if (possibleOperator.symbol.charAt(1) != Parser.this.c) continue;
                Parser.this.next();
                operator = possibleOperator;
            }
            if (operator == null) {
                throw Parser.this.parseException("Expected " + Iterables.getOnlyElement(possibleOperators) + ", not just " + firstChar);
            }
            this.currentOperator = operator;
        }

        private void wordOperator(String symbol, Operator operator) throws IOException {
            String id = Parser.this.parseId("");
            if (!id.equals(symbol)) {
                throw Parser.this.parseException("Expected '" + symbol + "' but was '" + id + "'");
            }
            this.currentOperator = operator;
        }
    }

    static enum Operator {
        STOP("", 0),
        OR("||", 1),
        AND("&&", 2),
        EQUAL("==", 3),
        NOT_EQUAL("!=", 3),
        LESS("<", 4),
        LESS_OR_EQUAL("<=", 4),
        GREATER(">", 4),
        GREATER_OR_EQUAL(">=", 4),
        PLUS("+", 5),
        MINUS("-", 5),
        TIMES("*", 6),
        DIVIDE("/", 6),
        REMAINDER("%", 6);

        final String symbol;
        final int precedence;

        private Operator(String symbol, int precedence) {
            this.symbol = symbol;
            this.precedence = precedence;
        }

        public String toString() {
            return this.symbol;
        }

        boolean isInequality() {
            return this.precedence == 4;
        }
    }

    static class CommentNode
    extends Node {
        CommentNode(String resourceName, int lineNumber) {
            super(resourceName, lineNumber);
        }

        @Override
        void render(EvaluationContext context, StringBuilder output) {
        }
    }

    private static class ParseResult {
        final ImmutableList<Node> nodes;
        final StopNode stop;

        ParseResult(ImmutableList<Node> nodes, StopNode stop) {
            this.nodes = nodes;
            this.stop = stop;
        }
    }
}

