/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.api.client.json.gson;

import com.infinite_craft.libs.com.google.api.client.json.JsonFactory;
import com.infinite_craft.libs.com.google.api.client.json.JsonGenerator;
import com.infinite_craft.libs.com.google.api.client.json.JsonParser;
import com.infinite_craft.libs.com.google.api.client.json.gson.GsonGenerator;
import com.infinite_craft.libs.com.google.api.client.json.gson.GsonParser;
import com.infinite_craft.libs.com.google.api.client.util.Beta;
import com.infinite_craft.libs.com.google.gson.stream.JsonReader;
import com.infinite_craft.libs.com.google.gson.stream.JsonWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class GsonFactory
extends JsonFactory {
    private boolean readLeniency = false;

    @Beta
    public static GsonFactory getDefaultInstance() {
        return InstanceHolder.INSTANCE;
    }

    public GsonFactory() {
    }

    private GsonFactory(Builder builder) {
        this.readLeniency = builder.readLeniency;
    }

    @Override
    public JsonParser createJsonParser(InputStream in) {
        return this.createJsonParser(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    @Override
    public JsonParser createJsonParser(InputStream in, Charset charset) {
        if (charset == null) {
            return this.createJsonParser(in);
        }
        return this.createJsonParser(new InputStreamReader(in, charset));
    }

    @Override
    public JsonParser createJsonParser(String value) {
        return this.createJsonParser(new StringReader(value));
    }

    @Override
    public JsonParser createJsonParser(Reader reader) {
        return new GsonParser(this, new JsonReader(reader));
    }

    @Override
    public JsonGenerator createJsonGenerator(OutputStream out, Charset enc) {
        return this.createJsonGenerator(new OutputStreamWriter(out, enc));
    }

    @Override
    public JsonGenerator createJsonGenerator(Writer writer) {
        return new GsonGenerator(this, new JsonWriter(writer));
    }

    boolean getReadLeniency() {
        return this.readLeniency;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean readLeniency = false;

        private Builder() {
        }

        public Builder setReadLeniency(boolean readLeniency) {
            this.readLeniency = readLeniency;
            return this;
        }

        public GsonFactory build() {
            return new GsonFactory(this);
        }
    }

    @Beta
    static class InstanceHolder {
        static final GsonFactory INSTANCE = new GsonFactory();

        InstanceHolder() {
        }
    }
}

