/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.api.pathtemplate;

import java.util.Stack;

public class ValidationException
extends IllegalArgumentException {
    private static ThreadLocal<Stack<Supplier<String>>> contextLocal = new ThreadLocal();

    public static void pushCurrentThreadValidationContext(Supplier<String> supplier) {
        Stack<Supplier<String>> stack = contextLocal.get();
        if (stack == null) {
            stack = new Stack();
            contextLocal.set(stack);
        }
        stack.push(supplier);
    }

    public static void pushCurrentThreadValidationContext(final String context) {
        ValidationException.pushCurrentThreadValidationContext(new Supplier<String>(){

            @Override
            public String get() {
                return context;
            }
        });
    }

    public static void popCurrentThreadValidationContext() {
        Stack<Supplier<String>> stack = contextLocal.get();
        if (stack != null) {
            stack.pop();
        }
    }

    public ValidationException(String format, Object ... args) {
        super(ValidationException.message(contextLocal.get(), format, args));
    }

    private static String message(Stack<Supplier<String>> context, String format, Object ... args) {
        if (context == null || context.isEmpty()) {
            return String.format(format, args);
        }
        StringBuilder result = new StringBuilder();
        for (Supplier supplier : context) {
            result.append((String)supplier.get() + ": ");
        }
        return result.toString() + String.format(format, args);
    }

    @FunctionalInterface
    public static interface Supplier<T> {
        public T get();
    }
}

