/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.auth.oauth2;

import com.infinite_craft.libs.com.google.api.client.json.GenericJson;
import com.infinite_craft.libs.com.google.auth.http.HttpTransportFactory;
import com.infinite_craft.libs.com.google.auth.oauth2.AccessToken;
import com.infinite_craft.libs.com.google.auth.oauth2.AwsCredentialSource;
import com.infinite_craft.libs.com.google.auth.oauth2.AwsRequestSignature;
import com.infinite_craft.libs.com.google.auth.oauth2.AwsRequestSigner;
import com.infinite_craft.libs.com.google.auth.oauth2.AwsSecurityCredentials;
import com.infinite_craft.libs.com.google.auth.oauth2.AwsSecurityCredentialsSupplier;
import com.infinite_craft.libs.com.google.auth.oauth2.EnvironmentProvider;
import com.infinite_craft.libs.com.google.auth.oauth2.ExternalAccountCredentials;
import com.infinite_craft.libs.com.google.auth.oauth2.ExternalAccountSupplierContext;
import com.infinite_craft.libs.com.google.auth.oauth2.GoogleCredentials;
import com.infinite_craft.libs.com.google.auth.oauth2.InternalAwsSecurityCredentialsSupplier;
import com.infinite_craft.libs.com.google.auth.oauth2.OAuth2Utils;
import com.infinite_craft.libs.com.google.auth.oauth2.StsTokenExchangeRequest;
import com.infinite_craft.libs.com.google.common.annotations.VisibleForTesting;
import com.infinite_craft.libs.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.infinite_craft.libs.javax.annotation.Nullable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AwsCredentials
extends ExternalAccountCredentials {
    static final String DEFAULT_REGIONAL_CREDENTIAL_VERIFICATION_URL = "https://sts.{region}.amazonaws.com?Action=GetCallerIdentity&Version=2011-06-15";
    static final String AWS_METRICS_HEADER_VALUE = "aws";
    private static final long serialVersionUID = -3670131891574618105L;
    private final AwsSecurityCredentialsSupplier awsSecurityCredentialsSupplier;
    private final ExternalAccountSupplierContext supplierContext = ExternalAccountSupplierContext.newBuilder().setAudience(this.getAudience()).setSubjectTokenType(this.getSubjectTokenType()).build();
    @Nullable
    private final String regionalCredentialVerificationUrlOverride;
    @Nullable
    private final String regionalCredentialVerificationUrl;
    private final String metricsHeaderValue;

    AwsCredentials(Builder builder) {
        super(builder);
        if (builder.awsSecurityCredentialsSupplier != null && builder.credentialSource != null) {
            throw new IllegalArgumentException("AwsCredentials cannot have both an awsSecurityCredentialsSupplier and a credentialSource.");
        }
        if (builder.awsSecurityCredentialsSupplier == null && builder.credentialSource == null) {
            throw new IllegalArgumentException("An awsSecurityCredentialsSupplier or a credentialSource must be provided.");
        }
        AwsCredentialSource credentialSource = (AwsCredentialSource)builder.credentialSource;
        this.regionalCredentialVerificationUrlOverride = builder.regionalCredentialVerificationUrlOverride;
        this.regionalCredentialVerificationUrl = this.regionalCredentialVerificationUrlOverride != null ? this.regionalCredentialVerificationUrlOverride : (credentialSource != null ? credentialSource.regionalCredentialVerificationUrl : DEFAULT_REGIONAL_CREDENTIAL_VERIFICATION_URL);
        if (builder.awsSecurityCredentialsSupplier != null) {
            this.awsSecurityCredentialsSupplier = builder.awsSecurityCredentialsSupplier;
            this.metricsHeaderValue = "programmatic";
        } else {
            this.awsSecurityCredentialsSupplier = new InternalAwsSecurityCredentialsSupplier(credentialSource, this.getEnvironmentProvider(), this.transportFactory);
            this.metricsHeaderValue = AWS_METRICS_HEADER_VALUE;
        }
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        StsTokenExchangeRequest.Builder stsTokenExchangeRequest = StsTokenExchangeRequest.newBuilder(this.retrieveSubjectToken(), this.getSubjectTokenType()).setAudience(this.getAudience());
        Collection<String> scopes = this.getScopes();
        if (scopes != null && !scopes.isEmpty()) {
            stsTokenExchangeRequest.setScopes(new ArrayList<String>(scopes));
        }
        return this.exchangeExternalCredentialForAccessToken(stsTokenExchangeRequest.build());
    }

    @Override
    public String retrieveSubjectToken() throws IOException {
        String region = this.awsSecurityCredentialsSupplier.getRegion(this.supplierContext);
        AwsSecurityCredentials credentials = this.awsSecurityCredentialsSupplier.getCredentials(this.supplierContext);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-goog-cloud-target-resource", this.getAudience());
        AwsRequestSigner signer = AwsRequestSigner.newBuilder(credentials, "POST", this.regionalCredentialVerificationUrl.replace("{region}", region), region).setAdditionalHeaders(headers).build();
        AwsRequestSignature awsRequestSignature = signer.sign();
        return this.buildSubjectToken(awsRequestSignature);
    }

    @Override
    public GoogleCredentials createScoped(Collection<String> newScopes) {
        return new AwsCredentials((Builder)AwsCredentials.newBuilder(this).setScopes((Collection)newScopes));
    }

    @Override
    String getCredentialSourceType() {
        return this.metricsHeaderValue;
    }

    private String buildSubjectToken(AwsRequestSignature signature) throws UnsupportedEncodingException {
        Map<String, String> canonicalHeaders = signature.getCanonicalHeaders();
        ArrayList<GenericJson> headerList = new ArrayList<GenericJson>();
        for (String headerName : canonicalHeaders.keySet()) {
            headerList.add(AwsCredentials.formatTokenHeaderForSts(headerName, canonicalHeaders.get(headerName)));
        }
        headerList.add(AwsCredentials.formatTokenHeaderForSts("Authorization", signature.getAuthorizationHeader()));
        headerList.add(AwsCredentials.formatTokenHeaderForSts("x-goog-cloud-target-resource", this.getAudience()));
        GenericJson token = new GenericJson();
        token.setFactory(OAuth2Utils.JSON_FACTORY);
        token.put("headers", (Object)headerList);
        token.put("method", (Object)signature.getHttpMethod());
        token.put("url", (Object)this.regionalCredentialVerificationUrl.replace("{region}", signature.getRegion()));
        return URLEncoder.encode(token.toString(), "UTF-8");
    }

    @VisibleForTesting
    String getRegionalCredentialVerificationUrl() {
        return this.regionalCredentialVerificationUrl;
    }

    @VisibleForTesting
    String getEnv(String name) {
        return System.getenv(name);
    }

    @VisibleForTesting
    AwsSecurityCredentialsSupplier getAwsSecurityCredentialsSupplier() {
        return this.awsSecurityCredentialsSupplier;
    }

    @Nullable
    public String getRegionalCredentialVerificationUrlOverride() {
        return this.regionalCredentialVerificationUrlOverride;
    }

    private static GenericJson formatTokenHeaderForSts(String key, String value) {
        GenericJson header = new GenericJson();
        header.setFactory(OAuth2Utils.JSON_FACTORY);
        header.put("key", (Object)key);
        header.put("value", (Object)value);
        return header;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(AwsCredentials awsCredentials) {
        return new Builder(awsCredentials);
    }

    public static class Builder
    extends ExternalAccountCredentials.Builder {
        private AwsSecurityCredentialsSupplier awsSecurityCredentialsSupplier;
        private String regionalCredentialVerificationUrlOverride;

        Builder() {
        }

        Builder(AwsCredentials credentials) {
            super(credentials);
            if (this.credentialSource == null) {
                this.awsSecurityCredentialsSupplier = credentials.awsSecurityCredentialsSupplier;
            }
            this.regionalCredentialVerificationUrlOverride = credentials.regionalCredentialVerificationUrlOverride;
        }

        @CanIgnoreReturnValue
        public Builder setAwsSecurityCredentialsSupplier(AwsSecurityCredentialsSupplier awsSecurityCredentialsSupplier) {
            this.awsSecurityCredentialsSupplier = awsSecurityCredentialsSupplier;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setRegionalCredentialVerificationUrlOverride(String regionalCredentialVerificationUrlOverride) {
            this.regionalCredentialVerificationUrlOverride = regionalCredentialVerificationUrlOverride;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setHttpTransportFactory(HttpTransportFactory transportFactory) {
            super.setHttpTransportFactory(transportFactory);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setAudience(String audience) {
            super.setAudience(audience);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setSubjectTokenType(String subjectTokenType) {
            super.setSubjectTokenType(subjectTokenType);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setSubjectTokenType(ExternalAccountCredentials.SubjectTokenTypes subjectTokenType) {
            super.setSubjectTokenType(subjectTokenType);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setTokenUrl(String tokenUrl) {
            super.setTokenUrl(tokenUrl);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCredentialSource(AwsCredentialSource credentialSource) {
            super.setCredentialSource(credentialSource);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setServiceAccountImpersonationUrl(String serviceAccountImpersonationUrl) {
            super.setServiceAccountImpersonationUrl(serviceAccountImpersonationUrl);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setTokenInfoUrl(String tokenInfoUrl) {
            super.setTokenInfoUrl(tokenInfoUrl);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setQuotaProjectId(String quotaProjectId) {
            super.setQuotaProjectId(quotaProjectId);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setClientId(String clientId) {
            super.setClientId(clientId);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setClientSecret(String clientSecret) {
            super.setClientSecret(clientSecret);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setScopes(Collection<String> scopes) {
            super.setScopes(scopes);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setWorkforcePoolUserProject(String workforcePoolUserProject) {
            super.setWorkforcePoolUserProject(workforcePoolUserProject);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setServiceAccountImpersonationOptions(Map<String, Object> optionsMap) {
            super.setServiceAccountImpersonationOptions(optionsMap);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setUniverseDomain(String universeDomain) {
            super.setUniverseDomain(universeDomain);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        Builder setEnvironmentProvider(EnvironmentProvider environmentProvider) {
            super.setEnvironmentProvider(environmentProvider);
            return this;
        }

        @Override
        public AwsCredentials build() {
            return new AwsCredentials(this);
        }
    }
}

