/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.auto.value.extension.serializable.serializer;

import com.infinite_craft.libs.autovalue.shaded.com.google.common.base.Throwables;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableList;
import com.infinite_craft.libs.com.google.auto.value.extension.serializable.serializer.impl.SerializerFactoryImpl;
import com.infinite_craft.libs.com.google.auto.value.extension.serializable.serializer.interfaces.SerializerExtension;
import com.infinite_craft.libs.com.google.auto.value.extension.serializable.serializer.interfaces.SerializerFactory;
import com.infinite_craft.libs.com.google.auto.value.processor.SimpleServiceLoader;
import com.infinite_craft.libs.javax.annotation.processing.ProcessingEnvironment;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;

public final class SerializerFactoryLoader {
    public static SerializerFactory getFactory(ProcessingEnvironment processingEnv) {
        return new SerializerFactoryImpl(SerializerFactoryLoader.loadExtensions(processingEnv), processingEnv);
    }

    private static ImmutableList<SerializerExtension> loadExtensions(ProcessingEnvironment processingEnv) {
        String allowedMissingClasses = (String)processingEnv.getOptions().get("allowedMissingSerializableExtensionClasses");
        Optional<Pattern> allowedMissingClassesPattern = Optional.ofNullable(allowedMissingClasses).map(Pattern::compile);
        try {
            return ImmutableList.copyOf(SimpleServiceLoader.load(SerializerExtension.class, SerializerFactoryLoader.class.getClassLoader(), allowedMissingClassesPattern));
        }
        catch (Throwable t2) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, (CharSequence)("An exception occurred while looking for SerializerExtensions. No extensions will function.\n" + Throwables.getStackTraceAsString(t2)));
            return ImmutableList.of();
        }
    }

    private SerializerFactoryLoader() {
    }
}

