/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.auto.value.extension.toprettystring.processor;

import com.infinite_craft.libs.autovalue.shaded.com.google.auto.common.GeneratedAnnotationSpecs;
import com.infinite_craft.libs.autovalue.shaded.com.google.auto.common.MoreStreams;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableList;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableMap;
import com.infinite_craft.libs.autovalue.shaded.com.squareup.javapoet.AnnotationSpec;
import com.infinite_craft.libs.autovalue.shaded.com.squareup.javapoet.ClassName;
import com.infinite_craft.libs.autovalue.shaded.com.squareup.javapoet.MethodSpec;
import com.infinite_craft.libs.autovalue.shaded.com.squareup.javapoet.ParameterizedTypeName;
import com.infinite_craft.libs.autovalue.shaded.com.squareup.javapoet.TypeName;
import com.infinite_craft.libs.autovalue.shaded.com.squareup.javapoet.TypeSpec;
import com.infinite_craft.libs.autovalue.shaded.com.squareup.javapoet.TypeVariableName;
import com.infinite_craft.libs.com.google.auto.value.extension.AutoValueExtension;
import com.infinite_craft.libs.com.google.auto.value.extension.toprettystring.processor.ToPrettyStringExtension;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

final class ExtensionClassTypeSpecBuilder {
    private final AutoValueExtension.Context context;
    private final String className;
    private final String classToExtend;
    private final boolean isFinal;
    private final Elements elements;
    private final SourceVersion sourceVersion;

    private ExtensionClassTypeSpecBuilder(AutoValueExtension.Context context, String className, String classToExtend, boolean isFinal) {
        this.context = context;
        this.className = className;
        this.classToExtend = classToExtend;
        this.isFinal = isFinal;
        this.elements = context.processingEnvironment().getElementUtils();
        this.sourceVersion = context.processingEnvironment().getSourceVersion();
    }

    static TypeSpec.Builder extensionClassTypeSpecBuilder(AutoValueExtension.Context context, String className, String classToExtend, boolean isFinal) {
        return new ExtensionClassTypeSpecBuilder(context, className, classToExtend, isFinal).extensionClassBuilder();
    }

    TypeSpec.Builder extensionClassBuilder() {
        TypeSpec.Builder builder = TypeSpec.classBuilder(this.className).superclass(this.superType()).addAnnotations(this.context.classAnnotationsToCopy(this.context.autoValueClass()).stream().map(AnnotationSpec::get).collect(MoreStreams.toImmutableList())).addTypeVariables(this.annotatedTypeVariableNames()).addModifiers(this.isFinal ? Modifier.FINAL : Modifier.ABSTRACT).addMethod(this.constructor());
        GeneratedAnnotationSpecs.generatedAnnotationSpec(this.elements, this.sourceVersion, ToPrettyStringExtension.class).ifPresent(builder::addAnnotation);
        return builder;
    }

    private TypeName superType() {
        ClassName superType = ClassName.get(this.context.packageName(), this.classToExtend, new String[0]);
        ImmutableList<TypeVariableName> typeVariableNames = this.typeVariableNames();
        return typeVariableNames.isEmpty() ? superType : ParameterizedTypeName.get(superType, typeVariableNames.toArray(new TypeName[0]));
    }

    private ImmutableList<TypeVariableName> typeVariableNames() {
        return this.context.autoValueClass().getTypeParameters().stream().map(TypeVariableName::get).collect(MoreStreams.toImmutableList());
    }

    private ImmutableList<TypeVariableName> annotatedTypeVariableNames() {
        return this.context.autoValueClass().getTypeParameters().stream().map(p -> TypeVariableName.get(p).annotated((List)p.getAnnotationMirrors().stream().map(AnnotationSpec::get).collect(MoreStreams.toImmutableList()))).collect(MoreStreams.toImmutableList());
    }

    private MethodSpec constructor() {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder();
        Set<String> propertyNames = this.context.properties().keySet();
        ImmutableMap<String, String> parameterNames = propertyNames.stream().collect(MoreStreams.toImmutableMap(name -> name, name -> ExtensionClassTypeSpecBuilder.generateIdentifier(name, propertyNames)));
        this.context.propertyTypes().forEach((name, type) -> constructor.addParameter(ExtensionClassTypeSpecBuilder.annotatedType(type), (String)parameterNames.get(name), new Modifier[0]));
        String superParams = this.context.properties().keySet().stream().map(parameterNames::get).collect(Collectors.joining(", "));
        constructor.addStatement("super($L)", superParams);
        return constructor.build();
    }

    private static String generateIdentifier(String name, Set<String> existingNames) {
        if (!SourceVersion.isKeyword(name)) {
            return name;
        }
        int i = 0;
        String newName;
        while (existingNames.contains(newName = name + i)) {
            ++i;
        }
        return newName;
    }

    private static TypeName annotatedType(TypeMirror type) {
        List<AnnotationSpec> annotations = type.getAnnotationMirrors().stream().map(AnnotationSpec::get).collect(Collectors.toList());
        return TypeName.get(type).annotated(annotations);
    }
}

