/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.auto.value.processor;

import com.infinite_craft.libs.autovalue.shaded.com.google.common.base.Joiner;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableList;
import java.util.Objects;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

final class AnnotatedTypeMirror {
    private final TypeMirror originalType;
    private final TypeMirror rewrittenType;

    AnnotatedTypeMirror(TypeMirror originalType, TypeMirror rewrittenType) {
        this.originalType = originalType;
        this.rewrittenType = rewrittenType;
    }

    AnnotatedTypeMirror(TypeMirror type) {
        this(type, type);
    }

    ImmutableList<AnnotationMirror> annotations() {
        return ImmutableList.copyOf(this.originalType.getAnnotationMirrors());
    }

    TypeMirror getType() {
        return this.rewrittenType;
    }

    TypeKind getKind() {
        return this.rewrittenType.getKind();
    }

    public String toString() {
        String annotations = Joiner.on(' ').join(this.originalType.getAnnotationMirrors());
        return annotations.isEmpty() ? this.rewrittenType.toString() : annotations + " " + this.rewrittenType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AnnotatedTypeMirror) {
            AnnotatedTypeMirror that = (AnnotatedTypeMirror)obj;
            return this.originalType == that.originalType && this.rewrittenType == that.rewrittenType;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.originalType, this.rewrittenType);
    }
}

