/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.auto.value.processor;

import com.infinite_craft.libs.autovalue.shaded.com.google.auto.common.GeneratedAnnotations;
import com.infinite_craft.libs.autovalue.shaded.com.google.auto.common.MoreElements;
import com.infinite_craft.libs.autovalue.shaded.com.google.auto.common.MoreTypes;
import com.infinite_craft.libs.autovalue.shaded.com.google.auto.common.SuperficialValidation;
import com.infinite_craft.libs.autovalue.shaded.com.google.auto.service.AutoService;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.base.Preconditions;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.base.Throwables;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableCollection;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableList;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableMap;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.ImmutableSet;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.collect.Maps;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.hash.Hashing;
import com.infinite_craft.libs.autovalue.shaded.com.google.common.primitives.Primitives;
import com.infinite_craft.libs.autovalue.shaded.com.google.errorprone.annotations.FormatMethod;
import com.infinite_craft.libs.autovalue.shaded.net.ltgt.gradle.incap.IncrementalAnnotationProcessor;
import com.infinite_craft.libs.autovalue.shaded.net.ltgt.gradle.incap.IncrementalAnnotationProcessorType;
import com.infinite_craft.libs.com.google.auto.value.processor.AbortProcessingException;
import com.infinite_craft.libs.com.google.auto.value.processor.AnnotationOutput;
import com.infinite_craft.libs.com.google.auto.value.processor.AutoAnnotationTemplateVars;
import com.infinite_craft.libs.com.google.auto.value.processor.Nullables;
import com.infinite_craft.libs.com.google.auto.value.processor.Reformatter;
import com.infinite_craft.libs.com.google.auto.value.processor.TypeEncoder;
import com.infinite_craft.libs.com.google.auto.value.processor.TypeSimplifier;
import com.infinite_craft.libs.javax.annotation.processing.AbstractProcessor;
import com.infinite_craft.libs.javax.annotation.processing.ProcessingEnvironment;
import com.infinite_craft.libs.javax.annotation.processing.Processor;
import com.infinite_craft.libs.javax.annotation.processing.RoundEnvironment;
import com.infinite_craft.libs.javax.annotation.processing.SupportedAnnotationTypes;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"com.infinite_craft.libs.com.google.auto.value.AutoAnnotation"})
@AutoService(value={Processor.class})
@IncrementalAnnotationProcessor(value=IncrementalAnnotationProcessorType.ISOLATING)
public class AutoAnnotationProcessor
extends AbstractProcessor {
    private Elements elementUtils;
    private Types typeUtils;
    private TypeMirror javaLangObject;

    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    public ImmutableSet<String> getSupportedOptions() {
        return ImmutableSet.of("com.infinite_craft.libs.com.google.auto.value.NullableTypeAnnotation");
    }

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
        this.javaLangObject = this.elementUtils.getTypeElement("java.lang.Object").asType();
    }

    @FormatMethod
    private void reportError(Element e, String msg, Object ... msgParams) {
        String formattedMessage = String.format(msg, msgParams);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, (CharSequence)formattedMessage, e);
    }

    @FormatMethod
    private AbortProcessingException abortWithError(Element e, String msg, Object ... msgParams) {
        this.reportError(e, msg, msgParams);
        return new AbortProcessingException();
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.process(roundEnv);
        return false;
    }

    private void process(RoundEnvironment roundEnv) {
        TypeElement autoAnnotation = this.elementUtils.getTypeElement("com.infinite_craft.libs.com.google.auto.value.AutoAnnotation");
        Set annotatedElements = roundEnv.getElementsAnnotatedWith(autoAnnotation);
        List<ExecutableElement> methods = ElementFilter.methodsIn(annotatedElements);
        if (!SuperficialValidation.validateElements(methods) || this.methodsAreOverloaded(methods)) {
            return;
        }
        for (ExecutableElement method : methods) {
            try {
                this.processMethod(method);
            }
            catch (AbortProcessingException abortProcessingException) {
            }
            catch (RuntimeException e) {
                String trace = Throwables.getStackTraceAsString(e);
                this.reportError(method, "@AutoAnnotation processor threw an exception: %s", trace);
                throw e;
            }
        }
    }

    private void processMethod(ExecutableElement method) {
        TypeElement annotationElement = this.getAnnotationReturnType(method);
        ImmutableSet<Class<?>> wrapperTypesUsedInCollections = this.wrapperTypesUsedInCollections(method);
        ImmutableMap<String, ExecutableElement> memberMethods = this.getMemberMethods(annotationElement);
        TypeElement methodClass = MoreElements.asType(method.getEnclosingElement());
        String pkg = TypeSimplifier.packageNameOf(methodClass);
        ImmutableMap<String, AnnotationValue> defaultValues = this.getDefaultValues(annotationElement);
        ImmutableMap<String, Member> members = this.getMembers(method, memberMethods);
        ImmutableMap<String, Parameter> parameters = this.getParameters(annotationElement, method, members);
        this.validateParameters(annotationElement, method, members, parameters, defaultValues);
        String generatedClassName = this.generatedClassName(method);
        AutoAnnotationTemplateVars vars = new AutoAnnotationTemplateVars();
        vars.annotationFullName = annotationElement.toString();
        vars.annotationName = TypeEncoder.encode(annotationElement.asType());
        vars.className = generatedClassName;
        vars.generated = this.getGeneratedTypeName();
        vars.members = members;
        vars.params = parameters;
        vars.equalsParameterType = this.equalsParameterType();
        vars.pkg = pkg;
        vars.wrapperTypesUsedInCollections = wrapperTypesUsedInCollections;
        vars.gwtCompatible = AutoAnnotationProcessor.isGwtCompatible(annotationElement);
        vars.serialVersionUID = AutoAnnotationProcessor.computeSerialVersionUid(members, parameters);
        ImmutableMap<String, Integer> invariableHashes = AutoAnnotationProcessor.invariableHashes(members, (ImmutableSet<String>)parameters.keySet());
        vars.invariableHashSum = 0;
        Iterator iterator = ((ImmutableCollection)invariableHashes.values()).iterator();
        while (iterator.hasNext()) {
            int h2 = (Integer)iterator.next();
            AutoAnnotationTemplateVars autoAnnotationTemplateVars = vars;
            Integer.valueOf(autoAnnotationTemplateVars.invariableHashSum + h2);
            autoAnnotationTemplateVars.invariableHashSum = autoAnnotationTemplateVars.invariableHashSum;
        }
        vars.invariableHashes = invariableHashes.keySet();
        String text = vars.toText();
        text = TypeEncoder.decode(text, this.processingEnv, pkg, annotationElement.asType());
        text = Reformatter.fixup(text);
        String fullName = AutoAnnotationProcessor.fullyQualifiedName(pkg, generatedClassName);
        this.writeSourceFile(fullName, text, methodClass);
    }

    private String getGeneratedTypeName() {
        return GeneratedAnnotations.generatedAnnotation(this.elementUtils, this.processingEnv.getSourceVersion()).map(generatedAnnotation -> TypeEncoder.encode(generatedAnnotation.asType())).orElse("");
    }

    private String equalsParameterType() {
        ImmutableList<AnnotationMirror> equalsParameterAnnotations = Nullables.fromMethods(this.processingEnv, ImmutableList.of()).nullableTypeAnnotations();
        return TypeEncoder.encodeWithAnnotations(this.javaLangObject, equalsParameterAnnotations);
    }

    private static Optional<Integer> invariableHash(AnnotationValue annotationValue) {
        Object value = annotationValue.getValue();
        if (value instanceof String || Primitives.isWrapperType(value.getClass())) {
            return Optional.of(value.hashCode());
        }
        if (value instanceof List) {
            List list = (List)value;
            return AutoAnnotationProcessor.invariableHash(list);
        }
        return Optional.empty();
    }

    private static Optional<Integer> invariableHash(List<? extends AnnotationValue> annotationValues) {
        int h2 = 1;
        for (AnnotationValue annotationValue : annotationValues) {
            Optional<Integer> maybeHash = AutoAnnotationProcessor.invariableHash(annotationValue);
            if (!maybeHash.isPresent()) {
                return Optional.empty();
            }
            h2 = h2 * 31 + maybeHash.get();
        }
        return Optional.of(h2);
    }

    private static ImmutableMap<String, Integer> invariableHashes(ImmutableMap<String, Member> members, ImmutableSet<String> parameters) {
        ImmutableMap.Builder<String, Integer> builder = ImmutableMap.builder();
        for (String element : members.keySet()) {
            Member member;
            AnnotationValue annotationValue;
            Optional<Integer> invariableHash;
            if (parameters.contains(element) || !(invariableHash = AutoAnnotationProcessor.invariableHash(annotationValue = (member = members.get(element)).method.getDefaultValue())).isPresent()) continue;
            builder.put(element, element.hashCode() * 127 ^ invariableHash.get());
        }
        return builder.build();
    }

    private boolean methodsAreOverloaded(List<ExecutableElement> methods) {
        boolean overloaded = false;
        HashSet<String> classNames = new HashSet<String>();
        for (ExecutableElement method : methods) {
            String qualifiedClassName = AutoAnnotationProcessor.fullyQualifiedName(MoreElements.getPackage(method).getQualifiedName().toString(), this.generatedClassName(method));
            if (classNames.add(qualifiedClassName)) continue;
            overloaded = true;
            this.reportError(method, "@AutoAnnotation methods cannot be overloaded", new Object[0]);
        }
        return overloaded;
    }

    private String generatedClassName(ExecutableElement method) {
        TypeElement type = MoreElements.asType(method.getEnclosingElement());
        String name = type.getSimpleName().toString();
        while (MoreElements.isType(type.getEnclosingElement())) {
            type = MoreElements.asType(type.getEnclosingElement());
            name = type.getSimpleName() + "_" + name;
        }
        return "AutoAnnotation_" + name + "_" + method.getSimpleName();
    }

    private TypeElement getAnnotationReturnType(ExecutableElement method) {
        Element returnTypeElement;
        TypeMirror returnTypeMirror = method.getReturnType();
        if (returnTypeMirror.getKind() == TypeKind.DECLARED && (returnTypeElement = this.typeUtils.asElement(method.getReturnType())).getKind() == ElementKind.ANNOTATION_TYPE) {
            return MoreElements.asType(returnTypeElement);
        }
        throw this.abortWithError(method, "Return type of @AutoAnnotation method must be an annotation type, not %s", returnTypeMirror);
    }

    private ImmutableMap<String, ExecutableElement> getMemberMethods(TypeElement annotationElement) {
        ImmutableMap.Builder<String, ExecutableElement> members = ImmutableMap.builder();
        for (ExecutableElement member : ElementFilter.methodsIn(annotationElement.getEnclosedElements())) {
            String name = member.getSimpleName().toString();
            members.put(name, member);
        }
        return members.build();
    }

    private ImmutableMap<String, Member> getMembers(Element context, ImmutableMap<String, ExecutableElement> memberMethods) {
        ImmutableMap.Builder<String, Member> members = ImmutableMap.builder();
        for (Map.Entry entry : memberMethods.entrySet()) {
            ExecutableElement memberMethod = (ExecutableElement)entry.getValue();
            String name = memberMethod.getSimpleName().toString();
            members.put(name, new Member(this.processingEnv, context, memberMethod));
        }
        return members.build();
    }

    private ImmutableMap<String, AnnotationValue> getDefaultValues(TypeElement annotationElement) {
        ImmutableMap.Builder<String, AnnotationValue> defaultValues = ImmutableMap.builder();
        for (ExecutableElement member : ElementFilter.methodsIn(annotationElement.getEnclosedElements())) {
            String name = member.getSimpleName().toString();
            AnnotationValue defaultValue = member.getDefaultValue();
            if (defaultValue == null) continue;
            defaultValues.put(name, defaultValue);
        }
        return defaultValues.build();
    }

    private ImmutableMap<String, Parameter> getParameters(TypeElement annotationElement, ExecutableElement method, Map<String, Member> members) {
        ImmutableMap.Builder<String, Parameter> parameters = ImmutableMap.builder();
        boolean error = false;
        for (VariableElement variableElement : method.getParameters()) {
            TypeMirror memberType;
            String name = variableElement.getSimpleName().toString();
            Member member = members.get(name);
            if (member == null) {
                this.reportError(variableElement, "@AutoAnnotation method parameter '%s' must have the same name as a member of %s", name, annotationElement);
                error = true;
                continue;
            }
            TypeMirror parameterType = variableElement.asType();
            if (this.compatibleTypes(parameterType, memberType = member.getTypeMirror())) {
                parameters.put(name, new Parameter(parameterType));
                continue;
            }
            this.reportError(variableElement, "@AutoAnnotation method parameter '%s' has type %s but %s.%s has type %s", name, parameterType, annotationElement, name, memberType);
            error = true;
        }
        if (error) {
            throw new AbortProcessingException();
        }
        return parameters.build();
    }

    private void validateParameters(TypeElement annotationElement, ExecutableElement method, ImmutableMap<String, Member> members, ImmutableMap<String, Parameter> parameters, ImmutableMap<String, AnnotationValue> defaultValues) {
        boolean error = false;
        for (String memberName : members.keySet()) {
            if (parameters.containsKey(memberName) || defaultValues.containsKey(memberName)) continue;
            this.reportError(method, "@AutoAnnotation method needs a parameter with name '%s' and type %s corresponding to %s.%s, which has no default value", memberName, members.get(memberName).getType(), annotationElement, memberName);
            error = true;
        }
        if (error) {
            throw new AbortProcessingException();
        }
    }

    private boolean compatibleTypes(TypeMirror parameterType, TypeMirror memberType) {
        if (this.typeUtils.isAssignable(parameterType, memberType)) {
            return true;
        }
        if (memberType.getKind() != TypeKind.ARRAY) {
            return false;
        }
        TypeMirror arrayElementType = MoreTypes.asArray(memberType).getComponentType();
        TypeMirror wrappedArrayElementType = arrayElementType.getKind().isPrimitive() ? this.typeUtils.boxedClass((PrimitiveType)arrayElementType).asType() : arrayElementType;
        TypeElement javaUtilCollection = this.elementUtils.getTypeElement(Collection.class.getCanonicalName());
        DeclaredType collectionOfElement = this.typeUtils.getDeclaredType(javaUtilCollection, wrappedArrayElementType);
        return this.typeUtils.isAssignable(parameterType, collectionOfElement);
    }

    private ImmutableSet<Class<?>> wrapperTypesUsedInCollections(ExecutableElement method) {
        TypeElement javaUtilCollection = this.elementUtils.getTypeElement(Collection.class.getName());
        ImmutableSet.Builder usedInCollections = ImmutableSet.builder();
        block0: for (Class<?> wrapper : Primitives.allWrapperTypes()) {
            DeclaredType collectionOfWrapper = this.typeUtils.getDeclaredType(javaUtilCollection, this.getTypeMirror(wrapper));
            for (VariableElement variableElement : method.getParameters()) {
                if (!this.typeUtils.isAssignable(variableElement.asType(), collectionOfWrapper)) continue;
                usedInCollections.add(wrapper);
                continue block0;
            }
        }
        return usedInCollections.build();
    }

    private TypeMirror getTypeMirror(Class<?> c) {
        return this.elementUtils.getTypeElement(c.getName()).asType();
    }

    private static boolean isGwtCompatible(TypeElement annotationElement) {
        return annotationElement.getAnnotationMirrors().stream().map(mirror -> mirror.getAnnotationType().asElement()).anyMatch(element -> element.getSimpleName().contentEquals("GwtCompatible"));
    }

    private static String fullyQualifiedName(String pkg, String cls) {
        return pkg.isEmpty() ? cls : pkg + "." + cls;
    }

    private static long computeSerialVersionUid(ImmutableMap<String, Member> members, ImmutableMap<String, Parameter> parameters) {
        String namesAndTypesString = members.entrySet().stream().filter(e -> parameters.containsKey(e.getKey())).map(e -> Maps.immutableEntry((String)e.getKey(), ((Member)e.getValue()).getType().replace("`", ""))).sorted(Comparator.comparing(Map.Entry::getKey)).map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(";"));
        return Hashing.murmur3_128().hashUnencodedChars(namesAndTypesString).asLong();
    }

    private void writeSourceFile(String className, String text, TypeElement originatingType) {
        try {
            JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile((CharSequence)className, new Element[]{originatingType});
            try (Writer writer = sourceFile.openWriter();){
                writer.write(text);
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, (CharSequence)("Could not write generated class " + className + ": " + e));
        }
    }

    public static class Parameter {
        private final String typeName;
        private final TypeKind kind;

        Parameter(TypeMirror type) {
            this.typeName = TypeEncoder.encode(type);
            this.kind = type.getKind();
        }

        public String getType() {
            return this.typeName;
        }

        public TypeKind getKind() {
            return this.kind;
        }
    }

    public static class Member {
        private final ProcessingEnvironment processingEnv;
        private final Element context;
        private final ExecutableElement method;

        Member(ProcessingEnvironment processingEnv, Element context, ExecutableElement method) {
            this.processingEnv = processingEnv;
            this.context = context;
            this.method = method;
        }

        public String toString() {
            return this.method.getSimpleName().toString();
        }

        public String getType() {
            return TypeEncoder.encode(this.getTypeMirror());
        }

        public String getComponentType() {
            Preconditions.checkState(this.getTypeMirror().getKind() == TypeKind.ARRAY);
            ArrayType arrayType = MoreTypes.asArray(this.getTypeMirror());
            return TypeEncoder.encode(arrayType.getComponentType());
        }

        public TypeMirror getTypeMirror() {
            return this.method.getReturnType();
        }

        public TypeKind getKind() {
            return this.getTypeMirror().getKind();
        }

        public int getNameHash() {
            return 127 * this.toString().hashCode();
        }

        public boolean isArrayOfClassWithBounds() {
            if (this.getTypeMirror().getKind() != TypeKind.ARRAY) {
                return false;
            }
            TypeMirror componentType = MoreTypes.asArray(this.getTypeMirror()).getComponentType();
            if (componentType.getKind() != TypeKind.DECLARED) {
                return false;
            }
            DeclaredType declared = MoreTypes.asDeclared(componentType);
            if (!MoreElements.asType(this.processingEnv.getTypeUtils().asElement(componentType)).getQualifiedName().contentEquals("java.lang.Class")) {
                return false;
            }
            if (declared.getTypeArguments().size() != 1) {
                return false;
            }
            TypeMirror parameter = declared.getTypeArguments().get(0);
            if (parameter.getKind() != TypeKind.WILDCARD) {
                return true;
            }
            WildcardType wildcard = MoreTypes.asWildcard(parameter);
            return wildcard.getSuperBound() != null || wildcard.getExtendsBound() != null;
        }

        public String getDefaultValue() {
            AnnotationValue defaultValue = this.method.getDefaultValue();
            if (defaultValue == null) {
                return null;
            }
            return AnnotationOutput.sourceFormForInitializer(defaultValue, this.processingEnv, this.method.getSimpleName().toString(), this.context);
        }
    }
}

