/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.auto.value.processor;

import com.infinite_craft.libs.autovalue.shaded.com.google.auto.common.SuperficialValidation;
import com.infinite_craft.libs.autovalue.shaded.com.google.auto.service.AutoService;
import com.infinite_craft.libs.autovalue.shaded.net.ltgt.gradle.incap.IncrementalAnnotationProcessor;
import com.infinite_craft.libs.autovalue.shaded.net.ltgt.gradle.incap.IncrementalAnnotationProcessorType;
import com.infinite_craft.libs.com.google.auto.value.processor.AutoValueishProcessor;
import com.infinite_craft.libs.javax.annotation.processing.AbstractProcessor;
import com.infinite_craft.libs.javax.annotation.processing.Processor;
import com.infinite_craft.libs.javax.annotation.processing.RoundEnvironment;
import com.infinite_craft.libs.javax.annotation.processing.SupportedAnnotationTypes;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.infinite_craft.libs.com.google.auto.value.AutoValue.Builder"})
@AutoService(value={Processor.class})
@IncrementalAnnotationProcessor(value=IncrementalAnnotationProcessorType.ISOLATING)
public class AutoValueBuilderProcessor
extends AbstractProcessor {
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        TypeElement autoValueBuilder = this.processingEnv.getElementUtils().getTypeElement("com.infinite_craft.libs.com.google.auto.value.AutoValue.Builder");
        Set builderTypes = roundEnv.getElementsAnnotatedWith(autoValueBuilder);
        if (!SuperficialValidation.validateElements(builderTypes)) {
            return false;
        }
        for (Element annotatedType : builderTypes) {
            if (!AutoValueishProcessor.hasAnnotationMirror(annotatedType, "com.infinite_craft.libs.com.google.auto.value.AutoValue.Builder")) continue;
            this.validate(annotatedType, "@AutoValue.Builder can only be applied to a class or interface inside an @AutoValue class");
        }
        return false;
    }

    private void validate(Element annotatedType, String errorMessage) {
        Element container = annotatedType.getEnclosingElement();
        if (!AutoValueishProcessor.hasAnnotationMirror(container, "com.infinite_craft.libs.com.google.auto.value.AutoValue")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, (CharSequence)errorMessage, annotatedType);
        }
    }
}

