/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.auto.value.processor;

import com.infinite_craft.libs.autovalue.shaded.com.google.errorprone.annotations.FormatMethod;
import com.infinite_craft.libs.com.google.auto.value.processor.AbortProcessingException;
import com.infinite_craft.libs.javax.annotation.processing.Messager;
import com.infinite_craft.libs.javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

class ErrorReporter {
    private final Messager messager;
    private int errorCount;

    ErrorReporter(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
    }

    @FormatMethod
    void reportNote(Element e, String format, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, (CharSequence)String.format(format, args), e);
    }

    @FormatMethod
    void reportWarning(Element e, String format, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, (CharSequence)String.format(format, args), e);
    }

    @FormatMethod
    void reportError(Element e, String format, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, (CharSequence)String.format(format, args), e);
        ++this.errorCount;
    }

    @FormatMethod
    AbortProcessingException abortWithError(Element e, String format, Object ... args) {
        this.reportError(e, format, args);
        throw new AbortProcessingException();
    }

    int errorCount() {
        return this.errorCount;
    }

    void abortIfAnyError() {
        if (this.errorCount > 0) {
            throw new AbortProcessingException();
        }
    }
}

