/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.auto.value.processor;

class JavaScanner {
    private final String s;

    JavaScanner(String s2) {
        this.s = s2.endsWith("\n") ? s2 : s2 + '\n';
    }

    String string() {
        return this.s;
    }

    int tokenEnd(int start) {
        if (start >= this.s.length()) {
            return this.s.length();
        }
        switch (this.s.charAt(start)) {
            case '\n': 
            case ' ': {
                return this.spaceEnd(start);
            }
            case '/': {
                if (this.s.charAt(start + 1) == '*') {
                    return this.blockCommentEnd(start);
                }
                if (this.s.charAt(start + 1) == '/') {
                    return this.lineCommentEnd(start);
                }
                return start + 1;
            }
            case '\"': 
            case '\'': 
            case '`': {
                return this.quoteEnd(start);
            }
        }
        return start + 1;
    }

    private int spaceEnd(int start) {
        int i;
        assert (this.s.charAt(start) == ' ' || this.s.charAt(start) == '\n');
        for (i = start + 1; i < this.s.length() && this.s.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private int blockCommentEnd(int start) {
        assert (this.s.charAt(start) == '/' && this.s.charAt(start + 1) == '*');
        int i = start + 2;
        while (this.s.charAt(i) != '*' || this.s.charAt(i + 1) != '/') {
            ++i;
        }
        return i + 2;
    }

    private int lineCommentEnd(int start) {
        assert (this.s.charAt(start) == '/' && this.s.charAt(start + 1) == '/');
        int end = this.s.indexOf(10, start + 2);
        assert (end > 0);
        return end;
    }

    private int quoteEnd(int start) {
        char quote = this.s.charAt(start);
        assert (quote == '\'' || quote == '\"' || quote == '`');
        int i = start + 1;
        while (this.s.charAt(i) != quote) {
            if (this.s.charAt(i) == '\\') {
                ++i;
            }
            ++i;
        }
        return i + 1;
    }
}

