/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.auto.value.processor;

import com.infinite_craft.libs.autovalue.shaded.com.google.common.base.CharMatcher;
import com.infinite_craft.libs.com.google.auto.value.processor.JavaScanner;

class Reformatter {
    private static final CharMatcher OPERATORS = CharMatcher.anyOf("+-*%&|^<>=?:.").precomputed();

    /*
     * Enabled aggressive block sorting
     */
    static String fixup(String s2) {
        StringBuilder out = new StringBuilder();
        JavaScanner scanner = new JavaScanner(s2);
        s2 = scanner.string();
        int len = s2.length();
        int start = 0;
        int previous = 0;
        int braces = 0;
        int parens = 0;
        int end = 0;
        while (true) {
            block19: {
                if (start >= len) {
                    return out.toString();
                }
                end = scanner.tokenEnd(start);
                switch (s2.charAt(start)) {
                    case '(': {
                        ++parens;
                        break;
                    }
                    case ')': {
                        --parens;
                        break;
                    }
                    case '{': {
                        ++braces;
                        break;
                    }
                    case '}': {
                        --braces;
                        break;
                    }
                    case ' ': {
                        if (start > 0 && s2.charAt(previous) != '(' && "\n.,;)".indexOf(s2.charAt(end)) < 0) {
                            out.append(' ');
                        }
                        break block19;
                    }
                    case '\n': {
                        if (end < len && s2.charAt(end) != '\n') {
                            char prev = s2.charAt(previous);
                            char next = s2.charAt(end);
                            if (out.length() > 0 && (prev != '(' || next != ')')) {
                                out.append('\n');
                                int indent = braces * 2;
                                if (parens > 0 || OPERATORS.matches(next)) {
                                    indent += 4;
                                } else if (next == '}') {
                                    indent -= 2;
                                }
                                for (int i = 0; i < indent; ++i) {
                                    out.append(' ');
                                }
                            }
                            break block19;
                        } else if (parens == 0 && braces < 2 && s2.charAt(previous) != '\n' && out.length() > 0) {
                            out.append('\n');
                        }
                        break block19;
                    }
                }
                out.append(s2, start, end);
            }
            previous = start;
            start = end;
        }
    }

    private Reformatter() {
    }
}

