/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.genai;

import com.infinite_craft.libs.com.fasterxml.jackson.core.type.TypeReference;
import com.infinite_craft.libs.com.fasterxml.jackson.databind.JsonNode;
import com.infinite_craft.libs.com.fasterxml.jackson.databind.node.ArrayNode;
import com.infinite_craft.libs.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.infinite_craft.libs.com.fasterxml.jackson.databind.node.ObjectNode;
import com.infinite_craft.libs.com.fasterxml.jackson.databind.node.TextNode;
import com.infinite_craft.libs.com.google.common.base.Preconditions;
import com.infinite_craft.libs.com.google.common.collect.ImmutableList;
import com.infinite_craft.libs.com.google.genai.ApiClient;
import com.infinite_craft.libs.com.google.genai.JsonSerializable;
import com.infinite_craft.libs.com.google.genai.types.Blob;
import com.infinite_craft.libs.com.google.genai.types.Content;
import com.infinite_craft.libs.com.google.genai.types.File;
import com.infinite_craft.libs.com.google.genai.types.FunctionDeclaration;
import com.infinite_craft.libs.com.google.genai.types.GeneratedVideo;
import com.infinite_craft.libs.com.google.genai.types.Part;
import com.infinite_craft.libs.com.google.genai.types.PrebuiltVoiceConfig;
import com.infinite_craft.libs.com.google.genai.types.Schema;
import com.infinite_craft.libs.com.google.genai.types.SpeechConfig;
import com.infinite_craft.libs.com.google.genai.types.Tool;
import com.infinite_craft.libs.com.google.genai.types.Video;
import com.infinite_craft.libs.com.google.genai.types.VoiceConfig;
import com.infinite_craft.libs.org.jspecify.annotations.Nullable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Transformers {
    private static final Logger logger = Logger.getLogger(Transformers.class.getName());

    private Transformers() {
    }

    public static String tModel(ApiClient apiClient, Object origin) {
        String model;
        if (origin == null) {
            return null;
        }
        if (origin instanceof String) {
            model = (String)origin;
        } else if (origin instanceof JsonNode) {
            model = JsonSerializable.toJsonString((JsonNode)origin);
            model = model.replace("\"", "");
        } else {
            throw new IllegalArgumentException("Unsupported model type: " + origin.getClass());
        }
        if (apiClient.vertexAI()) {
            if (model.startsWith("publishers/") || model.startsWith("projects/") || model.startsWith("models/")) {
                return model;
            }
            if (model.contains("/")) {
                String[] parts = model.split("/", 2);
                return String.format("publishers/%s/models/%s", parts[0], parts[1]);
            }
            return "publishers/google/models/" + model;
        }
        if (model.startsWith("models/") || model.startsWith("tunedModels/")) {
            return model;
        }
        return "models/" + model;
    }

    public static String tModelsUrl(ApiClient apiClient, @Nullable Object baseModels) {
        if (baseModels == null) {
            return apiClient.vertexAI() ? "publishers/google/models" : "models";
        }
        if (!(baseModels instanceof JsonNode)) {
            throw new IllegalArgumentException("Unsupported response type: " + baseModels.getClass());
        }
        if (((JsonNode)baseModels).asBoolean()) {
            return apiClient.vertexAI() ? "publishers/google/models" : "models";
        }
        return apiClient.vertexAI() ? "models" : "tunedModels";
    }

    public static @Nullable JsonNode tExtractModels(ApiClient apiClient, Object origin) {
        if (origin == null) {
            return null;
        }
        if (!(origin instanceof JsonNode)) {
            throw new IllegalArgumentException("Unsupported response type: " + origin.getClass());
        }
        JsonNode response = (JsonNode)origin;
        JsonNode models = response.get("models");
        if (models != null) {
            return models;
        }
        models = response.get("tunedModels");
        if (models != null) {
            return models;
        }
        models = response.get("publisherModels");
        if (models != null) {
            return models;
        }
        if (response.get("httpHeaders") == null || response.get("jsonPayload") != null) {
            logger.warning("Cannot determine the models type for response: " + response.toPrettyString());
        }
        return JsonSerializable.objectMapper.createArrayNode();
    }

    public static Object tContents(ApiClient apiClient, Object origin) {
        return origin;
    }

    public static ImmutableList<Content> tContents(String text) {
        Preconditions.checkNotNull(text, "text cannot be null");
        return ImmutableList.of(Content.fromParts(Part.fromText(text)));
    }

    public static ImmutableList<Content> tContents(Content content) {
        Preconditions.checkNotNull(content, "text cannot be null");
        return ImmutableList.of(content);
    }

    public static Content tContent(ApiClient apiClient, Object content) {
        if (content == null) {
            return null;
        }
        if (content instanceof String) {
            return Content.fromParts(Part.fromText((String)content));
        }
        if (content instanceof Content) {
            return (Content)content;
        }
        if (content instanceof JsonNode) {
            return JsonSerializable.fromJsonNode((JsonNode)content, Content.class);
        }
        throw new IllegalArgumentException("Unsupported content type: " + content.getClass());
    }

    public static Schema tSchema(ApiClient apiClient, Object origin) {
        if (origin == null) {
            return null;
        }
        if (origin instanceof Schema) {
            return (Schema)origin;
        }
        if (origin instanceof JsonNode) {
            return JsonSerializable.fromJsonNode((JsonNode)origin, Schema.class);
        }
        throw new IllegalArgumentException("Unsupported schema type: " + origin.getClass());
    }

    public static SpeechConfig tSpeechConfig(ApiClient apiClient, Object speechConfig) {
        if (speechConfig == null) {
            return null;
        }
        if (speechConfig instanceof String) {
            return SpeechConfig.builder().voiceConfig(VoiceConfig.builder().prebuiltVoiceConfig(PrebuiltVoiceConfig.builder().voiceName((String)speechConfig).build()).build()).build();
        }
        if (speechConfig instanceof SpeechConfig) {
            return (SpeechConfig)speechConfig;
        }
        if (speechConfig instanceof JsonNode) {
            return JsonSerializable.fromJsonNode((JsonNode)speechConfig, SpeechConfig.class);
        }
        throw new IllegalArgumentException("Unsupported speechConfig type:" + speechConfig.getClass());
    }

    public static @Nullable SpeechConfig tLiveSpeechConfig(ApiClient apiClient, Object origin) {
        SpeechConfig speechConfig;
        if (origin == null) {
            return null;
        }
        if (origin instanceof SpeechConfig) {
            speechConfig = (SpeechConfig)origin;
        } else if (origin instanceof JsonNode) {
            speechConfig = JsonSerializable.fromJsonNode((JsonNode)origin, SpeechConfig.class);
        } else {
            throw new IllegalArgumentException("Unsupported speechConfig type:" + origin.getClass());
        }
        if (speechConfig.multiSpeakerVoiceConfig().isPresent()) {
            throw new IllegalArgumentException("multiSpeakerVoiceConfig is not supported in the live API.");
        }
        return speechConfig;
    }

    public static Object tTools(ApiClient apiClient, Object origin) {
        return origin;
    }

    public static Tool tTool(ApiClient apiClient, Object origin) {
        if (origin == null) {
            return null;
        }
        if (origin instanceof Tool) {
            Tool tool = (Tool)origin;
            if (!tool.functions().isPresent()) {
                return tool;
            }
            ArrayList<FunctionDeclaration> combinedFunctionDeclarations = new ArrayList<FunctionDeclaration>();
            for (Method method : tool.functions().get()) {
                combinedFunctionDeclarations.add(FunctionDeclaration.fromMethod(method, new String[0]));
            }
            if (tool.functionDeclarations().isPresent()) {
                combinedFunctionDeclarations.addAll((Collection)tool.functionDeclarations().get());
            }
            ObjectNode toolNode = (ObjectNode)JsonSerializable.objectMapper.valueToTree(tool);
            toolNode.remove("functions");
            toolNode.set("functionDeclarations", (JsonNode)JsonSerializable.objectMapper.valueToTree(combinedFunctionDeclarations));
            return JsonSerializable.fromJsonNode(toolNode, Tool.class);
        }
        if (origin instanceof JsonNode) {
            return Transformers.tTool(apiClient, JsonSerializable.objectMapper.convertValue((Object)((JsonNode)origin), new TypeReference<Tool>(){}));
        }
        throw new IllegalArgumentException("Unsupported tool type: " + origin.getClass());
    }

    public static ArrayNode tBlobs(ApiClient apiClient, Object origin) {
        JsonNode inputNode;
        if (!(origin instanceof JsonNode)) {
            origin = JsonSerializable.toJsonNode(origin);
        }
        if ((inputNode = (JsonNode)origin).isArray()) {
            return (ArrayNode)inputNode;
        }
        ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
        arrayNode.add(JsonSerializable.toJsonNode(Transformers.tBlob(apiClient, origin)));
        return arrayNode;
    }

    public static Blob tBlob(ApiClient apiClient, Object blob) {
        if (blob instanceof JsonNode) {
            blob = JsonSerializable.objectMapper.convertValue((Object)((JsonNode)blob), new TypeReference<Blob>(){});
        }
        if (blob instanceof Blob) {
            return (Blob)blob;
        }
        throw new IllegalArgumentException("Unsupported blob type: " + blob.getClass());
    }

    public static Blob tImageBlob(ApiClient apiClient, Object blob) {
        Blob transformedBlob = Transformers.tBlob(apiClient, blob);
        if (transformedBlob.mimeType().isPresent() && transformedBlob.mimeType().get().startsWith("image/")) {
            return transformedBlob;
        }
        throw new IllegalArgumentException("Unsupported mime type for image blob: " + transformedBlob.mimeType().orElse("null"));
    }

    public static Blob tAudioBlob(ApiClient apiClient, Object blob) {
        Blob transformedBlob = Transformers.tBlob(apiClient, blob);
        if (transformedBlob.mimeType().isPresent() && transformedBlob.mimeType().get().startsWith("audio/")) {
            return transformedBlob;
        }
        throw new IllegalArgumentException("Unsupported mime type for audio blob: " + transformedBlob.mimeType().orElse("null"));
    }

    public static Object tBytes(ApiClient apiClient, Object origin) {
        return origin;
    }

    public static String tCachedContentName(ApiClient apiClient, Object origin) {
        if (origin == null) {
            return null;
        }
        if (origin instanceof String) {
            return Transformers.getResourceName(apiClient, (String)origin, "cachedContents");
        }
        if (origin instanceof JsonNode) {
            String cachedContentName = JsonSerializable.toJsonString((JsonNode)origin);
            cachedContentName = cachedContentName.replace("\"", "");
            return Transformers.getResourceName(apiClient, cachedContentName, "cachedContents");
        }
        throw new IllegalArgumentException("Unsupported cached content name type: " + origin.getClass());
    }

    public static @Nullable List<Object> tContentsForEmbed(ApiClient apiClient, Object origin) {
        List<Content> contents;
        if (origin == null) {
            return null;
        }
        if (origin instanceof List) {
            contents = (List<Content>)origin;
        } else if (origin instanceof JsonNode) {
            contents = JsonSerializable.objectMapper.convertValue((Object)((JsonNode)origin), new TypeReference<List<Content>>(){});
        } else {
            throw new IllegalArgumentException("Unsupported contents type: " + origin.getClass());
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Content content : contents) {
            if (!apiClient.vertexAI()) {
                result.add(content);
                continue;
            }
            for (Part part : (List)content.parts().orElse(ImmutableList.of())) {
                part.text().ifPresent(result::add);
            }
        }
        return result;
    }

    public static @Nullable String tCachesModel(ApiClient apiClient, Object origin) {
        String model = Transformers.tModel(apiClient, origin);
        if (model == null) {
            return null;
        }
        if (apiClient.vertexAI()) {
            if (model.startsWith("publishers/")) {
                return String.format("projects/%s/locations/%s/%s", apiClient.project(), apiClient.location(), model);
            }
            if (model.startsWith("models/")) {
                return String.format("projects/%s/locations/%s/publishers/google/%s", apiClient.project(), apiClient.location(), model);
            }
        }
        return model;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static @Nullable String tFileName(ApiClient apiClient, Object origin) {
        String name = null;
        if (origin instanceof String) {
            name = (String)origin;
        } else if (origin instanceof File) {
            name = ((File)origin).name().orElseThrow(() -> new IllegalArgumentException("File name is required."));
        } else if (origin instanceof Video) {
            name = ((Video)origin).uri().orElse(null);
            if (name == null) {
                return null;
            }
        } else if (origin instanceof GeneratedVideo) {
            Video video = ((GeneratedVideo)origin).video().orElseThrow(() -> new IllegalArgumentException("Video is required."));
            name = video.uri().orElse(null);
            if (name == null) {
                return null;
            }
        } else {
            if (!(origin instanceof TextNode)) throw new IllegalArgumentException("Unsupported file name type: " + origin.getClass());
            name = ((TextNode)origin).textValue();
        }
        if (name.startsWith("https://")) {
            String suffix = name.split("files/")[1];
            Pattern pattern = Pattern.compile("[a-z0-9]+");
            Matcher matcher = pattern.matcher(suffix);
            if (!matcher.find()) throw new IllegalArgumentException("Could not extract file name from " + name);
            return matcher.group();
        }
        if (!name.startsWith("files/")) return name;
        return name.split("files/")[1];
    }

    private static String getResourceName(ApiClient apiClient, String resourceName, String resourcePrefix) {
        if (apiClient.vertexAI()) {
            if (resourceName.startsWith("projects/")) {
                return resourceName;
            }
            if (resourceName.startsWith("locations/")) {
                return String.format("projects/%s/%s", apiClient.project(), resourceName);
            }
            if (resourceName.startsWith(resourcePrefix + "/")) {
                return String.format("projects/%s/locations/%s/%s", apiClient.project(), apiClient.location(), resourceName);
            }
            return String.format("projects/%s/locations/%s/%s/%s", apiClient.project(), apiClient.location(), resourcePrefix, resourceName);
        }
        if (resourceName.startsWith(resourcePrefix + "/")) {
            return resourceName;
        }
        return String.format("%s/%s", resourcePrefix, resourceName);
    }
}

