/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.genai;

import com.infinite_craft.libs.com.google.common.collect.ImmutableMap;
import com.infinite_craft.libs.com.google.genai.ApiClient;
import com.infinite_craft.libs.com.google.genai.ApiResponse;
import com.infinite_craft.libs.com.google.genai.errors.GenAiIOException;
import com.infinite_craft.libs.com.google.genai.types.HttpOptions;
import com.infinite_craft.libs.org.apache.http.Header;
import com.infinite_craft.libs.org.apache.http.HttpEntity;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;

final class UploadClient {
    private final ApiClient apiClient;
    private final int chunkSize;
    public static final int DEFAULT_CHUNK_SIZE = 0x800000;
    public static final int MAX_RETRY_COUNT = 3;
    public static final Duration INITIAL_RETRY_DELAY = Duration.ofSeconds(1L);
    public static final int DELAY_MULTIPLIER = 2;

    public UploadClient(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.chunkSize = 0x800000;
    }

    public UploadClient(ApiClient apiClient, int chunkSize) {
        this.apiClient = apiClient;
        this.chunkSize = chunkSize;
    }

    public HttpEntity upload(String uploadUrl, String filePath) {
        HttpEntity entity;
        File file = new File(filePath);
        try (FileInputStream inputStream = new FileInputStream(file);){
            entity = this.upload(uploadUrl, inputStream, file.length());
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to process input stream", e);
        }
        return entity;
    }

    public HttpEntity upload(String uploadUrl, byte[] bytes) {
        HttpEntity entity;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            entity = this.upload(uploadUrl, inputStream, bytes.length);
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to process input stream", e);
        }
        return entity;
    }

    public HttpEntity upload(String uploadUrl, InputStream inputStream, long size) {
        String uploadStatus;
        UploadChunkResponse uploadChunkResponse;
        int bytesRead;
        String uploadCommand = "upload";
        byte[] buffer = new byte[this.chunkSize];
        int offset = 0;
        try {
            while ((bytesRead = inputStream.read(buffer, 0, this.chunkSize)) == this.chunkSize) {
                uploadChunkResponse = this.uploadChunk(uploadUrl, buffer, offset, uploadCommand);
                uploadStatus = uploadChunkResponse.getUploadStatus();
                offset += bytesRead;
                if (uploadStatus != null && uploadStatus.equals("active")) continue;
                throw new IllegalStateException("Unexpected upload status: " + uploadStatus + " please try again.");
            }
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to process input stream", e);
        }
        buffer = Arrays.copyOfRange(buffer, 0, bytesRead);
        uploadCommand = uploadCommand + ", finalize";
        uploadChunkResponse = this.uploadChunk(uploadUrl, buffer, offset, uploadCommand);
        uploadStatus = uploadChunkResponse.getUploadStatus();
        if (uploadStatus == null || !uploadStatus.equals("final")) {
            throw new IllegalStateException("Unexpected final upload status: " + uploadStatus + " please try again.");
        }
        return uploadChunkResponse.getEntity();
    }

    private UploadChunkResponse uploadChunk(String uploadUrl, byte[] chunk, long offset, String uploadCommand) {
        HttpOptions httpOptions = HttpOptions.builder().headers(ImmutableMap.of("X-Goog-Upload-Command", uploadCommand, "X-Goog-Upload-Offset", Long.toString(offset))).build();
        boolean uploadStatusHeaderFound = false;
        String uploadStatus = "";
        ApiResponse response = null;
        for (int retryCount = 0; retryCount < 3; ++retryCount) {
            Header[] headers;
            response = this.apiClient.request("POST", uploadUrl, chunk, Optional.of(httpOptions));
            for (Header header : headers = response.getHeaders()) {
                if (!header.getName().equals("X-Goog-Upload-Status")) continue;
                uploadStatusHeaderFound = true;
                uploadStatus = header.getValue();
                break;
            }
            if (uploadStatusHeaderFound) break;
            Duration delay = INITIAL_RETRY_DELAY.multipliedBy((long)Math.pow(2.0, retryCount));
            try {
                Thread.sleep(delay.toMillis());
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted while sleeping", e);
            }
        }
        if (!uploadStatusHeaderFound) {
            throw new IllegalStateException("Upload failed. Retries exhausted, please try again.");
        }
        return new UploadChunkResponse(uploadStatus, response.getEntity());
    }

    private static class UploadChunkResponse {
        private final String uploadStatus;
        private final HttpEntity entity;

        UploadChunkResponse(String uploadStatus, HttpEntity entity) {
            this.uploadStatus = uploadStatus;
            this.entity = entity;
        }

        public String getUploadStatus() {
            return this.uploadStatus;
        }

        public HttpEntity getEntity() {
            return this.entity;
        }
    }
}

