/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.com.google.genai.types;

import com.infinite_craft.libs.com.fasterxml.jackson.annotation.JsonCreator;
import com.infinite_craft.libs.com.fasterxml.jackson.annotation.JsonProperty;
import com.infinite_craft.libs.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.infinite_craft.libs.com.google.auto.value.AutoValue;
import com.infinite_craft.libs.com.google.common.collect.ImmutableList;
import com.infinite_craft.libs.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.infinite_craft.libs.com.google.genai.JsonSerializable;
import com.infinite_craft.libs.com.google.genai.types.AudioTranscriptionConfig;
import com.infinite_craft.libs.com.google.genai.types.AutoValue_LiveConnectConfig;
import com.infinite_craft.libs.com.google.genai.types.Content;
import com.infinite_craft.libs.com.google.genai.types.ContextWindowCompressionConfig;
import com.infinite_craft.libs.com.google.genai.types.HttpOptions;
import com.infinite_craft.libs.com.google.genai.types.MediaResolution;
import com.infinite_craft.libs.com.google.genai.types.Modality;
import com.infinite_craft.libs.com.google.genai.types.ProactivityConfig;
import com.infinite_craft.libs.com.google.genai.types.RealtimeInputConfig;
import com.infinite_craft.libs.com.google.genai.types.SessionResumptionConfig;
import com.infinite_craft.libs.com.google.genai.types.SpeechConfig;
import com.infinite_craft.libs.com.google.genai.types.Tool;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class LiveConnectConfig
extends JsonSerializable {
    @JsonProperty(value="httpOptions")
    public abstract Optional<HttpOptions> httpOptions();

    @JsonProperty(value="responseModalities")
    public abstract Optional<List<Modality>> responseModalities();

    @JsonProperty(value="temperature")
    public abstract Optional<Float> temperature();

    @JsonProperty(value="topP")
    public abstract Optional<Float> topP();

    @JsonProperty(value="topK")
    public abstract Optional<Float> topK();

    @JsonProperty(value="maxOutputTokens")
    public abstract Optional<Integer> maxOutputTokens();

    @JsonProperty(value="mediaResolution")
    public abstract Optional<MediaResolution> mediaResolution();

    @JsonProperty(value="seed")
    public abstract Optional<Integer> seed();

    @JsonProperty(value="speechConfig")
    public abstract Optional<SpeechConfig> speechConfig();

    @JsonProperty(value="enableAffectiveDialog")
    public abstract Optional<Boolean> enableAffectiveDialog();

    @JsonProperty(value="systemInstruction")
    public abstract Optional<Content> systemInstruction();

    @JsonProperty(value="tools")
    public abstract Optional<List<Tool>> tools();

    @JsonProperty(value="sessionResumption")
    public abstract Optional<SessionResumptionConfig> sessionResumption();

    @JsonProperty(value="inputAudioTranscription")
    public abstract Optional<AudioTranscriptionConfig> inputAudioTranscription();

    @JsonProperty(value="outputAudioTranscription")
    public abstract Optional<AudioTranscriptionConfig> outputAudioTranscription();

    @JsonProperty(value="realtimeInputConfig")
    public abstract Optional<RealtimeInputConfig> realtimeInputConfig();

    @JsonProperty(value="contextWindowCompression")
    public abstract Optional<ContextWindowCompressionConfig> contextWindowCompression();

    @JsonProperty(value="proactivity")
    public abstract Optional<ProactivityConfig> proactivity();

    public static Builder builder() {
        return new AutoValue_LiveConnectConfig.Builder();
    }

    public abstract Builder toBuilder();

    public static LiveConnectConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, LiveConnectConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_LiveConnectConfig.Builder();
        }

        @JsonProperty(value="httpOptions")
        public abstract Builder httpOptions(HttpOptions var1);

        @JsonProperty(value="responseModalities")
        public abstract Builder responseModalities(List<Modality> var1);

        @CanIgnoreReturnValue
        public Builder responseModalitiesFromKnown(List<Modality.Known> knownTypes) {
            ImmutableList<Modality> listItems = knownTypes.stream().map(Modality::new).collect(ImmutableList.toImmutableList());
            return this.responseModalities(listItems);
        }

        @CanIgnoreReturnValue
        public Builder responseModalitiesFromString(List<String> responseModalities) {
            ImmutableList<Modality> listItems = responseModalities.stream().map(Modality::new).collect(ImmutableList.toImmutableList());
            return this.responseModalities(listItems);
        }

        @JsonProperty(value="temperature")
        public abstract Builder temperature(Float var1);

        @JsonProperty(value="topP")
        public abstract Builder topP(Float var1);

        @JsonProperty(value="topK")
        public abstract Builder topK(Float var1);

        @JsonProperty(value="maxOutputTokens")
        public abstract Builder maxOutputTokens(Integer var1);

        @JsonProperty(value="mediaResolution")
        public abstract Builder mediaResolution(MediaResolution var1);

        @CanIgnoreReturnValue
        public Builder mediaResolution(MediaResolution.Known knownType) {
            return this.mediaResolution(new MediaResolution(knownType));
        }

        @CanIgnoreReturnValue
        public Builder mediaResolution(String mediaResolution) {
            return this.mediaResolution(new MediaResolution(mediaResolution));
        }

        @JsonProperty(value="seed")
        public abstract Builder seed(Integer var1);

        @JsonProperty(value="speechConfig")
        public abstract Builder speechConfig(SpeechConfig var1);

        @JsonProperty(value="enableAffectiveDialog")
        public abstract Builder enableAffectiveDialog(boolean var1);

        @JsonProperty(value="systemInstruction")
        public abstract Builder systemInstruction(Content var1);

        @JsonProperty(value="tools")
        public abstract Builder tools(List<Tool> var1);

        @JsonProperty(value="sessionResumption")
        public abstract Builder sessionResumption(SessionResumptionConfig var1);

        @JsonProperty(value="inputAudioTranscription")
        public abstract Builder inputAudioTranscription(AudioTranscriptionConfig var1);

        @JsonProperty(value="outputAudioTranscription")
        public abstract Builder outputAudioTranscription(AudioTranscriptionConfig var1);

        @JsonProperty(value="realtimeInputConfig")
        public abstract Builder realtimeInputConfig(RealtimeInputConfig var1);

        @JsonProperty(value="contextWindowCompression")
        public abstract Builder contextWindowCompression(ContextWindowCompressionConfig var1);

        @JsonProperty(value="proactivity")
        public abstract Builder proactivity(ProactivityConfig var1);

        public abstract LiveConnectConfig build();
    }
}

