/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.libs.io.opencensus.trace;

import com.infinite_craft.libs.io.opencensus.internal.Utils;
import com.infinite_craft.libs.io.opencensus.trace.AttributeValue;
import com.infinite_craft.libs.io.opencensus.trace.AutoValue_Annotation;
import com.infinite_craft.libs.javax.annotation.concurrent.Immutable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Immutable
public abstract class Annotation {
    private static final Map<String, AttributeValue> EMPTY_ATTRIBUTES = Collections.unmodifiableMap(Collections.emptyMap());

    public static Annotation fromDescription(String description) {
        return new AutoValue_Annotation(description, EMPTY_ATTRIBUTES);
    }

    public static Annotation fromDescriptionAndAttributes(String description, Map<String, AttributeValue> attributes) {
        return new AutoValue_Annotation(description, Collections.unmodifiableMap(new HashMap<String, AttributeValue>(Utils.checkNotNull(attributes, "attributes"))));
    }

    public abstract String getDescription();

    public abstract Map<String, AttributeValue> getAttributes();

    Annotation() {
    }
}

