/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.process;

import com.infinite_craft.InfiniteCraft;
import com.infinite_craft.libs.com.google.genai.Client;
import com.infinite_craft.libs.com.google.genai.types.GenerateContentResponse;
import com.infinite_craft.libs.com.google.gson.JsonObject;
import com.infinite_craft.libs.com.google.gson.JsonParser;
import com.infinite_craft.process.AiProblemException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_3222;

public class AiApi {
    public static JsonObject doPost(String prompt, class_3222 player) throws IOException, RuntimeException {
        switch (InfiniteCraft.config.ModelType) {
            case "none": {
                throw new AiProblemException("Unable to run the model because it's disabled in the config file(.\"model\")");
            }
            case "gemini": {
                return AiApi.doPostGemini(prompt, player);
            }
            case "ollama": {
                return AiApi.doPostOllama(prompt);
            }
        }
        throw new AiProblemException("IDK why but this isn't supposed to happen");
    }

    public static JsonObject doPostGemini(String prompt, class_3222 player) throws IOException, RuntimeException {
        try {
            Client geminiClient = InfiniteCraft.gemini.getClient(player);
            if (geminiClient == null) {
                throw new AiProblemException("Gemini is not initialized");
            }
            GenerateContentResponse response = geminiClient.models.generateContent("gemini-2.5-flash", prompt, InfiniteCraft.gemini.getConfig(player));
            return JsonParser.parseString(response.text()).getAsJsonObject();
        }
        catch (Exception e) {
            InfiniteCraft.LOGGER.error(e.getMessage());
            throw e;
        }
    }

    /*
     * Loose catch block
     */
    public static JsonObject doPostOllama(String prompt) throws IOException, RuntimeException {
        String urlStr = "http://localhost:11434/api/generate";
        URL url = URI.create(urlStr).toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        JsonObject body = JsonParser.parseString("{\n\t\"model\": \"deepseek-r1:8b\",\n\t\"format\": {\n\t\t\"type\": \"object\",\n\t\t\"properties\": {\n\t\t\t\"itemNbt\": {\"type\": \"string\"},\n\t\t\t\"success\": {\"type\": \"boolean\"}\n\t\t},\n\t\t\"required\": [\"itemNbt\", \"success\"]\n\t},\n\t\"stream\": false\n}\n").getAsJsonObject();
        body.addProperty("prompt", prompt);
        try (OutputStream os = conn.getOutputStream();){
            os.write(body.toString().getBytes(StandardCharsets.UTF_8));
        }
        try (InputStream is = conn.getInputStream();){
            try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                JsonObject jsonObject = JsonParser.parseString(JsonParser.parseReader(reader).getAsJsonObject().get("response").getAsString()).getAsJsonObject();
                return jsonObject;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }
}

