/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.process;

import com.infinite_craft.networking.InfiniteCraftNetworking;
import java.util.WeakHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_3222;

public class InfiniteCraftFakeProgressTask {
    private static final WeakHashMap<class_3222, TaskState> activeTasks = new WeakHashMap();

    public static void start(class_3222 player, double start, double end, int expectedTicks) {
        TaskState state = new TaskState(start, end, expectedTicks);
        activeTasks.put(player, state);
    }

    public static void registerTickHandler() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            activeTasks.forEach((player, state) -> {
                if (state.ticksElapsed >= state.expectedTicks) {
                    return;
                }
                ++state.ticksElapsed;
                int progress = (int)state.interpolate();
                if (progress != state.lastProgress) {
                    InfiniteCraftNetworking.sendArrowProgress(player, progress);
                    state.lastProgress = progress;
                }
            });
            activeTasks.entrySet().removeIf(entry -> ((TaskState)entry.getValue()).ticksElapsed >= ((TaskState)entry.getValue()).expectedTicks);
        });
    }

    private static double interpolate(double start, double end, double t2) {
        return start + (end - start) * t2;
    }

    public static void interrupt(class_3222 player) {
        TaskState state = activeTasks.get(player);
        if (state != null) {
            InfiniteCraftNetworking.sendArrowProgress(player, (int)state.end);
            activeTasks.remove(player);
        }
    }

    public static double getProgress(class_3222 player) {
        TaskState state = activeTasks.get(player);
        if (state != null) {
            return state.interpolate();
        }
        return 0.0;
    }

    private static class TaskState {
        final double start;
        final double end;
        final int expectedTicks;
        int ticksElapsed = 0;
        int lastProgress = -1;

        TaskState(double start, double end, int expectedTicks) {
            this.start = start;
            this.end = end;
            this.expectedTicks = expectedTicks;
        }

        public double interpolate() {
            return InfiniteCraftFakeProgressTask.interpolate(this.start, this.end, (double)this.ticksElapsed / (double)this.expectedTicks);
        }
    }
}

