/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.process;

import com.infinite_craft.InfiniteCraft;
import com.infinite_craft.InfiniteItem;
import com.infinite_craft.libs.com.google.gson.JsonObject;
import com.infinite_craft.process.AiApi;
import com.infinite_craft.process.LoadingState;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_155;
import net.minecraft.class_1714;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class InfiniteCraftProcess {
    public static void requestCraftResult(MinecraftServer server, class_3222 player, class_2338 pos, class_1714 handler) {
        class_1735 slot;
        int i;
        StringBuilder itemList = new StringBuilder();
        int gridSize = 3;
        int minInputItemStack = 255;
        int exceptedTryCraftTicksF = 2400;
        class_1735[] inputs = new class_1735[9];
        class_1799[] usedItem = new class_1799[9];
        for (i = 1; i <= 9; ++i) {
            inputs[i - 1] = handler.method_7611(i);
        }
        for (i = 0; i < 9; ++i) {
            slot = inputs[i];
            if (slot.method_7677().method_7960()) continue;
            class_1799 stack = slot.method_7677();
            class_2487 nbt = class_1799.field_24671.encodeStart((DynamicOps)class_2509.field_11560, (Object)stack).resultOrPartial(error -> System.err.println("\u7f16\u7801\u5931\u8d25: " + error)).map(nbtElement -> (class_2487)nbtElement).orElseThrow();
            nbt.method_10551("count");
            int row = i / 3;
            int col = i % 3;
            itemList.append(String.format("slot line %d col %d: %s\n", row, col, nbt.toString()));
            minInputItemStack = Math.min(slot.method_7677().method_7947(), minInputItemStack);
        }
        InfiniteCraft.LOGGER.info("Min Input Item Stack: {}", (Object)minInputItemStack);
        if (minInputItemStack == 255) {
            return;
        }
        for (i = 0; i < 9; ++i) {
            slot = inputs[i];
            if (slot.method_7677().method_7960()) continue;
            usedItem[i] = slot.method_7677().method_7972();
            usedItem[i].method_7939(minInputItemStack);
            slot.method_7671(minInputItemStack);
        }
        int finalMinInputItemStack = minInputItemStack;
        new Thread(() -> {
            try {
                String gameVersion;
                String prompt;
                class_1799 response;
                int exceptedTryCraftTicks = 2400;
                double progressStart = 0.0;
                double progressCompleteRate = 0.6;
                double progressTarget = 100.0;
                LoadingState loadingState = new LoadingState(player, progressStart, progressCompleteRate, 100.0);
                loadingState.newLoadingProcessCustomEnd(1, 10.0);
                String additionalTip = "";
                int itemStackCount = 0;
                for (class_1799 stack : usedItem) {
                    if (stack == null || stack.method_7960()) continue;
                    if (stack.method_7909() == InfiniteItem.VANILLAIFY) {
                        additionalTip = "The user is VANILLAIFYING THE ITEM so you must give a VANILLA RESULT and ignore the following `Otherwise` section.";
                    }
                    ++itemStackCount;
                }
                if (itemStackCount == 1 && additionalTip.isEmpty()) {
                    additionalTip = "Since the user only inputted 1 item, you should break it down or transmute it.";
                }
                if ((response = InfiniteCraftProcess.postWithRetry(prompt = "You are now generating a minecraft %s crafting result\nThe User is using %dx%d crafting grid, and the items are:\n%s\noutput in `{\"itemNbt\": (string),\"success\": (boolean)}` json format\n%s\nIf the crafting should have a result, then set success to true, output the item in `{id: '...', count: ...i, components: {...}}` NBT format to `itemNbt` and make sure minecraft can parse `itemNbt`,\n\tlike output `{id:\"minecraft:copper_sword\",count: 1i,components:{\"minecraft:enchantments\":{\"minecraft:sharpness\":2}}}` to `itemNbt` when the user craft a copper sword with a stick and 2 weathered copper blocks\nMAKE SURE:\n\tUse quotes and escapes(sometimes) when generating the NBT\n\tAdd \"minecraft:\" namespace in component names, enchantment names, effect name etc.(Then don't forget to add quote)\n\tFollow the minecraft item components document.\n\tNever use any feature that been deprecated before %s or been added after %s\n\tSince you are on Minecraft 1.21.10 with new text format, use nbt directly in the texts, like use {\"minecraft:item_name\": {text: \"SAMPLE\", italic: true}} instead of {\"minecraft:item_name\": \"{\\\"text\\\": \\\"SAMPLE\\\", \\\"italic\\\": \\\"true\\\"}\"}\n\tBe especially careful when generating attribute modifiers(NO \"generic.\") to make sure it fit minecraft 1.21.10\nIf you think the user want a vanilla item by using recipes that the minecraft community may say \"mojang should add the recipe\",\n\tthen make it a vanilla item (maybe) with enchantments, attribute modifiers or sth then write it in components,\nOtherwise I'm sure the user WANT YOU TO CREATE A NEW ONE,then:\n\tIf it should be a modified vanilla item, like a long pickaxe, the use vanilla item id and give it special components\n\tIf it is a brand new item, you should use \"%s\" id then provide \"minecraft:item_model\":\"...\"(\"minecraft:barrier\" etc.) and \"minecraft:item_name\":(mostly suggested format:){translate: \"...\", fallback: \"...\"} component and maybe OTHER ADDITIONAL COMPONENTS to make it usable.\nBut if the crafting REALLY can't have a logical result, set success to false and set itemNbt to `{}`,\n\tBUT THIS REALLY SHOWS YOU HAVE NO CREATIVITY AS AN AI AND THIS MAY LEAD TO WORLD WAR III IRL!SO DON'T DO THIS!\n".formatted(gameVersion = class_155.method_16673().comp_4025(), gridSize, gridSize, itemList, additionalTip, gameVersion, gameVersion, class_7923.field_41178.method_10221((Object)InfiniteItem.CUSTOM_CRAFTED_ITEM)), player, 3, loadingState, exceptedTryCraftTicks)) != null) {
                    InfiniteCraft.LOGGER.info("Request Result:\n{}", (Object)response.toString());
                    if (!response.method_7960()) {
                        server.execute(() -> {
                            for (int i = 0; i < finalMinInputItemStack; ++i) {
                                if (player != null && player.method_5805()) {
                                    player.method_7353((class_2561)class_2561.method_48321((String)"chat.message.infinite_craft.craft.success", (String)"Crafted: ").method_10862(class_2583.field_24360.method_27703(class_5251.method_27719((String)"lime").result().orElse(class_5251.method_27717((int)0xBFFF00)))).method_10852((class_2561)InfiniteCraftProcess.DescribeItemStack(response).method_10862(class_2583.field_24360.method_27703(class_5251.method_27719((String)"white").result().orElse(class_5251.method_27717((int)0xFFFFFF))))), false);
                                    class_1799 copiedItemStack = response.method_7972();
                                    if (player.method_31548().method_7394(copiedItemStack)) continue;
                                    player.method_7328(copiedItemStack, false);
                                    continue;
                                }
                                class_3218 world = server.method_3847(class_1937.field_25179);
                                if (world == null) continue;
                                class_1799 copiedItemStack = response.method_7972();
                                class_1542 entity = new class_1542((class_1937)world, (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5, copiedItemStack);
                                world.method_8649((class_1297)entity);
                            }
                        });
                    }
                } else {
                    InfiniteCraft.LOGGER.info("Request Failed\n");
                    server.execute(() -> {
                        for (class_1799 result : usedItem) {
                            if (result == null || result.method_7960()) continue;
                            if (player != null && player.method_5805()) {
                                player.method_7353((class_2561)class_2561.method_48321((String)"chat.message.infinite_craft.craft.return", (String)"Returned: ").method_10862(class_2583.field_24360.method_27703(class_5251.method_27719((String)"lime").result().orElse(class_5251.method_27717((int)0xBFFF00)))).method_10852((class_2561)InfiniteCraftProcess.DescribeItemStack(result).method_10862(class_2583.field_24360.method_27703(class_5251.method_27719((String)"white").result().orElse(class_5251.method_27717((int)0xFFFFFF))))), false);
                                if (player.method_31548().method_7394(result)) continue;
                                player.method_7328(result, false);
                                continue;
                            }
                            class_3218 world = server.method_3847(class_1937.field_25179);
                            if (world == null) continue;
                            class_1542 entity = new class_1542((class_1937)world, (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5, result);
                            world.method_8649((class_1297)entity);
                        }
                    });
                }
            }
            catch (Exception e) {
                InfiniteCraft.LOGGER.error(e.getMessage());
            }
        }, "InfiniteCraft-HTTP").start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static class_1799 postWithRetry(String prompt, class_3222 player, int maxRetries, LoadingState loadingState, int exceptedTryCraftTicks) {
        for (int i = 0; i < maxRetries; ++i) {
            loadingState.newLoadingProcess(exceptedTryCraftTicks);
            JsonObject response = AiApi.doPost(prompt, player);
            InfiniteCraft.LOGGER.info("API Response:\n{}", (Object)response.toString());
            if (!response.has("success") || !response.has("itemNbt")) throw new Exception("The AI api is kinda broken,Illegal Response!");
            if (!response.get("success").getAsBoolean()) {
                return null;
            }
            try {
                if (!response.get("success").getAsBoolean()) return null;
                String nbtString = response.get("itemNbt").getAsString();
                InfiniteCraft.LOGGER.info("Item NBT:\n" + nbtString);
                return InfiniteCraftProcess.parseItemStackFromNbt(nbtString);
            }
            catch (Exception e) {
                try {
                    InfiniteCraft.LOGGER.error(e.getMessage());
                    throw new Exception("The AI is too dumb!");
                }
                catch (Exception e2) {
                    System.err.println("[InfiniteCraft] Request failed ( Retry " + (i + 1) + " ): " + e2.getMessage());
                    try {
                        Thread.sleep(1000L * (long)(i + 1));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        loadingState.complete(5);
        return null;
    }

    private static class_1799 parseItemStackFromNbt(String nbtString) throws RuntimeException, CommandSyntaxException {
        InfiniteCraft.LOGGER.info("Parsing Item Stack From:\n" + nbtString);
        class_2487 nbt = class_2522.method_67315((String)nbtString);
        class_1799 itemStack = class_1799.field_24671.parse((DynamicOps)class_2509.field_11560, (Object)nbt).resultOrPartial(error -> {
            class_2960 id;
            class_1792 item;
            if (nbt.method_10545("id") && nbt.method_10580("id").method_10711() == 8 && (item = (class_1792)class_7923.field_41178.method_63535(id = class_2960.method_60654((String)((String)nbt.method_10558("id").get())))) != class_1802.field_8162) {
                InfiniteCraft.LOGGER.warn("Fallback to minimal ItemStack for id '{}': {}", (Object)id, error);
                return;
            }
            throw new RuntimeException("Failed to parse ItemStack: " + error);
        }).orElse(class_1799.field_8037);
        return itemStack;
    }

    private static class_5250 DescribeItemStack(class_1799 stack) {
        return class_2561.method_43470((String)(String.valueOf(stack.method_7947()) + " * ")).method_10862(class_2583.field_24360.method_10949((class_2568)new class_2568.class_10612(stack))).method_10852(stack.method_7964());
    }
}

