/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft;

import com.infinite_craft.InfiniteCraftConfig;
import com.infinite_craft.InfiniteItem;
import com.infinite_craft.ai.Gemini;
import com.infinite_craft.element.DiscoveringPlayerData;
import com.infinite_craft.element.ElementItems;
import com.infinite_craft.element.globaldata.GlobalDiscoveringData;
import com.infinite_craft.element.globaldata.GlobalDiscoveringDataManager;
import com.infinite_craft.libs.org.slf4j.Logger;
import com.infinite_craft.libs.org.slf4j.LoggerFactory;
import com.infinite_craft.networking.SendArrowProgressS2CPayload;
import com.infinite_craft.process.InfiniteCraftFakeProgressTask;
import java.io.IOException;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;

public class InfiniteCraft
implements ModInitializer {
    public static final String MOD_ID = "infinite_craft";
    public static final Logger LOGGER = LoggerFactory.getLogger("infinite_craft");
    public static Gemini gemini = null;
    public static InfiniteCraftConfig config = null;

    public void onInitialize() {
        try {
            config = new InfiniteCraftConfig();
            config.load();
            config.write();
        }
        catch (IOException e) {
            LOGGER.error("Failed to read the config of infinite-craft!");
        }
        LOGGER.info("config: {}", (Object)config.toString());
        gemini = new Gemini();
        InfiniteItem.initialize();
        ElementItems.initialize();
        PayloadTypeRegistry.playS2C().register(SendArrowProgressS2CPayload.ID, SendArrowProgressS2CPayload.CODEC);
        InfiniteCraftFakeProgressTask.registerTickHandler();
        config.write();
        gemini.initClient(config);
        DiscoveringPlayerData.register();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            GlobalDiscoveringData globalData = GlobalDiscoveringDataManager.get(server);
            LOGGER.info("[InfiniteCraft] Loaded global discovered_elements data with {} entries.", (Object)globalData.getDiscovered().getData().size());
        });
        ServerLifecycleEvents.BEFORE_SAVE.register((server, flush, force) -> {
            GlobalDiscoveringDataManager.markDirty(server);
            LOGGER.info("[InfiniteCraft] Auto-saved GlobalDiscoveringData.");
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            LOGGER.info("[InfiniteCraft] Saving discovered_elements...");
            GlobalDiscoveringDataManager.markDirty(server);
        });
    }

    @Deprecated
    public void InitializeOpenAIClient(String apiKey) {
    }
}

