/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft;

import com.infinite_craft.InfiniteCraft;
import com.infinite_craft.libs.com.google.gson.Gson;
import com.infinite_craft.libs.com.google.gson.GsonBuilder;
import com.infinite_craft.libs.com.google.gson.JsonObject;
import com.infinite_craft.libs.com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import java.util.Set;

public class InfiniteCraftConfig {
    public String GeminiApiKey = null;
    public String GeminiModelName = null;
    public String ModelProxy = "none";
    public String ModelType = "none";
    public String Language = "en-US";
    public final JsonObject defaultConfig = JsonParser.parseString("{\n    \"gemini\": {\n        \"api_key\": null,\n        \"model\": \"\",\n        \"note\": [\n            \"Gemini API Is Currently Free!\",\n            \"the `model` can be: \",\n            \"    gemini-2.5-flash\",\n            \"    gemini-2.5-flash-lite\",\n            \"    or any other ones in https://ai.google.dev/gemini-api/docs/models\",\n            \"For API key, generate here: https://aistudio.google.com/api-keys\"\n        ]\n    },\n    \"proxy\": \"none\",\n    \"model\": \"gemini\",\n    \"lang\": \"en-US\",\n    \"description\": {\n        \"proxy\": \"Proxy type, could be (none, system)\",\n        \"model\": \"The model to use, could be (none, gemini, ollama), use none if you only use the mod as a player of a server\",\n        \"gemini\": \"The gemini config\",\n        \"lang\": \"The language of the result, should be a language code: https://en.wikipedia.org/wiki/List_of_ISO_639_language_codes, but you actually can use the language name\",\n        \"!!!\": \"This file will be overridden, so please save your important information somewhere else!\"\n    }\n}\n").getAsJsonObject();

    public void load() throws IOException {
        File configFile = this.getConfigFile();
        if (!configFile.exists()) {
            this.createFile(configFile);
        }
        try (FileReader reader = new FileReader(configFile);){
            Gson gson = new Gson();
            JsonObject json = gson.fromJson((Reader)reader, JsonObject.class);
            if (json.has("gemini") && json.get("gemini").isJsonObject()) {
                JsonObject gemeniConfig = json.get("gemini").getAsJsonObject();
                this.GeminiApiKey = this.readStringFromObject(gemeniConfig, "api_key");
                this.GeminiModelName = this.readStringFromObject(gemeniConfig, "model");
                if (this.GeminiModelName == null) {
                    this.GeminiModelName = "gemini-2.5-flash";
                }
            }
            this.ModelProxy = KeyNames.Proxy.get(this.readStringFromObject(json, KeyNames.Proxy.name));
            this.ModelType = KeyNames.ModelType.get(this.readStringFromObject(json, KeyNames.ModelType.name));
            this.Language = Optional.ofNullable(this.readStringFromObject(json, "lang")).orElse("en-US");
        }
        catch (IOException e) {
            InfiniteCraft.LOGGER.error(e.getMessage());
            throw e;
        }
    }

    private String readStringFromObject(JsonObject object, String key) {
        return object.has(key) && object.get(key).isJsonPrimitive() && object.get(key).getAsJsonPrimitive().isString() ? object.get(key).getAsString() : null;
    }

    public void write() {
        File configFile = this.getConfigFile();
        if (!configFile.exists()) {
            this.createFile(configFile);
            return;
        }
        JsonObject newConfig = this.defaultConfig;
        try {
            FileWriter writer = new FileWriter(configFile);
            try {
                newConfig.addProperty(KeyNames.Proxy.name, this.ModelProxy);
                newConfig.addProperty(KeyNames.ModelType.name, this.ModelType);
                newConfig.addProperty("lang", this.Language);
                JsonObject geminiConfig = newConfig.get("gemini").getAsJsonObject();
                geminiConfig.addProperty("api_key", this.GeminiApiKey);
                geminiConfig.addProperty("model", this.GeminiModelName);
            }
            catch (Exception e) {
                System.err.print(e.getMessage());
            }
            writer.append(new GsonBuilder().setPrettyPrinting().serializeNulls().create().toJson(newConfig));
            writer.close();
        }
        catch (IOException e) {
            InfiniteCraft.LOGGER.error(e.getMessage());
        }
    }

    private void createFile(File configFile) {
        try {
            configFile.createNewFile();
            if (configFile.canWrite()) {
                FileWriter writer = new FileWriter(configFile);
                writer.append(new GsonBuilder().setPrettyPrinting().serializeNulls().create().toJson(this.defaultConfig));
                writer.close();
            }
        }
        catch (Exception e) {
            InfiniteCraft.LOGGER.error(e.getMessage());
        }
    }

    private File getConfigFile() {
        return new File("config/InfiniteCraft.json");
    }

    public String toString() {
        return "Model Type: %s, Proxy Type: %s, Language: %s".formatted(this.ModelType, this.ModelProxy, this.Language);
    }

    private static class KeyNames {
        public static final String GeminiJson = "gemini";
        public static final String GeminiApiKey = "api_key";
        public static final String GeminiModelName = "model";
        public static final String Language = "lang";
        public static final StringOptions Proxy = new StringOptions("proxy", Set.of("none", "system"), "none");
        public static final StringOptions ModelType = new StringOptions("model", Set.of("none", "gemini", "ollama"), "none");

        private KeyNames() {
        }

        public static class StringOptions {
            public String name;
            public String defaultValue;
            public Set<String> options;

            StringOptions(String _name, Set<String> _options, String _default) {
                this.name = _name;
                this.defaultValue = _default;
                this.options = _options;
            }

            public String get(String ori) {
                if (ori == null || this.options.contains(ori)) {
                    return ori;
                }
                return this.defaultValue;
            }
        }
    }
}

