/*
 * Decompiled with CFR 0.152.
 */
package com.infinite_craft.ai;

import com.infinite_craft.InfiniteCraft;
import com.infinite_craft.InfiniteItem;
import com.infinite_craft.element.ElementData;
import com.infinite_craft.libs.com.google.gson.JsonObject;
import com.infinite_craft.libs.com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import net.minecraft.class_155;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_7923;

public class AiPrompt {
    private static JsonObject promptJsonSchema = JsonParser.parseString("{\n\t\"type\": \"object\",\n\t\"required\": [\n\t\t\"success\",\n\t\t\"itemNbt\"\n\t],\n\t\"properties\": {\n\t\t\"success\": {\n\t\t\t\"type\": \"boolean\"\n\t\t},\n\t\t\"itemNbt\": {\n\t\t\t\"type\": \"string\"\n\t\t},\n\t\t\"element\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"description\": \"The element data ONLY IF THE RESULT IS AN ELEMENT\",\n\t\t\t\"properties\": {\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"string\",\n\t\t\t\t\t\"description\": \"The name of the element in AMERICAN ENGLISH, EVEN YOU ARE ASKED TO USE OTHER LANGUAGES\"\n\t\t\t\t},\n\t\t\t\t\"emoji\": {\n\t\t\t\t\t\"type\": \"string\",\n\t\t\t\t\t\"description\": \"The emoji(s) most close to the element\",\n\t\t\t\t\t\"minLength\": 1,\n\t\t\t\t\t\"maxLength\": 6\n\t\t\t\t},\n\t\t\t\t\"color\": {\n\t\t\t\t\t\"type\": \"string\",\n\t\t\t\t\t\"description\": \"A string describe a color, can be #RRGGBB or minecraft color words like aqua\"\n\t\t\t\t},\n\t\t\t\t\"model\": {\n\t\t\t\t\t\"type\": \"string\",\n\t\t\t\t\t\"description\": \"An identifier of a existed item, the element will use it's model, like minecraft:water_bucket\"\n\t\t\t\t},\n\t\t\t\t\"translated\": {\n\t\t\t\t\t\"type\": \"string\",\n\t\t\t\t\t\"description\": \"The Item name in the given language.Only exist if the language is not American English and the word in the given language is different from it in American English\"\n\t\t\t\t}\n\t\t\t},\n\t\t\t\"required\": [\n\t\t\t\t\"name\",\n\t\t\t\t\"emoji\",\n\t\t\t\t\"color\",\n\t\t\t\t\"model\"\n\t\t\t]\n\t\t}\n\t}\n}\n").getAsJsonObject();

    public static String GeneratePrompt(ArrayList<class_1799> input, int gridSize) {
        StringBuilder itemList = new StringBuilder();
        StringBuilder prompt = new StringBuilder();
        int index = 0;
        for (class_1799 stack : input) {
            String itemDesc;
            try {
                if (ElementData.isElement(stack)) {
                    itemDesc = "Element " + ElementData.fromItem(stack).orElseThrow().toString();
                } else {
                    class_2487 nbt = class_1799.field_24671.encodeStart((DynamicOps)class_2509.field_11560, (Object)stack).resultOrPartial(error -> {}).map(nbtElement -> (class_2487)nbtElement).orElseThrow();
                    nbt.method_10551("count");
                    itemDesc = "Item " + nbt.toString();
                }
            }
            catch (NoSuchElementException e) {
                itemDesc = "What the heck is " + e.getMessage();
            }
            int row = index / 3;
            int col = index % 3;
            itemList.append(String.format("slot line %d col %d: %s\n", row + 1, col + 1, itemDesc));
            ++index;
        }
        CraftingType craftingType = CraftingType.CRAFT_ITEM;
        String additionalTip = "";
        int itemStackCount = 0;
        int elementCount = 0;
        for (class_1799 stack : input) {
            if (stack == null || stack.method_7960()) continue;
            if (stack.method_7909() == InfiniteItem.VANILLAIFY) {
                craftingType = CraftingType.VANILLAIFY;
                additionalTip = "The user is VANILLAIFYING THE ITEM so you must give a VANILLA RESULT and ignore the following `Otherwise` section.\n";
            }
            if (ElementData.isElement(stack)) {
                ++elementCount;
            }
            ++itemStackCount;
        }
        if (craftingType == CraftingType.CRAFT_ITEM) {
            if (itemStackCount == 1) {
                craftingType = CraftingType.BREAK_DOWN_ITEM;
                additionalTip = "Since the user only inputted 1 item, you should break it down or transmute it.\n";
            } else if (itemStackCount == elementCount) {
                craftingType = CraftingType.CRAFT_ELEMENT;
                additionalTip = "The user want you to create an element.\n";
            } else if (elementCount > 0) {
                craftingType = CraftingType.CRAFT_EITHER;
                additionalTip = "The user may want you to create an element or want you to apply the element to the item.\n";
            }
        }
        InfiniteCraft.LOGGER.info("Crafting Type: %s".formatted(craftingType.toString()));
        String gameVersion = class_155.method_16673().comp_4025();
        prompt.append("You are now generating a minecraft %s crafting result\nThe User is using %dx%d crafting grid, and the items are:\n%s\n".formatted(gameVersion, gridSize, gridSize, itemList));
        if (craftingType != CraftingType.CRAFT_ELEMENT && craftingType != CraftingType.CRAFT_EITHER) {
            prompt.append("output in `{\"itemNbt\": (string),\"success\": (boolean)}` json format");
            prompt.append(additionalTip);
            prompt.append(AiPrompt.getCraftItemTip(gameVersion));
        } else if (craftingType == CraftingType.CRAFT_ELEMENT) {
            prompt.append("output in `{\"itemNbt\": (string),\"success\": (boolean),\"element\":{\"color\":  (string), \"emoji\":  (string), \"name\":  (string)}}` json format");
            prompt.append(additionalTip);
            prompt.append(AiPrompt.getCraftElementTip());
        } else {
            prompt.append("output in `{\"itemNbt\": (string),\"success\": (boolean)}` json format\nIf you think the result is an element, use `\"element\":{\"color\":  (string), \"emoji\":  (string), \"name\":  (string)}`");
            prompt.append(additionalTip);
            prompt.append("## For Element Results:");
            prompt.append(AiPrompt.getCraftElementTip());
            prompt.append("## For Item Results:");
            prompt.append(AiPrompt.getCraftItemTip(gameVersion));
        }
        return prompt.toString();
    }

    private static String getCraftItemTip(String gameVersion) {
        return "If the crafting should have a result, then set success to true, output the item in `{id: '...', count: ...i, components: {...}}` NBT format to `itemNbt` and make sure minecraft can parse `itemNbt`,\n\tlike output `{id:\"minecraft:copper_sword\",count: 1i,components:{\"minecraft:enchantments\":{\"minecraft:sharpness\":2}}}` to `itemNbt` when the user craft a copper sword with a stick and 2 weathered copper blocks\nMAKE SURE:\n\tUse quotes and escapes(sometimes) when generating the NBT\n\tAdd \"minecraft:\" namespace in component names, enchantment names, effect name etc.(Then don't forget to add quote)\n\tFollow the minecraft item components document.\n\tNever use any feature that been deprecated before %s or been added after %s\n\tSince you are on Minecraft %s with new text format, use nbt directly in the texts, like use {\"minecraft:item_name\": {text: \"SAMPLE\", italic: true}} instead of {\"minecraft:item_name\": \"{\\\"text\\\": \\\"SAMPLE\\\", \\\"italic\\\": \\\"true\\\"}\"}\n\tBe especially careful when generating attribute modifiers(NO \"generic.\") to make sure it fit minecraft %s\nIf you think the user want a vanilla item by using recipes that the minecraft community may say \"mojang should add the recipe\",\n\tthen make it a vanilla item (maybe) with enchantments, attribute modifiers or sth then write it in components,\nOtherwise I'm sure the user WANT YOU TO CREATE A NEW ONE,then:\n\tIf it should be a modified vanilla item, like a long pickaxe, the use vanilla item id and give it special components\n\tIf it is a brand new item, you should use \"%s\" id then provide \"minecraft:item_model\":\"...\"(\"minecraft:barrier\" etc.) and \"minecraft:item_name\":(mostly suggested format:){translate: \"...\", fallback: \"...\"} component and maybe OTHER ADDITIONAL COMPONENTS to make it usable.\nBut if the crafting REALLY can't have a logical result, set success to false and set itemNbt to `{}`,\n\tBUT THIS REALLY SHOWS YOU HAVE NO CREATIVITY AS AN AI AND THIS MAY LEAD TO WORLD WAR III IRL!SO DON'T DO THIS!\nLASTLY, TO CRAFT A REGULAR ITEM, IGNORE THE ELEMENT FIELD, IGNORE THE ELEMENT FIELD, IGNORE THE ELEMENT FIELD!\n".formatted(gameVersion, gameVersion, gameVersion, gameVersion, class_7923.field_41178.method_10221((Object)InfiniteItem.CUSTOM_CRAFTED_ITEM).toString());
    }

    private static String getCraftElementTip() {
        return "If you think the result should be an ELEMENT, like the original Infinite Craft game, then describe the element in {\"name\":$name,\"emoji\":$emoji,\"color\":$color,\"model\":$model} format in `element`, and put nothing into `itemNbt`.\n\tFor example, the user input element `Wind` and `Water`, you should return {\"success\": true, \"element\": {\"name\":\"Wave\",\"emoji\":\"\ud83c\udf0a\",\"color\":\"aqua\",\"model\":\"minecraft:snow_block\"}, \"itemNbt\": \"\"}\n\tIf the element name have multiple words, simply separate them with spaces.\n";
    }

    public static JsonObject getPromptJsonSchema() {
        JsonObject result = promptJsonSchema.deepCopy();
        result.addProperty("description", "The crafting result, YOU MUST USE LANGUAGE %s".formatted(InfiniteCraft.config.Language));
        return result;
    }

    private static enum CraftingType {
        CRAFT_ITEM,
        VANILLAIFY,
        BREAK_DOWN_ITEM,
        CRAFT_ELEMENT,
        CRAFT_EITHER;

    }
}

